;;; -*- Mode: LISP; Syntax: Zetalisp; Package: ZWEI; Base: 10; Patch-file: T -*-


;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> 
;;;> The Thinking Machines *Lisp Simulator is in the public domain.
;;;> You are free to do whatever you like with it, including but
;;;> not limited to distributing, modifying, and copying.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com.  Other than to Thinking Machines'
;;;> customers, no promise of support is intended or implied.
;;;>
;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+

;;; Author:  JP Massar.


;;; Of course at some point *LISP should have its syntax mixin
;;; A hack to make *DEF indicate a function definition as does DEFUN
(DEFMETHOD (:QUICK-DEFINITION-LINE-P LISP-SYNTAX-MIXIN) (LINE)
  (or (STRING-EQUAL LINE "(DEF" 0 0 4 4)
      (STRING-EQUAL LINE "(*DEF" 0 0 4 4)))

(DEFMETHOD (:SECTION-NAME LISP-SYNTAX-MIXIN) (LINE TEMP-BP IGNORE)
  (IF (LET ((LENGTH (LINE-LENGTH LINE)))
	(AND (> LENGTH 1) (CHAR-EQUAL (AREF LINE 0) #/()
	     (OR (AND (%STRING-EQUAL LINE 1 "DEF" 0 3)
		      (NOT (%STRING-EQUAL LINE 4 "PROP " 0 5)))	;"(DEFPROP "
		 (%string-equal line 1 "*DEF" 0 4)
		 (LET ((COLON (%STRING-SEARCH-CHAR #/: LINE 1 LENGTH)))
		   (AND COLON (%STRING-EQUAL LINE (1+ COLON) "DEF" 0 3)
			(LOOP FOR I FROM 1 BELOW COLON
			      ALWAYS (= (LIST-SYNTAX (AREF LINE I)) LIST-ALPHABETIC)))))))
      (GET-DEFINITION-FUNCTION-SPEC TEMP-BP)	;removed (MOVE-BP TEMP-BP LINE 0)
    (VALUES NIL NIL NIL T)))

(DEFPROP *DEFUN DEFUN DEFINITION-FUNCTION-SPEC-TYPE)

;;; Hopefully make the warning about :MUSER go away at non-tmc sites.

#-tmc
(setf (get :muser 'fs:known-file-attribute) t)
