;; ** This is a transcript of a Lisp Session
;; ** with comments separately typed in.
;; ** Comments so inserted will appear as on
;; ** this line, with two semicolons and then
;; ** two stars.

;; ** The intent of this session is to demonstrate
;; ** some of the basic constructs of Lisp and how
;; ** they match up with similar constructs in 'C'.

;; ** This session was invoked by typing
;; ** /cm/bin/starlisp-simulator
;; ** at a Unix prompt.  In order to reproduce
;; ** this you will need to know how to invoke
;; ** the *Lisp simulator at your site.


;;; Sun Common Lisp, Development Environment 3.0.1, 21-Sep-89
;;; Sun-4 Version for SunOS 4.0 
;;;
;;; Copyright (c) 1985, 1986, 1987, 1988 by Sun Microsystems, Inc., All Rights Reserved
;;; Copyright (c) 1985, 1986, 1987, 1988 by Lucid, Inc., All Rights Reserved
;;;
;;; This software product contains confidential and trade secret
;;; information belonging to Sun Microsystems.  It may not be copied
;;; for any reason other than for archival and backup purposes.

;;;         Lisp World: lcmw
;;;            Created: Thursday, 21 September 1989 at 21:58:51 EDT
;;;    Produced within: SunOS Release 4.0 (CMSUN4) #29: Tue Jun 20 19:49:02 EDT 1989

;;;
;;; User World: starlisp-simulator+patches
;;;    Created: Friday, 22 September 1989 at 21:45:59 EDT

;; ** The CM software is set up to load patches if necessary.
;; ** Here, two patch files are being loaded.
;; ** This probably won't happen at your site.

;;; Loading source file "/cm/patch/initializations.lisp"
;;; Loading binary file "/cm/utility/gmacs-macroexpand-all.sbin3"

;; ** Finally, it loads my initialization file.
;; ** If you have a file called "lisp-init.lisp" in your
;; ** home directory Lisp will load that file automatically
;; ** for you when you start Lisp up.

;;; Loading source file "lisp-init.lisp"

;; ** Now Lisp is ready to go and indicates this with a prompt, '>'.
;; ** I tell it to load in a file with two simple functions in it.
;; ** This file is in a separate handout.  Loading a file with
;; ** function definitions in it causes Lisp to be able to execute
;; ** those functions at your command. 

;; ** Look at the file and notice how functions are defined
;; ** using DEFUN.  Ignore the IN-PACKAGE statement for now. 


> (load "/cm/aux/stc/lisp-examples")
;;; Loading source file "/cm/aux/stc/lisp-examples.lisp"
#P"/cm/aux/stc/lisp-examples.lisp"

;; ** Try them out.
;; ** In Lisp, functions come first, then arguments.
;; ** Everything is always surrounded by parentheseses.

> (my-add 3 4)
7

> (hypotenuse 3.0 4.0)
5.0


;; ** Demonstrating PROGN, the 'begin-end' block of Lisp.

;; ** C CODE:
;; ** { printf("\nhello there!\n"); hypotenuse(4.0,5.0); }

> (progn (print "hello there!") (hypotenuse 4.0 5.0))

"hello there!" 
6.4031242374328485

;; ** All forms, including PROGN, return values.
;; ** PROGN returns what the last expression in it returns.

> (+ 1.0 (progn (print "hello there!") (hypotenuse 3.0 4.0)))

"hello there!" 
6.0

;; ** Demonstrating LET, which allows local variables
;; ** to be allocated and initialized.

;; ** C CODE:
;; { float x = 3.0; float y = 4.0; hypotenuse(x,y); }

> (let ((x 3.0) (y 4.0)) (hypotenuse x y))
5.0

;; ** Demonstrating DOTIMES, one of the basic iteration
;; ** forms of Common Lisp.

;; ** C code
;; { int sum = 0; for (j = 0; j < 10; j++) sum+=j; (printf("\n%d\n",sum); }

> (let ((sum 0)) (dotimes (j 10) (incf sum j)) sum)
45

;; ** Defining constants in Lisp.

;; ** C CODE:
;; ** #define WHITE 0
;; ** #define BLACK 0

(defconstant WHITE 0)
0
(defconstant BLACK 1)
1

;; ** I can generate a random number between 0 and N-1 inclusive
;; by calling the Lisp function RANDOM

(random 3)
2
(random 3)
0


;; ** Demonstrating IF, the basic conditional of Common Lisp.

;; ** C CODE:
;; ** if (random(3) < 2) return(WHITE); else return(BLACK);

;; ** ALTERNATIVE VERSION OF C CODE:
;; ** return((random(3) < 0.5) ? WHITE : BLACK);

> (if (< (random 3) 2) WHITE BLACK)
0
> (if (< (random 3) 2) WHITE BLACK)
1

;; ** Demonstrating CASE, equivalent to SWITCH in 'C'
;; ** except that you do not fall through automatically.
;; ** (You don't need the equivalent of 'break' to
;; ** prevent execution of the next statement)

> (let ((x (random 3)))
    (case x
      (0 "the high road")
      (1 "the low road")
      (2 "stay home and watch TV")
      ))
"stay home and watch TV"


;; ** Defining global variables.  You can also use DEPARAMETER

;; C CODE:
;; int global_variable = 17;

> (defvar *global-variable* 17)
*GLOBAL-VARIABLE*

> *global-variable*
17


;; ** Looping forever

;; ** C CODE:
;; while (1) {x = x + 1; y = y + 2; }

(loop
  (setq x (+ x 1))
  (setq y (+ y 1))
  )

;; ** The above form just executes forever!
;; ** you can stop it by hitting CONTROL-C

>>Break: Keyboard interrupt

LUCID-COMMON-LISP:INTERRUPT-PROCESS:
   Required arg 0 (PROCESS): #<Process Initial BAC74E>
   Required arg 1 (FUNCTION): #<Compiled-Function LUCID::DO-KEYBOARD-INTERRUPTION 439FDE>
   Rest arg 2 (ARGS): NIL
:C  0: Return from Break
:A  1: Abort to Lisp Top Level

;; ** Then you type :a to tell it to
;; ** forget about what it is doing and let
;; ** you start over.

-> :a
Abort to Lisp Top Level
Back to Lisp Top Level

> 

;; ** WHEN in Lisp is like IF, except that
;; ** there is no ELSE clause.

;; ** C CODE:
;; int x = 5;
;; int y = 3;
;; int z = 0;
;; if (x < y) z++;

(let ((x 5) (y 3) (z 0))
  (when (< x y) (incf z))
  )
0

;; ** One uses RETURN-FROM to return from
;; ** a function while in the middle of it.  

;; ** C CODE:
;; ** int how_many_until_too_small (limit) float limit;
;; ** { int n = 0;
;; **   while (random(100) < limit) n++;
;; **   return(n);
;; ** }  


> (defun how-many-until-too-small (limit)
    (let ((n 0))
      (loop
	(when (< (random 100) limit)
	  (return-from how-many-until-too-small n)
	  )
	(incf n)
	)))
HOW-MANY-UNTIL-TOO-SMALL

> (how-many-until-too-small 20)
0
> (how-many-until-too-small 20)
3
> (how-many-until-too-small 10)
10

;; ** Compiling a function definition.
;; ** This makes it run faster because the
;; ** code is translated from Lisp into machine language.

> (compile 'how-many-until-too-small)
;;; You are using the compiler in development mode (compilation-speed = 3)
;;; Generation of full safety checking code is enabled (safety = 3)
;;; Optimization of tail calls is disabled (speed = 2)
HOW-MANY-UNTIL-TOO-SMALL

;; ** Compiling an entire file.
;; ** The entire file is translated in a machine language binary
;; ** which is equivalent to the lisp source file.

> (compile-file "/cm/aux/stc/lisp-examples")
;;; Reading source file "/cm/aux/stc/lisp-examples.lisp"
;;; Writing binary file "/cm/aux/stc/lisp-examples.sbin3"
#P"/cm/aux/stc/lisp-examples.sbin3"

;; ** Loading a compiled file.
;; ** You can load compiled files into Lisp just like
;; ** you can load files with Lisp code int them into Lisp.

> (load "/cm/aux/stc/lisp-examples")
;;; Loading binary file "/cm/aux/stc/lisp-examples.sbin3"
#P"/cm/aux/stc/lisp-examples.sbin3"


;; ** Packages are Lisp's way of keeping functions which
;; ** belong in a common place together.  For instance,
;; ** all of the functions that make up the *Lisp language
;; ** belong to a single package, which has the name "*LISP".

;; ** By default, Lisp is in the "USER" package.  To
;; ** change packages, use IN-PACKAGE.  If you are in
;; ** one package and try to call a function in another
;; ** package, Lisp will not like that.

;; ** For instance, we are in the "USER" package now.
;; ** If we try to execute a *Lisp function called *COLD-BOOT,
;; ** Lisp says it doesn't know about the function.

> (*cold-boot)
>>Error: The function *COLD-BOOT is undefined.

SYMBOL-FUNCTION:
   Required arg 0 (S): *COLD-BOOT
:C  0: Try evaluating #'*COLD-BOOT again
:A  1: Abort to Lisp Top Level

;; ** We have entered the debugger.
;; ** To get out, type the option to ABORT.

-> :a
Abort to Lisp Top Level
Back to Lisp Top Level

;; ** Switch to the *Lisp package and try again.
;; ** Now Lisp knows about the *COLD-BOOT function.

;; ** The lesson is, to use *LISP, put yourself into
;; ** the *LISP package.

> (in-package '*lisp)
#<Package "*SIM" 9304B6>
> (*cold-boot)


Thinking Machines Starlisp Simulator.  Version 16.0

1
(8 4)
> 


;; Arrays.  MAKE-ARRAY creates an array.

;; ** C CODE:
;; int my_array[10];

(setq my-array (make-array 10))
#<Simple-Vector T 10 13024CE>

;; ** C CODE:
;; int my_array_two[10][10];

(setq my-array (make-array '(10 10)))
#<Simple-Array T (10 10) 1307276>

;; ** Use SETF and AREF to store a value into an
;; ** element of an array.  Use AREF to extract
;; ** an element out of an array.

;; C CODE:
;; my_array[5] = 3;

(setf (aref my-array 5) 3)
3

;; C CODE:
;; result = my_array[5];

(setq result (aref my-array 5))
3


;; ** Lists

;; ** Lists are unlike any basic C data structure.
;; ** A list is just a sequence of 'things' surrounded
;; ** by parentheses.  (a b c) is a list of 3 things.
;; ** If I type (+ 3 5)

(+ 3 5)
8

;; ** I get a result, 8.  But (+ 3 5) is a list of
;; ** three things too.  So Lisp looks at lists and
;; ** treats the first object in the list as a function,
;; ** and the rest of the objects as the function's
;; ** arguments.  If I want to use a list as a data
;; ** structure instead of having Lisp treat it as
;; ** a function to be called, I need to quote the
;; ** list, with the symbol '.

'(a b c)
(a b c)

;; ** The ' prevents Lisp from thinking that A is
;; ** a function to be called with arguments B and C,
;; ** and just returns the list intact.

;; ** You can pull lists apart and put them together.

(first '(a b c))
a

(second '(a b c))
b

(rest '(a b c))
(b c)

(cons 'a '(b c))
(a b c)

(append '(a b c) '(d e f))
(a b c d e f)

;; *** It is perfectly legal to have an empty list.
;; *** An empty list is written as ()
;; *** The empty list is also referred to as NIL.
;; *** So () and NIL are exactly identical.

(rest '(a))
()

;; *** You can test for an empty list by calling
;; *** the function NULL

(null ())
T

(null '(a))
NIL

(null NIL)
T

;; *** As you can see, peculiar to Lisp, the empty
;; *** list, i.e, NIL, also serves as the value
;; *** for falsehood.  Any function which returns
;; *** true or false returns T or NIL in Lisp.

(< 3 4)
T

(< 4 3)
NIL


;; ** One can operate on each element of a list
;; ** as if at the same time:

(mapcar '1+ '(3 4 5))
(4 5 6)

;; ** Here the function 1+ is used on each element
;; ** of the list and a new list is returned which
;; ** is the collection of the results.

(mapcar '* '(1 2 3) '(3 4 5))
(3 8 15)

;; ** Lists are extremely useful for keeping track
;; ** of things, especially when you don't know
;; ** how many things you will have or want.

;; ** One the other hand, lists are not used as a
;; ** data structure inside the Connection Machine
;; ** using *Lisp.


;; *** Structures
;; Structures are very similar to C structures.


;; C CODE
;; struct person_info { int age; double height; }

(defstruct person-info 
  age
  height
  )
PERSON-INFO

;; C CODE
;; { struct person_info pinfo;
;;   person_info.age = 10;
;;   x = person_info.age
;; }

(let ((pinfo (make-person-info)))
  (setf (person-info-age pinfo) 10)
  (setq x (person-info-age pinfo))
  )
10
