;;; -*- Mode: LISP; Syntax: Common-lisp; Package: (*SIM-I COMMON-LISP-GLOBAL); Base: 10 -*-
;;; (c) Copyright 1987, JP Massar Thinking Machines Corporation, Inc.

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> Copyright 1986 Thinking Machines Corporation, Inc. of Cambridge, Massachusetts.
;;;> 
;;;> Permission is hereby granted to copy this source onto any machine at a site
;;;> which legitimately has this software, and to execute the resulting object
;;;> code on any machine at a site which legitimately has this software.

;;;> Permission is hereby granted to make such changes as are necessary to port this
;;;> source to a version of Common Lisp running on any machine so long as said changes
;;;> are sent back to Thinking Machines so that they may be incorporated in future
;;;> releases.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com

;;;> The *Lisp Simulator was written by JP Massar.
;;;> The *Lisp language was designed by Cliff Lasser and Steve Omohundro, with
;;;> help from may others at Thinking Machines Corporation.

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+


;;;; *****     WARNING WARNING WARNING WARNING WARNING WARNING      *****
;;;;
;;;; This code is shared between the *Lisp Interpreter and the
;;;; *Lisp Simulator.  DO NOT MAKE CHANGES IN THIS CODE UNLESS
;;;; YOU ARE ABSOLUTELY SURE THE CHANGES APPLY EQUALLY TO BOTH
;;;; SYSTEMS OR YOU ARE VERY CAREFUL TO CONDITIONALLY COMPILE!
;;;; VIOLATE THIS WARNING AT YOUR OWN RISK!
;;;;
;;;; *****     WARNING WARNING WARNING WARNING WARNING WARNING      *****


;;; Author:  JP Massar


(in-package '*SIM-i)

  
;MAKE-ARRAY!!
;!!
;*LET
;*LET*
;ALLOCATE!!
;*PROCLAIM
;VECTOR!!
;TYPED-VECTOR!!
;AREF!!
;SVREF!!
;BIT!!
;SBIT!!
;*SETF-AREF!!
;*SETF-SVREF!!
;*SETF-BIT
;*SETF-SBIT
;*ARRAY-ELEMENT-TYPE
;*ARRAY-ELEMENT-TYPES
;*ARRAY-RANK
;ARRAY-RANK!!
;*ARRAY-DIMENSION
;ARRAY-DIMENSION!!
;*ARRAY-DIMENSIONS
;ARRAY-DIMENSIONS!!
;*ARRAY-TOTAL-SIZE
;ARRAY-TOTAL-SIZE!!
;ARRAY-IN-BOUNDS-P!!
;ARRAY-ROW-MAJOR-INDEX!!
;*ADJUSTABLE-ARRAY-P
;ADJUSTABLE-ARRAY-P!!
;BIT-AND!!
;BIT-IOR!!
;BIT-XOR!!
;BIT-EQV!!
;BIT-NAND!!
;BIT-NOR!!
;BIT-ANDC1!!
;BIT-ANDC2!!
;BIT-ORC1!!
;BIT-ORC2!!
;BIT-NOT!!
;ARRAY-PVAR-P
;VECTOR-PVAR-P
;*ARRAYP
;*VECTORP
;ARRAYP!!
;VECTORP!!
;*ARRAY-HAS-FILL-POINTER-P
;ARRAY-HAS-FILL-POINTER-P!!
;*MAP


(defun-wco test-array-properties (array-pvar rank dimensions element-type)
  (let ((real-rank (*array-rank array-pvar))
	(real-dimensions (*array-dimensions array-pvar))
	(real-total-size (*array-total-size array-pvar))
	(real-first-dimension (*array-dimension array-pvar 0))
	(real-element-type (*array-element-type array-pvar))
	)
    (assert (eql real-rank rank))
    (assert (equal real-dimensions dimensions))
    (assert (eql real-total-size (reduce #'* dimensions)))
    (assert (eql real-first-dimension (first dimensions)))
    (assert (equal real-element-type (canonical-pvar-type element-type)))
    (assert (*and (=!! (!! real-rank) (array-rank!! array-pvar))))
    (assert (*and (=!! (!! real-total-size) (array-total-size!! array-pvar))))
    (assert (*and (=!! (!! real-first-dimension) (array-dimension!! array-pvar (!! 0)))))
    (if (not (zerop real-first-dimension))
	(progn
	  (assert (*and (apply #'array-in-bounds-p!! array-pvar (mapcar #'(lambda (x) (!! 0)) dimensions))))
	  (assert (*and (apply #'array-in-bounds-p!! array-pvar (mapcar #'(lambda (x) (!! (1- x))) dimensions))))
	  )
	(progn
	  (assert (not (*or (apply #'array-in-bounds-p!! array-pvar (mapcar #'(lambda (x) (!! 0)) dimensions)))))
	  (assert (not (*or (apply #'array-in-bounds-p!! array-pvar (mapcar #'(lambda (x) (!! (1- x))) dimensions)))))
	  ))
    (assert (not (*or (apply #'array-in-bounds-p!! array-pvar (mapcar #'(lambda (x) (!! x)) dimensions)))))
    ))

(defun-wco fill-array-pvar-by-counting (array-pvar)
  (let ((count 1))
    (*map
      #'(lambda (element-pvar)
	  (*setf element-pvar (!! count))
	  (incf count)
	  )
      array-pvar
      )))

(defun-wco test-array-pvar-filled-by-counting (array-pvar)
  (let ((count 1))
    (*map
      #'(lambda (element-pvar)
	  (assert (*and (=!! (!! count) element-pvar)))
	  (incf count)
	  )
      array-pvar
      )))


(*defun test-array-element-eql-to (array-pvar to scalar-indices)
  (compiler-let ((*compilep* nil))
    (assert (*and (eql!! (!! to) (apply #'aref!! array-pvar (mapcar #'!! scalar-indices)))))))

(defun-wco test-all-array-pvar-elements-eql-to (array-pvar to)
  (*map
    #'(lambda (element-pvar) (assert (*and (=!! (!! to) element-pvar))))
    array-pvar
    ))




(defun-wco test-array-creation-and-properties ()

  (format t "~%Testing creation and properties of array pvars, including~%")
  (format t "  *array-rank,*array-dimensions,*array-dimension,*array-total-size,~%")
  (format t "  *array-element-type,array-rank!!,array-dimension!!,array-total-size!!~%")

  (flet

    ((test-properties (tag type x y z x2 y2 z2 x3)
       tag
       (test-array-properties x 1 '(0) type)
       (test-array-properties y 1 '(1) type)
       (test-array-properties z 1 '(4) type)
       (test-array-properties x2 2 '(0 0) type)
       (test-array-properties y2 2 '(1 1) type)
       (test-array-properties z2 2 '(3 4) type)
       (test-array-properties x3 3 '(2 3 2) type)
       (mapc #'(lambda (array) (test-all-array-pvar-elements-eql-to array 0)) (list x y z x2 y2 z2 x3))
       ))

  (*all

    ;; test creation via !!

    #+*LISP-HARDWARE

    (*let ()
      (let ((y (!! '#(0)))
	    (z (!! '#(0 0 0 0)))
	    (y2 (!! (make-array '(1 1) :initial-element 0)))
	    (z2 (!! (make-array '(3 4) :initial-element 0)))
	    (x3 (!! (make-array '(2 3 2) :initial-element 0.0)))
	    )
	(test-array-properties y 1 '(1) '(pvar (unsigned-byte 1)))
	(test-array-properties z 1 '(4) '(pvar (unsigned-byte 1)))
	(test-array-properties y2 2 '(1 1) '(pvar (unsigned-byte 1)))
	(test-array-properties z2 2 '(3 4) '(pvar (unsigned-byte 1)))
	(test-array-properties x3 3 '(2 3 2) '(pvar single-float))
	(format t "Tested !! for arrays~%")
	))


    ;; test creation via make-array!!

    (*let ()
      (let ((x (make-array!! '(0) :element-type '(pvar (unsigned-byte 32)) :initial-element (!! 0)))
	    (y (make-array!! '(1) :element-type '(pvar (unsigned-byte 32)) :initial-element (!! 0)))
	    (z (make-array!! '(4) :element-type '(pvar (unsigned-byte 32)) :initial-element (!! 0)))
	    (x2 (make-array!! '(0 0) :element-type '(pvar (unsigned-byte 32)) :initial-element (!! 0)))
	    (y2 (make-array!! '(1 1) :element-type '(pvar (unsigned-byte 32)) :initial-element (!! 0)))
	    (z2 (make-array!! '(3 4) :element-type '(pvar (unsigned-byte 32)) :initial-element (!! 0)))
	    (x3 (make-array!! '(2 3 2) :element-type '(pvar (unsigned-byte 32)) :initial-element (!! 0)))
	    )
	(test-properties 'make-array!! '(pvar (unsigned-byte 32)) x y z x2 y2 z2 x3)
	(format t "Tested make-array!!~%")
	))

    ;; test creation via allocate!!

    (*let ()
      (let ((x (allocate!! nil nil '(pvar (array (unsigned-byte 32) (0)))))
	    (y (allocate!! (!! (make-array '(1) :initial-element 0)) nil '(pvar (array (unsigned-byte 32) (1)))))
	    (z (allocate!! (!! (make-array '(4) :initial-element 0)) nil '(pvar (array (unsigned-byte 32) (4)))))
	    (x2 (allocate!! nil nil '(pvar (array (unsigned-byte 32) (0 0)))))
	    (y2 (allocate!! (!! (make-array '(1 1) :initial-element 0)) nil '(pvar (array (unsigned-byte 32) (1 1)))))
	    (z2 (allocate!! (!! (make-array '(3 4) :initial-element 0)) nil '(pvar (array (unsigned-byte 32) (3 4)))))
	    (x3 (allocate!! (!! (make-array '(2 3 2) :initial-element 0)) nil '(pvar (array (unsigned-byte 32) (2 3 2)))))
	    )
	(test-properties 'allocate!! '(pvar (unsigned-byte 32)) x y z x2 y2 z2 x3)
	(mapcar #'*deallocate (reverse (list x y z x2 y2 z2 x3)))
	(format t "Tested allocate!! for arrays~%")
	))

    ;; test creation via *let

    (*let (x
	   (y (!! '#(0)))
	   (z (!! '#(0 0 0 0)))
	   x2
	   (y2 (!! (make-array '(1 1) :initial-element 0)))
	   (z2 (!! (make-array '(3 4) :initial-element 0)))
	   (x3 (!! (make-array '(2 3 2) :initial-element 0)))
	   )
      (declare (type (pvar (array (unsigned-byte 32) (0))) x))
      (declare (type (pvar (array (unsigned-byte 32) (1))) y))
      (declare (type (pvar (array (unsigned-byte 32) (4))) z))
      (declare (type (pvar (array (unsigned-byte 32) (0 0))) x2))
      (declare (type (pvar (array (unsigned-byte 32) (1 1))) y2))
      (declare (type (pvar (array (unsigned-byte 32) (3 4))) z2))
      (declare (type (pvar (array (unsigned-byte 32) (2 3 2))) x3))
      (test-properties '*let '(pvar (unsigned-byte 32)) x y z x2 y2 z2 x3)
      (format t "Tested *let for arrays~%")
      ))

  ;; test creation via vector!! and typed-vector!!

  (*let ((x (typed-vector!! '(pvar single-float)))
	 (y (typed-vector!! '(pvar (unsigned-byte 8)) (!! 0)))
	 (z (typed-vector!! '(pvar boolean) t!! t!! nil!! t!!))
	 )
    (declare (type (pvar (array single-float (0))) x))
    (declare (type (pvar (array (unsigned-byte 8) (1))) y))
    (declare (type (pvar (array boolean (4))) z))
    (test-array-properties x 1 '(0) '(pvar single-float))
    (test-array-properties y 1 '(1) '(pvar (unsigned-byte 8)))
    (test-array-properties z 1 '(4) '(pvar boolean))
    (test-array-element-eql-to y 0 '(0))
    (test-array-element-eql-to z t '(0))
    (test-array-element-eql-to z t '(1))
    (test-array-element-eql-to z nil '(2)) 
    (test-array-element-eql-to z t '(3))
    (format t "Tested typed-vector!!~%")
    )

  ))



(defun-wco test-array-element-access ()
  (format t "~%Testing array element access for 1 2 and 3d arrays~%")
  (*all
    (*let (array1 array2 array3)
      (declare (type (pvar (array (unsigned-byte 8) (3))) array1))
      (declare (type (pvar (array (signed-byte 8) (2 3))) array2))
      (declare (type (pvar (array (unsigned-byte 32) (2 3 4))) array3))
      (fill-array-pvar-by-counting array1)
      (fill-array-pvar-by-counting array2)
      (fill-array-pvar-by-counting array3)
      (let ((count 1))
	(dotimes (i (*array-dimension array1 0))
	  (*setf (aref!! array1 (!! i)) (!! count))
	  (incf count)
	  ))
      (let ((count 1))
	(dotimes (i (*array-dimension array1 0))
	  (assert (*and (=!! (aref!! array1 (!! i)) (!! count))))
	  (incf count)
	  ))
      (*setf (pref (aref!! array1 (!! 0)) 0) 5)
      (assert (eql 5 (pref (svref!! array1 (!! 0)) 0)))
      (format t "~%Done 1d")
      (let ((count 1))
	(dotimes (i (*array-dimension array2 0))
	  (dotimes (j (*array-dimension array2 1))
	    (*setf (aref!! array2 (!! i) (!! j)) (!! count))
	    (incf count)
	    )))
      (let ((count 1))
	(dotimes (i (*array-dimension array2 0))
	  (dotimes (j (*array-dimension array2 1))
	    (assert (*and (=!! (aref!! array2 (!! i) (!! j)) (!! count))))
	    (incf count)
	    )))
      (*setf (pref (aref!! array2 (!! 0) (!! 0)) 0) 5)
      (assert (eql 5 (pref (aref!! array2 (!! 0) (!! 0)) 0)))
      (format t "~%Done 2d")
      (let ((count 1))
	(dotimes (i (*array-dimension array3 0))
	  (dotimes (j (*array-dimension array3 1))
	    (dotimes (k (*array-dimension array3 2))
	      (*setf (aref!! array3 (!! i) (!! j) (!! k)) (!! count))
	      (incf count)
	      ))))
      (let ((count 1))
	(dotimes (i (*array-dimension array3 0))
	  (dotimes (j (*array-dimension array3 1))
	    (dotimes (k (*array-dimension array3 2))
	      (assert (*and (=!! (aref!! array3 (!! i) (!! j) (!! k)) (!! count))))
	      (incf count)
	      ))))
      (*setf (pref (aref!! array3 (!! 0) (!! 0) (!! 0)) 0) 5)
      (assert (eql 5 (pref (aref!! array3 (!! 0) (!! 0) (!! 0)) 0)))
      (format t "~%Done 3d")
      (*set array1 (!! (make-sequence 'vector (*array-dimension array1 0) :initial-element 5)))
      (*set array2 (!! (make-array (*array-dimensions array2) :initial-element 6)))
      (*set array3 (!! (make-array (*array-dimensions array3) :initial-element 7)))
      (test-all-array-pvar-elements-eql-to array1 5)
      (test-all-array-pvar-elements-eql-to array2 6)
      (test-all-array-pvar-elements-eql-to array3 7)
      )
    ))


(defun-wco test-indirect-array-element-access ()
  (format t "~%~%Testing indirect addressing for 1 and 2d arrays")
  (*let ((x (make-array!! '(10) :element-type '(pvar (unsigned-byte 8)) :initial-element (!! 0))))
    (declare (type (pvar (array (unsigned-byte 8) (10))) x))
    nil
    (*let ((index (mod!! (self-address!!) (!! 10))))
      (declare (type (pvar (unsigned-byte 32)) index))
      nil
      (*setf (aref!! x index) index)
      (*let ((indirect-result (aref!! x index)))
	(declare (type (pvar (unsigned-byte 32)) indirect-result))
	(assert (*and (=!! indirect-result index)))
	)))
  (format t "~%Done 1d")
  (*let ((y (make-array!! '(3 4) :element-type '(pvar (unsigned-byte 8)) :initial-element (!! 0))))
    (declare (type (pvar (array (unsigned-byte 8) (3 4))) y))
    nil
    (*let ((x-index (mod!! (self-address-grid!! (!! 0)) (!! 3)))
	   (y-index (mod!! (self-address-grid!! (!! 1)) (!! 4)))
	   )
      (declare (type (pvar (unsigned-byte 32)) x-index y-index))
      nil
      (*setf (aref!! y x-index y-index) (+!! x-index y-index))
      (*let ((indirect-result (aref!! y x-index y-index)))
	(declare (type (pvar (unsigned-byte 32))indirect-result))
	nil
	(assert (*and (=!! indirect-result (+!! x-index y-index))))
	)))
  (format t "~%Done 2d")
  t
  )
  

(defmacro generate-indirect-aset-test
	  (top-level-type
	   object-variable
	   (&rest index-variables)
	   (&rest index-limits)
	   accessing-form
	   value-form
	   )
  (assert (symbolp object-variable))
  (assert (and (eql (length index-variables) (length index-limits))))
  `(progn
     (format t "~%Testing *setf into variable of type ~A.  " ',top-level-type)
     (*compile ()
       (*when (<!! (self-address!!) (!! 10))
	 (*let (,object-variable ,@index-variables)
	   (declare (type ,top-level-type ,object-variable))
	   ,@(if index-variables `((declare (type (pvar (unsigned-byte 32)) ,@index-variables))))
	   nil
	   ,@(mapcar #'(lambda (var limit) `(*set ,var (random!! (!! (the fixnum ,limit))))) index-variables index-limits)
	   (*nocompile
	     (*setf ,accessing-form ,value-form)
	     (when (not (*and (=!! ,value-form ,accessing-form)))
	       (error "Indirect aset failed for form ~A" '(*setf ,accessing-form ,value-form))
	       )))))
     (format t "OK")
     ))


(defun-wco nested-indirect-test ()
  (format t "~%~%Testing indirect aset into nested arrays")
  (generate-indirect-aset-test
    (pvar (array (array (array (unsigned-byte 4) (2 2)) (3)) (5)))
    temp (x) (5)
    (aref!! (aref!! (aref!! temp x) (!! 0)) (!! 0) (!! 0))
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array (unsigned-byte 4) (2 2)) (3)) (5)))
    temp (x) (3)
    (aref!! (aref!! (aref!! temp (!! 0)) x) (!! 0) (!! 0))
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array (unsigned-byte 4) (2 2)) (3)) (5)))
    temp (x y) (2 2)
    (aref!! (aref!! (aref!! temp (!! 0)) (!! 0)) x y)
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array (unsigned-byte 4) (2 2)) (3)) (5)))
    temp (x y) (5 3)
    (aref!! (aref!! (aref!! temp x) y) (!! 0) (!! 0))
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array (unsigned-byte 4) (2 2)) (3)) (5)))
    temp (x y z) (5 2 2)
    (aref!! (aref!! (aref!! temp x) (!! 0)) y z)
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array (unsigned-byte 4) (2 2)) (3)) (5)))
    temp (x y z w) (5 3 2 2)
    (aref!! (aref!! (aref!! temp x) y) z w)
    (!! 1)
    ))


(defun-wco nested-indirect-slot-test ()
  (format t "~%~%Testing indirect aset into slot of nested arrays")
  (generate-indirect-aset-test
    (pvar (array (array (array foo (2 2)) (3)) (5)))
    temp (x) (5)
    (foo-a!! (aref!! (aref!! (aref!! temp x) (!! 0)) (!! 0) (!! 0)))
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array foo (2 2)) (3)) (5)))
    temp (x) (3)
    (foo-a!! (aref!! (aref!! (aref!! temp (!! 0)) x) (!! 0) (!! 0)))
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array foo (2 2)) (3)) (5)))
    temp (x y) (2 2)
    (foo-a!! (aref!! (aref!! (aref!! temp (!! 0)) (!! 0)) x y))
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array foo (2 2)) (3)) (5)))
    temp (x y) (5 3)
    (foo-a!! (aref!! (aref!! (aref!! temp x) y) (!! 0) (!! 0)))
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array foo (2 2)) (3)) (5)))
    temp (x y z) (5 2 2)
    (foo-a!! (aref!! (aref!! (aref!! temp x) (!! 0)) y z))
    (!! 1)
    )
  (generate-indirect-aset-test
    (pvar (array (array (array foo (2 2)) (3)) (5)))
    temp (x y z w) (5 3 2 2)
    (foo-a!! (aref!! (aref!! (aref!! temp x) y) z w))
    (!! 1)
    ))


(defun-wco simple-indirect-array-slot-test ()
  (generate-indirect-aset-test
    (pvar baz)
    temp (x) (3)
    (aref!! (baz-a!! temp) x)
    (!! 4)
    ))




(defun-wco general-indirect-array-and-structure-test ()
  (generate-indirect-aset-test
    (pvar (array nested (3)))
    temp (r1 r2) (3 3)
    (aref!! (baz-a!! (aref!! (nested-a!! (aref!! temp r1)) r2)) (!! 2))
    (!! 3)
    )
  (generate-indirect-aset-test
    (pvar (array nested (3)))
    temp (r1 r2 r3) (3 3 3)
    (aref!! (baz-a!! (aref!! (nested-a!! (aref!! temp r1)) r2)) r3)
    (!! 3)
    )
  (generate-indirect-aset-test
    (pvar (array nested (3)))
    temp (r2 r3) (3 3)
    (aref!! (baz-a!! (aref!! (nested-a!! (aref!! temp (!! 1))) r2)) r3)
    (!! 3)
    )
  (generate-indirect-aset-test
    (pvar (array nested (3)))
    temp () ()
    (aref!! (baz-a!! (aref!! (nested-a!! (aref!! temp (!! 1))) (!! 0))) (!! 1))
    (!! 3)
    ))

(defun-wco test-slicewise-indirect-access (array-length)
  (format t "~%Testing slicewise integer and float arrays of length ~D" array-length)
  (*let (unsigned-array float-array)
    (declare (type (pvar (array (unsigned-byte 32) (array-length))) unsigned-array))
    (declare (type (pvar (array single-float (array-length))) float-array))
    (dotimes (j array-length)
      (*setf (aref!! unsigned-array (!! j)) (!! j))
      (*setf (aref!! float-array (!! j)) (float!! (!! j)))
      )
    (*slicewise unsigned-array)
    (*slicewise float-array)
    (format t "~%Testing that arrays were turned slicewise correctly")
    (dotimes (j array-length)
      (*let ((index (!! j)))
	(declare (type (pvar (unsigned-byte 32)) index))
	(when (not (*and (=!! (sideways-aref!! unsigned-array index) (!! j))))
	  (error "Can't get out what was put into unsigned 32-bit array slicewise")
	  )
	(when (not (*and (=!! (sideways-aref!! float-array index) (float!! (!! j)))))
	  (error "Can't get out what was put into float 32-bit array slicewise")
	  )
	))
    (format t "~%Testing that array turned slicewise can be turned back processorwise")
    (*processorwise unsigned-array)
    (*processorwise float-array)
    (dotimes (j array-length)
      (when (not (*and (=!! (aref!! unsigned-array (!! j)) (!! j))))
	(error "Can't get out what was put into unsigned 32-bit array processorwise")
	)
      (when (not (*and (=!! (aref!! float-array (!! j)) (float!! (!! j)))))
	  (error "Can't get out what was put into float 32-bit array processorwise")
	  ))
    (*slicewise unsigned-array)
    (*slicewise float-array)
    (format t "~%Testing that indirect retrieval works")
    (*let ((index (mod!! (self-address!!) (!! array-length))))
      (declare (type (pvar (unsigned-byte 32)) index))
      (when (not (*and (=!! index (sideways-aref!! unsigned-array index))))
	(error "Indirect retrieval from unsigned array failed")
	)
      (when (not (*and (=!! (float!! index) (sideways-aref!! float-array index))))
	(error "Indirect retrieval from float array failed")
	))
    (format t "~%Testing that indirect storage works")
    (dotimes (j 10)
      (*let ((index (random!! (!! array-length)))
	     (data (random!! (!! array-length)))
	     )
	(declare (type (pvar (unsigned-byte 32)) index data))
	(*setf (sideways-aref!! unsigned-array index) data)
	(when (not (*and (=!! data (sideways-aref!! unsigned-array index))))
	  (ppp data :title "expected:" :end 32)
	  (ppp (sideways-aref!! unsigned-array index) :title "got:" :end 32)
	  (error "Could not store and retrieve data from indirect unsigned array.")
	  )
	(*setf (sideways-aref!! float-array index) (float!! data))
	(when (not (*and (=!! (float!! data) (sideways-aref!! float-array index))))
	  (error "Could not store and retrieve data from indirect float array")
	  )
	))
    ))


(defun-wco test-slicewise-indirect-access-general (array-element-type array-length function &key (comparision-function #'=!!))
  (format t "~%Testing slicewise array of element type ~S and length ~D" array-element-type array-length)
  (*let ()
    (*let ((data-array (make-array!! (list array-length) :element-type array-element-type)))
      (dotimes (j array-length)
	(*setf (aref!! data-array (!! j)) (funcall function (!! j)))
	)
      (*slicewise data-array)
      (format t "~%Testing that array was turned slicewise correctly")
      (dotimes (j array-length)
	(*let ((index (!! j)))
	  (declare (type (pvar (unsigned-byte 32)) index))
	  (when (not (*and (funcall comparision-function (sideways-aref!! data-array index) (funcall function (!! j)))))
	    (error "Can't get out what was put into array slicewise")
	    )))
      (format t "~%Testing that array turned slicewise can be turned back processorwise")
      (*processorwise data-array)
      (dotimes (j array-length)
	(when (not (*and (funcall comparision-function (aref!! data-array (!! j)) (funcall function (!! j)))))
	  (error "Can't get out what was put into array processorwise")
	  ))
      (*slicewise data-array)
      (format t "~%Testing that indirect retrieval works")
      (*let ((index (mod!! (self-address!!) (!! array-length))))
	(declare (type (pvar (unsigned-byte 32)) index))
	(when (not (*and (funcall comparision-function (funcall function index) (sideways-aref!! data-array index))))
	  (error "Indirect retrieval from slicewise array failed")
	  ))
      (format t "~%Testing that indirect storage works")
      (dotimes (j 10)
	(*let ((index (random!! (!! array-length))))
	  (declare (type (pvar (unsigned-byte 32)) index))
	  (*setf (sideways-aref!! data-array index) (funcall function index))
	  (when (not (*and (funcall comparision-function (funcall function index) (sideways-aref!! data-array index))))
	    (ppp (funcall function index) :title "expected:" :end 32)
	    (ppp (sideways-aref!! data-array index) :title "got:" :end 32)
	    (error "Could not store and retrieve data from slicewise array.")
	    )))
      )))


(defun-wco test-various-slicewise-indirect-arrays ()
  (test-slicewise-indirect-access-general '(unsigned-byte 32) 10 #'identity)
  (test-slicewise-indirect-access-general 'single-float 10 #'(lambda (i) (float!! i)))
  (test-slicewise-indirect-access-general '(unsigned-byte 16) 10 #'identity)
  (test-slicewise-indirect-access-general 'double-float 10 #'(lambda (i) (float!! i (!! pi))))
  (test-slicewise-indirect-access-general '(unsigned-byte 64) 10 #'identity)
  (test-slicewise-indirect-access-general 'string-char 128 #'(lambda (i) (code-char!! i)) :comparision-function 'char=!!)
  (test-slicewise-indirect-access-general '(signed-byte 128) 4 #'(lambda (i) (-!! i)))
  )

(defun-wco test-array-row-major-index!! ()
  (format t "~%~%Testing function array-row-major-index!!")
  (*let (x y z)
    (declare (type (pvar (array boolean (3))) x))
    (declare (type (pvar (array boolean (3 2))) y))
    (declare (type (pvar (array boolean (4 3 2))) z))
    (let ((count 0))
      (dotimes (j 3)
	(*let () (assert (eql!! (!! count) (array-row-major-index!! x (!! j)))) (incf count))))
    (let ((count 0))
      (dotimes (j 3)
	(dotimes (i 2)
	  (*let () (assert (eql!! (!! count) (array-row-major-index!! y (!! j) (!! i)))) (incf count)))))
    (let ((count 0))
      (dotimes (j 4)
	(dotimes (i 3)
	  (dotimes (k 2)
	    (*let () (assert (eql!! (!! count) (array-row-major-index!! z (!! j) (!! i) (!! k)))) (incf count))))))
    )
  t
  )


(defun-wco test-bit-array-operations ()
  (format t "~%~%Testing bitwise logical array pvar operations~%")
  (*let ((x (make-array!! '(2 2) :element-type '(pvar (unsigned-byte 1)) :initial-element (!! 1)))
	 (y (make-array!! '(2 2) :element-type '(pvar (unsigned-byte 1)) :initial-element (!! 0)))
	 (z (make-array!! '(2 2) :element-type '(pvar (unsigned-byte 1))))
	 )
    (declare (type (pvar (array (unsigned-byte 1) (2 2))) x y z))
    (let ((lispm-x (make-array '(2 2) :element-type 'bit :initial-element 1))
	  (lispm-y (make-array '(2 2) :element-type 'bit :initial-element 0))
	  (lispm-z (make-array '(2 2) :element-type 'bit))
	  )
      (mapc
	#'(lambda (*lisp-function lisp-function)
	    (format t "~%Testing ~S" *lisp-function)
	    (funcall *lisp-function x y z)
	    (funcall lisp-function lispm-x lispm-y lispm-z)
	    (assert (equalp (pref z 0) lispm-z))
	    )
	'(bit-and!! bit-ior!! bit-xor!! bit-eqv!! bit-nand!! bit-nor!! bit-andc1!! bit-andc2!! bit-orc1!! bit-orc2!!)
	'(bit-and bit-ior bit-xor bit-eqv bit-nand bit-nor bit-andc1 bit-andc2 bit-orc1 bit-orc2)
	))
    t
    ))


(defun-wco test-indirect-setf ()
  (format t "~%~%Testing indirect setf into nested structures")
  (nested-indirect-test)
  (nested-indirect-slot-test)
  (simple-indirect-array-slot-test)
  (general-indirect-array-and-structure-test)
  )

(defun-wco test-array-pvar-code ()
 (format t "~%~%Testing code for array pvars~%")
 (test-array-creation-and-properties)
 (test-array-element-access)
 (test-indirect-array-element-access)
 (format t "Cannot do indirect setf in general yet!")
;; (test-indirect-setf)
 (test-array-row-major-index!!)
 (test-bit-array-operations)
 (test-slicewise-indirect-access 1)
 (test-slicewise-indirect-access 10)
 (test-slicewise-indirect-access 32)
 (test-slicewise-indirect-access 100)
 (test-various-slicewise-indirect-arrays)
 )




(defun-wco test-scans-for-arrays ()

  (format t "~%~%Testing scans for arrays")

  (flet ((init2x2 (array e00 e01 e10 e11)
	   (*setf (aref!! array (!! 0) (!! 0)) (!! e00))
	   (*setf (aref!! array (!! 0) (!! 1)) (!! e01))
	   (*setf (aref!! array (!! 1) (!! 0)) (!! e10))
	   (*setf (aref!! array (!! 1) (!! 1)) (!! e11))
	   array
	   ))

  (*all

    (*let (a-foo b-foo)
	  (declare (type (pvar (array (unsigned-byte 8) (2 2))) a-foo b-foo))

	  (format t "~%Testing scan!! with copy!!")
	  (*when (zerop!! (self-address!!)) (*set a-foo (init2x2 a-foo 0 1 2 3)))
	  (*set b-foo (scan!! a-foo 'copy!! :segment-pvar (zerop!! (self-address!!))))
	  (assert (*and (equalp!! b-foo (init2x2 a-foo 0 1 2 3))))
	  (*if (evenp!! (self-address!!))
	       (init2x2 a-foo 3 4 5 6)
	       (init2x2 a-foo 0 0 0 0)
	       )
	  (*set b-foo (scan!! a-foo 'copy!! :segment-pvar (evenp!! (self-address!!))))
	  (assert (*and (equalp!! b-foo (init2x2 a-foo 3 4 5 6))))

	  (format t "~%Testing scan-grid!! with copy!!")
	  (*when (zerop!! (self-address-grid!! (!! 0))) (init2x2 a-foo 1 3 5 7))
	  (*set b-foo (scan-grid!! a-foo 'copy!! :dimension 0 :segment-pvar (zerop!! (self-address-grid!! (!! 0)))))
	  (assert (*and (equalp!! b-foo (init2x2 a-foo 1 3 5 7))))
	  (*if (evenp!! (self-address-grid!! (!! 0)))
	       (init2x2 a-foo 9 8 7 6)
	       (init2x2 a-foo 0 0 0 0)
	       )
	  (*set b-foo (scan-grid!! a-foo 'copy!! :dimension 0 :segment-pvar (evenp!! (self-address-grid!! (!! 0)))))
	  (assert (*and (equalp!! b-foo (init2x2 a-foo 9 8 7 6))))

	  ))))


(defun-wco test-arrays ()
  (test-array-pvar-code)
  (test-scans-for-arrays)
  )



