;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defun untrace1
       (fp1)
       (cond ((null fp1)
              (if (null *trace*)
                  nil
                  (prog1 *trace* (untrace1 *trace*))))
             (t
              (mapcar 'untrace2 fp1)
              (setq *trace* (set-difference *trace* fp1)))))

(defun untrace2
       (fp1)
       (cond ((member fp1 *trace*) (remove-trace (ppx fp1)))
             (t t)))

(defun remove-trace
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 4)
                   (eq 'named-lambda (car fp1))
                   (and (consp (caddr (cdr fp1)))
                        (= (length (caddr (cdr fp1)))
                           3))
                   (eq 'block
                       (caadr (cddr fp1)))
                   (equal (cadar (cdddr fp1))
                          (cadr fp1))
                   (and (consp (caddr (caddr (cdr fp1))))
                        (> (length (caddr (caddr (cdr fp1))))
                           9))
                   (eq 'prog
                       (caadr (cdadr (cddr fp1))))
                   (and
                     (consp
                       (caddr (cdddr (cdddr (cdadr (cdadr (cddr fp1)))))))
                     (=
                       (length
                         (caddr
                           (cdddr (cdddr (cdadr (cdadr (cddr fp1)))))))
                       3)))
              (eval
                (list 'defun
                      (cadr fp1)
                      (caddr fp1)
                      (caddr
                        (caddr (cdddr (cdddr (cdadr (cdadr (cddr fp1))))))))))
             ((and (consp fp1)
                   (= (length fp1) 5)
                   (eq 'named-lambda (car fp1))
                   (and (consp (caddr (cddr fp1)))
                        (= (length (caddr (cddr fp1)))
                           3))
                   (eq 'block
                       (caadr (cdddr fp1)))
                   (equal (cadar (cdddr (cdr fp1)))
                          (cadr fp1))
                   (and (consp (caddr (caddr (cddr fp1))))
                        (> (length (caddr (caddr (cddr fp1))))
                           9))
                   (eq 'prog
                       (caadr (cdadr (cdddr fp1))))
                   (and
                     (consp
                       (caddr (cdddr (cdddr (cdadr (cdadr (cdddr fp1)))))))
                     (=
                       (length
                         (caddr
                           (cdddr (cdddr (cdadr (cdadr (cdddr fp1)))))))
                       3)))
              (eval
                (list 'defun
                      (cadr fp1)
                      (caddr fp1)
                      (caddr (cdr fp1))
                      (caddr
                        (caddr
                          (cdddr (cdddr (cdadr (cdadr (cdddr fp1))))))))))
             (t nil)))

(defun trace1
       (fp1)
       (setq *trace* (union *trace*
                            (remove-if-not 'fboundp
                                           (remove-if-not 'symbolp
                                                          (mapcar 'trace2
                                                                  fp1))))))

(defun trace2
       (fp1)
       (cond ((not (symbolp fp1))
              (prog2 (warn (format nil
                                   "~A is not a symbol"
                                   fp1))
                     fp1))
             ((not (fboundp fp1))
              (prog2 (warn (format nil
                                   "~A is not a function"
                                   fp1))
                     fp1))
             ((member fp1 *trace*)
              (prog2 (untrace2 fp1)
                     (add-trace (ppx fp1))))
             (t (add-trace (ppx fp1)))))

(defun add-trace
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 4)
                   (eq 'named-lambda (car fp1))
                   (and (consp (caddr (cdr fp1)))
                        (= (length (caddr (cdr fp1)))
                           3))
                   (eq 'block
                       (caadr (cddr fp1))))
              (eval
                (list 'defun
                      (cadr fp1)
                      (caddr fp1)
                      (list 'prog
                            (list 'call 'result)
                            (list 'setq
                                  'call
                                  (list 'incf '*call*))
                            (list 'spaces 'call)
                            (list 'format
                                  t
                                  "<~A> Inputs to ~A~%"
                                  'call
                                  (list 'quote (cadr fp1)))
                            (list 'spaces 'call)
                            (list 'mapcar
                                  (list 'quote
                                        'sequel-print-with-spaces)
                                  (cons 'list (caddr fp1)))
                            (list 'format t "==> ")
                            (list 'terpri-or-read-char)
                            (list 'setq
                                  'result
                                  (caddr (caddr (cdr fp1))))
                            (list 'spaces 'call)
                            (list 'format
                                  t
                                  "<~A> Output of ~A~%"
                                  'call
                                  (list 'quote (cadr fp1)))
                            (list 'spaces 'call)
                            (list 'decf '*call*)
                            (list 'format t "==> ")
                            (list 'sequel-print 'result)
                            (list 'terpri-or-read-char)
                            (list 'return 'result)))))
             ((and (consp fp1)
                   (= (length fp1) 4)
                   (eq 'named-lambda (car fp1))
                   (and (consp (caddr (cdr fp1)))
                        (> (length (caddr (cdr fp1)))
                           1))
                   (eq 'block
                       (caadr (cddr fp1))))
              (add-trace
                (list 'named-lambda
                      (cadr fp1)
                      (caddr fp1)
                      (list 'block
                            (cadr fp1)
                            (cons 'progn
                                  (cddar (cdddr fp1)))))))
             ((and (consp fp1)
                   (= (length fp1) 5)
                   (eq 'named-lambda (car fp1))
                   (and (consp (caddr (cddr fp1)))
                        (= (length (caddr (cddr fp1)))
                           3))
                   (eq 'block
                       (caadr (cdddr fp1))))
              (eval
                (list 'defun
                      (cadr fp1)
                      (caddr fp1)
                      (caddr (cdr fp1))
                      (list 'prog
                            (list 'call 'result)
                            (list 'setq
                                  'call
                                  (list 'incf '*call*))
                            (list 'spaces 'call)
                            (list 'format
                                  t
                                  "<~A> Inputs to ~A~%"
                                  'call
                                  (list 'quote (cadr fp1)))
                            (list 'spaces 'call)
                            (list 'mapcar
                                  (list 'quote
                                        'sequel-print-with-spaces)
                                  (cons 'list (caddr fp1)))
                            (list 'format t "==> ")
                            (list 'terpri-or-read-char)
                            (list 'setq
                                  'result
                                  (caddr (caddr (cddr fp1))))
                            (list 'spaces 'call)
                            (list 'format
                                  t
                                  "<~A> Output of ~A~%"
                                  'call
                                  (list 'quote (cadr fp1)))
                            (list 'spaces 'call)
                            (list 'decf '*call*)
                            (list 'format t "==> ")
                            (list 'sequel-print 'result)
                            (list 'terpri-or-read-char)
                            (list 'return 'result)))))
             ((and (consp fp1)
                   (= (length fp1) 5)
                   (eq 'named-lambda (car fp1))
                   (and (consp (caddr (cddr fp1)))
                        (> (length (caddr (cddr fp1)))
                           1))
                   (eq 'block
                       (caadr (cdddr fp1))))
              (add-trace
                (list 'named-lambda
                      (cadr fp1)
                      (caddr fp1)
                      (caddr (cdr fp1))
                      (list 'block
                            (cadr fp1)
                            (cons 'progn
                                  (cddar (cdddr (cdr fp1))))))))
             (t (raise "code 29: problem in trace"))))

(defun terpri-or-read-char
       nil
       (if *step*
           (read-read-char (read-char))
           (terpri)))

(defun read-read-char
       (fp1)
       (cond ((equal #\a fp1) (restart))
             ((equal #\j fp1) (set '*step* nil))
             (t t)))

(defun ppx
       (fp1)
       (read-from-string (subseq (write-to-string (symbol-function fp1))
                                 23)))

(defun spaces
       (fp1)
       (cond ((equal 1 fp1) (format t " "))
             (t (format t "  ") (spaces (1- fp1)))))

(defun trace-down-from
       (fp1)
       (trace1 (dependent-functions (list fp1) nil)))

(defun dependent-functions
       (fp1 fp2)
       (cond ((null fp1) fp2)
             ((and (consp fp1)
                   (symbolp (car fp1))
                   (fboundp (car fp1))
                   (consp (ppx (car fp1)))
                   (not (member (car fp1) fp2)))
              (dependent-functions
                (append (flatten (ppx (car fp1)))
                        (cdr fp1))
                (cons (car fp1) fp2)))
             ((consp fp1) (dependent-functions (cdr fp1) fp2))
             (t
              (raise "code 13: No Patterns have Fired in dependent-functions"))))

(defun step+ nil (setq *step* t))

(defun step- nil (setq *step* nil))
