;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|
;; installation for Sequel on PC running CLisp

(in-package :sequel)
(setq *failure-object* #\V)

(defun install-SEQUEL ()
  (install1)
  (install2))

(defun install1 ()
  (format t 
"~%~%~%~%~%~%~%~%~%~%
             SEQUEL Installation Program for PCs

Welcome to the PC SEQUEL installation program.  There are three stages
to this installation program. Hit y + RETURN to my questions if you
want to go on.

In the first stage of installation, the .LIS files in your directory
will be compiled by the resident Lisp compiler which should be for
CLisp Common Lisp. You should be in a directory with all the needed 
.LIS files in it and this image should be running in that directory.  
I will check to see if you have done this.~%~%")

  (if (notevery 'probe-sequel-file 
          '("SETTINGS.LIS" "PHI.LIS" "TOPLEVEL.LIS" "CONSULT.LIS"
          "PROOFTOO.LIS"  "TYPECHEC.LIS" "FRAMEWOR.LIS"
          "REWRITE.LIS" "USERTYPE.LIS" "SEQUEL.LIS" "TRACE.LIS"
          "HORN-COM.LIS" "AUTOPROV.LIS" "DR.LIS" 
          "READTABL.LIS" "PROOF-TY.LIS" "XTT.LIS" "CLISP-CO.LIS"))

      (format t 

"~%~%Sorry, either you are not in the directory in which you placed the 
.LIS files or some are missing. I suggest you control^C, type (exit), 
and sort it out now.~%~%")

      (format t 

"Good.  They are all there.  I will commence compilation on your
instruction. There will be two warning messages which will interrupt
compilation.  Please type continue and hit RETURN to each one. ~%~%"))

(if (y-or-n-p "Shall I compile? ")
(mapcar 'compile-file
        '("SETTINGS.LIS" "PROOFTOO.LIS" "TYPECHEC.LIS"
          "USERTYPE.LIS" "SEQUEL.LIS" "TOPLEVEL.LIS" 
           "HORN-COM.LIS" "CONSULT.LIS" "PHI.LIS"
           "FRAMEWOR.LIS" "REWRITE.LIS" "SEQUEL.LIS" "TRACE.LIS"
           "AUTOPROV.LIS" "DR.LIS" "PROOF-TY.LIS" "XTT.LIS"
           "CLISP-CO.LIS"))
    (format t "~%OK, we'll skip this stage~%")))

(defun install2 ()
  (format t
"~%~%~%In the second stage of installation, the object code from the Lisp
compiler will be loaded together with the new readtable.~%~%")
  (if (y-or-n-p "Shall I do this? ")
      (mapcar 'load '("SETTINGS.fas" "SEQUEL.fas" 
           "TOPLEVEL.fas" "HORN-COM.fas" "XTT.fas" 
           "PHI.fas" "TYPECHEC.fas" "USERTYPE.fas" "PROOFTOO.fas"
           "REWRITE.fas" "FRAMEWOR.fas" "TRACE.fas" "AUTOPROV.fas"
           "CONSULT.fas" "READTABL.LIS" "PROOF-TY.fas" "DR.fas"
           "CLISP-CO.fas"))
      (format t "~%OK, we'll skip this stage~%")))

(defun probe-sequel-file (file)
  (if (probe-file file)
      t
      (warn (format nil "File ~A missing" file))))

(install-SEQUEL)
