(deftactic partial-evaluator
  {integer proof -> proof}
  max? proof? 
  -> (refl= (print-evaluation 
              (fix-run-partial-evaluator max? 
                                         proof? 
                           (run-partial-evaluator max? proof?)))))

(define fix-run-partial-evaluator
  {integer proof proof -> proof}
   _ proof? proof? -> proof?
   max? _ proof? -> (fix-run-partial-evaluator max? 
                                               proof? 
                             (run-partial-evaluator max? proof?)))


(mutual 
(define run-partial-evaluator
  {integer proof -> proof}
   max? (> (infs) max?) proof? -> proof?
   max? proof? (is-mined proof?) -> (run-partial-evaluator-on-subterms
                                      max? (simplify proof?))
   max? proof? -> (run-partial-evaluator-on-subterms
                     max?
                     (simplify (unfold proof?))))

(define run-partial-evaluator-on-subterms
  {integer proof -> proof}
  max? proof? 
  -> (run-partial-evaluator-on-subterms1 max? (head proof?) proof?))

(define run-partial-evaluator-on-subterms1
  {integer sequent proof -> proof}
  max? [_ |- [[[f? x] = z] * thm]] proof?
     -> (refl= (run-partial-evaluator max? (equality#1 proof?)))
  max? [_ |- [[[f? x y] = z] * thm]] proof?
     -> (refl= (run-partial-evaluator max? (equality#2
           (refl= (run-partial-evaluator max? (equality#1 proof?))))))
 max? [_ |- [[[f? x y z] = w] * thm]] proof?
     -> (refl= (run-partial-evaluator max? (equality#3
          (refl= (run-partial-evaluator max? (equality#2
           (refl= (run-partial-evaluator max? (equality#1 proof?)))))))))
 _ _ proof? -> proof?))

(deftactic unfold 
  {proof -> proof}
   proof? -> (unfold1 (head proof?) proof?))

(define unfold1
  {sequent proof -> proof}
   [_ |- [[[unify | _] = _] * thm]] proof? -> (rewrite unfold-unify 0 proof?)
   [_ |- [[[occurs-check | _] = _] * thm]] proof? 
   -> (rewrite unfold-occurs-check 0 proof?)
   [_ |- [[[occurs | _] = _] * thm]] proof? -> (rewrite unfold-occurs 0 proof?)
   [_ |- [[[deref | _] = _] * thm]] proof? -> (rewrite unfold-deref 0 proof?)
   [_ |- [[[deref1 | _] = _] * thm]] proof? -> (rewrite unfold-deref1 0 proof?)
   [_ |- [[[lookup-binding | _] = _] * thm]] proof? 
    -> (rewrite unfold-lookup-binding 0 proof?)
   [_ |- [[[append | _] = _] * thm]] proof?
     -> (rewrite unfold-append 0 proof?)
   _ proof? -> proof?)
   
(define print-evaluation
  {proof -> proof}
  proof? -> (print-evaluation1 (head proof?) proof?))

(define print-evaluation1
  {sequent proof -> proof}
   [_ |- [[x = _] * thm]] proof? -> (progn (pprint x) (terpri) proof?))

(define is-mined
  {proof -> bool}
  proof? -> (is-mined1 (head proof?)))

(define is-mined1
  {sequent -> bool}
  [_ |- [[x = y] * thm]] (mine x) -> t
  _ -> nil)

(define mine
  {term -> bool}
  [f? | x] -> (mine1 (inductive-terms [f? | x]))
  _ -> nil)

(define inductive-terms
  {term -> (list term)}
  [f? | x] -> (inductive-terms1 (inductive-positions f?) [f? | x]))

(define inductive-positions
  {symbol -> (list integer)}
  append -> [1]
  unify -> [1 2]
  deref -> [1]
  deref1 -> []
  occurs-check -> []
  occurs -> [2]
  lookup-binding -> [1]
  _ -> [])

(define inductive-terms1
  {(list integer) term -> (list term)}
   [] _ -> []
   [n? | ns?] [f? | x] -> [(nth-expr n? x) | (inductive-terms1 ns? [f? | x])])

(define nth-expr
  1 [x | _] -> x
  n? [_ | y] -> (nth-expr (1- n?) y))

(define mine1
  {(list term) -> bool}
   [] -> nil
   x -> (every has-place-holder x))

(define has-place-holder
  {term -> bool}
  place-holder-1 -> t
  place-holder-2 -> t
  place-holder-3 -> t
  [_ | terms?] (some has-place-holder terms?) -> t
  _ -> nil)

(deftactic edit-by
  {(list integer) (list (t-expr -> t-expr)) proof -> proof}
   [] rewrites? proof? -> (do-rewrites-0 rewrites? proof?)
   [n? | ns?] rewrites? proof?
     -> (refl= (edit-by ns? rewrites? (examine n? proof?))))

(define examine
  {integer proof -> proof}
  1 proof? -> (equality#1 proof?)
  2 proof? -> (equality#2 proof?)
  3 proof? -> (equality#3 proof?)
  _ proof? -> proof?)

(define do-rewrites-0
  {(list (t-expr -> t-expr)) proof -> proof}
   [] proof? -> proof?
   [rewrite? | rewrites?] proof?
   -> (do-rewrites-0 rewrites? (rewrite rewrite? 0 proof?)))

(define fixpoint
  f? x -> (fixpoint1 f? x (funcall f? x)))

(define fixpoint1
  _ x x -> x
  f? _ x -> (fixpoint1 f? x (funcall f? x)))

(deftactic simplify
  {proof -> proof}
  proof? -> (fixpoint simplify1 proof?))

(define simplify1
  {proof -> proof}
  proof? -> (apply-to-each-term [head-elim or-elim and-elim if-elim
                          deref-elim null-elim consp-elim tail-elim var-elim]
                 (wff-in (goal-in (head proof?)))
                 proof?))

(define goal-in
  {sequent -> t-expr}
  [_ |- t-expr?] -> t-expr?)

(define wff-in
  {t-expr -> wff}
  [wff? * thm] -> wff?)

(mutual

(define simplify1
  {proof -> proof}
  proof? -> (apply-to-each-term [head-elim or-elim and-elim if-elim
                                 null-elim consp-elim tail-elim not-elim
                                 var-elim]
                 (wff-in (goal-in (head proof?)))
                 proof?))

(define apply-to-each-term
 {(list (t-expr -> t-expr)) wff proof -> proof}
  rewrites? [[f? x] = w] proof?
     -> (do-rewrites-0 rewrites?
          (refl=
          (simplify1
           (equality#1 proof?))))

  rewrites? [[f? x y] = w] proof?
     -> (do-rewrites-0 rewrites?
         (refl=
          (simplify1
            (equality#2
              (refl=
                (simplify1
                  (equality#1 proof?)))))))

  rewrites? [[f? x y z] = w] proof?
     -> (do-rewrites-0 rewrites?
         (refl=
          (simplify1
            (equality#3
             (refl=
               (simplify1
                 (equality#2
                   (refl= (simplify1
                     (equality#1 proof?))))))))))
  _ _ proof? -> proof?))
