;;|=========================================================================|
;;|                           COPYRIGHT NOTICE                              |
;;|                                                                         |
;;|                   Copyright 1992, Mark Tarver                           |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defun mdr0
       (fp1 fp2)
       (cond ((null fp2)
              (prog (temp)
                    (setq temp *type-check*)
                    (setq *type-check* t)
                    (mdr1 fp1
                          (generalise *problem*))
                    (setq *type-check* temp)
                    (return fp1)))
             ((equal t fp2)
              (prog (temp)
                    (setq temp *type-check*)
                    (setq *type-check* t)
                    (mdr1+ fp1 (generalise *problem*))
                    (setq *type-check* temp)
                    (return fp1)))
             (t (raise "code 13: No Patterns have Fired in mdr0"))))

(defun generalise
       (fp1)
       (cond ((not (boundp '*constants*))
              (raise "code 31: constants not defined"))
             ((and (consp fp1)
                   (consp (car fp1))
                   (= (length (car fp1)) 3)
                   (eq '\|- (cadar fp1)))
              (generalise1 (append (caar fp1)
                                   (caddr (car fp1)))
                           (list (caar fp1)
                                 '\|-
                                 (caddr (car fp1)))
                           (cons '* *constants*)))
             (t (raise "code 13: No Patterns have Fired in generalise"))))

(defun generalise1
       (fp1 fp2 fp3)
       (cond ((null fp1) fp2)
             ((and (consp fp1)
                   (listp (car fp1)))
              (generalise1 (append (car fp1) (cdr fp1))
                           fp2
                           fp3))
             ((and (consp fp1)
                   (member (car fp1) fp3))
              (generalise1 (cdr fp1) fp2 fp3))
             ((consp fp1)
              (generalise1 (rremove (car fp1) (cdr fp1))
                           (subst (newv) (car fp1) fp2)
                           fp3))
             (t (raise "code 13: No Patterns have Fired in generalise1"))))

(defun mdr1
       (fp1 fp2)
       (cond ((and (consp fp2)
                   (= (length fp2) 3)
                   (eq '\|- (cadr fp2)))
              (compile-theory
                (cons (gentemp)
                      (cons ':interactive
                            (cons 'yes
                                  (cons ':name
                                        (cons fp1
                                              (cons 'thus
                                                    (mdr2 (car fp2)
                                                          (caddr fp2))))))))))
             (t (raise "code 13: No Patterns have Fired in mdr1"))))

(defun mdr2
       (fp1 fp2)
       (cond ((and (null fp1)
                   (consp fp2)
                   (= (length fp2) 3)
                   (eq '* (cadr fp2)))
              (list '<a>
                    '\|-
                    (car fp2)
                    '*
                    (caddr fp2)))
             ((and (consp fp1)
                   (consp (car fp1))
                   (= (length (car fp1)) 3)
                   (eq '* (cadar fp1)))
              (append (list (caar fp1)
                            '*
                            (caddr (car fp1))
                            '|,|)
                      (mdr2 (cdr fp1) fp2)))
             (t (raise "code 13: No Patterns have Fired in mdr2"))))

(defun mdr1+
       (fp1 fp2)
       (cond ((and (consp fp2)
                   (= (length fp2) 3)
                   (eq '\|- (cadr fp2))
                   (and (consp (caddr fp2))
                        (= (length (caddr fp2))
                           3))
                   (eq '*
                       (cadar (cddr fp2))))
              (compile-theory
                (append (list (gentemp)
                              ':interactive
                              'yes
                              ':name
                              fp1)
                        (mdr2+ (car fp2))
                        (list 'thus
                              '<a>
                              '\|-
                              (caadr (cdr fp2))
                              '*
                              (caddr (caddr fp2))))))
             (t (raise "code 13: No Patterns have Fired in mdr1+"))))

(defun mdr2+
       (fp1)
       (cond ((null fp1) nil)
             ((and (consp fp1)
                   (consp (car fp1))
                   (= (length (car fp1)) 3)
                   (eq '* (cadar fp1)))
              (cons '<a>
                    (cons '\|-
                          (cons (caar fp1)
                                (cons '*
                                      (cons (caddr (car fp1))
                                            (mdr2+ (cdr fp1))))))))
             (t (raise "code 13: No Patterns have Fired in mdr2+"))))
