;********************************************************************
;  TESTING.LISP
;  This test world is especially designed very simply for planner
;  and simulator work
;  Steps to take :
;   1) load "~/ai/truckworld/simulator-system.lisp"
;   2) (load-simulator) ; for default
;   3) load "~/ai/truckworld/worlds/testing.lisp"
;   4) (start-the-world)
;   5) (run-simulator *the-truck* *the-world*)
;***************************************************************** 

;  List of map locations
(defvar *location-list*)

;  Map roads
(defvar *road-list*)

;  The truck object, passed in to the simulator
(defvar	*the-truck*)

;  This object just packages up the locations and roads.
;  Generated by create-world and passed into make-displayer
(defvar	*the-world*)

;  This object is the interface between you and the simulated
;  world itself.  Each simulator action gives rise to a change
;  in display, which is passed as a message to the displayer object.
(defvar	*the-displayer*)

(defvar n0) (defvar n1) (defvar n2) (defvar n3) 

;;*********
;; HISTORY-LIST
;;
(defun create-history ()
  (setf *history-list*
        '(((0 0 0) (weather 1 sunny) (enemy-activity 1 0))
	  )))

;;********
;; CREATE-LOCATIONS 
;;
(defun create-locations ()
  (setf n0 (make-location 'Location-0 1 (make-window 350 50 75 50)))
  (setf n1 (make-location 'Location-1 1 (make-window 50 225 75 50)))
  (setf n2 (make-location 'Location-2 1 (make-window 50 50 75 50)))
  (setf n3 (make-location 'Location-3 1 (make-window 350 225 75 50)))
  (setf *location-list* (list n0 n1 n2 n3 )))

;;********
;; CREATE-ROADS
;;
(defun create-roads ()
  (setf l0 (make-road 'standard-road n0 'sw n1 'ne 20 'sw nil 1 nil))
  (setf l1 (make-road 'standard-road n1 'n  n2 's  20 'n  nil 1 nil))  
  (setf l2 (make-road 'standard-road n1 'w  n3 'e  15 'w  nil 1 nil))
  (setf l3 (make-road 'standard-road n2 'sw n3 'ne 20 'sw nil 1 nil))
  (setf l4 (make-road 'standard-road n0 'w  n2 'e  20 'w  nil 1 nil))
  (setf l5 (make-road 'standard-road n0 's  n3 'n  20 's  nil 1 nil))
  (setf *road-list* (list l0 l1 l2 l3 l4 l5 ))
  )

;;*******
;; CREATE-WORLD
;;
(defun create-world ()
  (create-history)
  (create-locations)
  (create-roads)
  (setf *the-world* 
		(make-world 'world 1 *history-list* *location-list* *road-list*)))

;;*******
;; CREATE-TRUCK
;;
(defun create-truck ()
  (let ((bay1 (si.make-cargo-bay 'bay1 20 nil))
	(bay2 (si.make-cargo-bay 'bay2 100 nil))
	(arm1 (si.make-robot-arm 'arm1 8 nil 0))
	(arm2 (si.make-robot-arm 'arm2 15 nil 0)))
    (setf *the-truck*
	  (si.make-standard-truck 'van-1 (list arm1 arm2) (list bay1 bay2)
	     30 45 15 nil))))

;;*******
;; POPULATE-WORLD
;;
(defun populate-world ()
  (put-in (nth 2 *location-list*) *the-truck*)   ;; put the truck in location n2

;; IN n1
  (put-in (nth 1 *location-list*) (si.make-enemy-unit))
  (put-in (nth 1 *location-list* ) (make-full-fuel-drum 5 'n1-drum-1))
  (put-in (nth 1 *location-list* ) (make-full-fuel-drum 5 'n1-drum-2))
  (put-in (nth 1 *location-list* ) (make-full-fuel-drum 5 'n1-drum-3))
  (put-in (nth 1 *location-list* ) (make-full-fuel-drum 5 'n1-drum-4))
  (put-in (nth 1 *location-list* ) (make-full-fuel-drum 5 'n1-drum-5))
  (put-in (nth 1 *location-list* ) (make-standard-item 'TOOL-1 'rock-tool 4 '()))
  (put-in (nth 1 *location-list* ) (si.make-box 'BOX-0))

;; IN n2
  (put-in (nth 2 *location-list*) (make-standard-item 'TOOL-2 'rock-tool 4 '()))

;; IN n3
  (put-in (nth 3 *location-list*) (make-full-fuel-drum 5 'n3-drum-1))
  (put-in (nth 3 *location-list*) (make-full-fuel-drum 5 'n3-drum-2))
  (put-in (nth 3 *location-list*) (make-full-fuel-drum 5 'n3-drum-3))
  (put-in (nth 3 *location-list*) (make-full-fuel-drum 5 'n3-drum-4))
  (put-in (nth 3 *location-list*) (make-full-fuel-drum 5 'n3-drum-5))
  (put-in (nth 3 *location-list*) (si.make-box 'BOX-3))
)

;;*******
;; START-THE-WORLD
;;
(defun start-the-world (&optional (displayer-string ""))
  (create-world)
  (create-truck)
  (populate-world)
  (setf *the-displayer* 
		(make-displayer *the-truck* *the-world* 0 0 displayer-string))
  (setf (displayer *the-truck*) *the-displayer*))








