(defgeneric unique-id (self))
(defgeneric kind-id (self))

(defclass test-node
  ()
  ((disp-string :accessor disp-string
                :initarg :disp-string)
   (unique-id :accessor unique-id)
   ))

(defmethod kind-id ((self test-node))
  (intern (disp-string self)))

(defmethod environment (self)
  '())

(let ((n 0))
  
  (defun make-node (disp-string)
    (let ((unum (incf n))
          (new-thing (make-instance 'test-node
                     :disp-string disp-string)))
      (setf (unique-id new-thing)
            (intern 
             (concatenate 'string disp-string "." (format nil "~d" unum))))
      new-thing))

  )

(defvar n1 (make-node "BATTLE"))
(defvar n2 (make-node "DEMAND"))
(defvar n3 (make-node "BRIDGE"))
(defvar n4 (make-node "DEMAND"))
(defvar n5 (make-node "FUEL"))
(defvar n6 (make-node "BRIDGE"))
(defvar n7 (make-node "BRIDGE"))
(defvar n8 (make-node "WAREHOUSE"))
(defvar n9 (make-node "MAINT"))
(defvar n10 (make-node "BRIDGE"))
(defvar l1 (make-node "ROAD"))
(defvar l2 (make-node "ROAD"))
(defvar l3 (make-node "ROAD"))
(defvar l4 (make-node "ROAD"))
(defvar l5 (make-node "ROAD"))
(defvar l6 (make-node "ROAD"))
(defvar l7 (make-node "ROAD"))
(defvar l8 (make-node "ROAD"))
(defvar l9 (make-node "ROAD"))
(defvar l10 (make-node "ROAD"))
(defvar l11 (make-node "ROAD"))
(defvar l12 (make-node "ROAD"))
(defvar l13 (make-node "ROAD"))

(defvar *map-obj*
        (list (list (list n1 (make-window 25 25 75 50))
                    (list n2 (make-window 225 50 75 50))
                    (list n3 (make-window 100 125 20 20))
                    (list n4 (make-window 400 25 75 50))
                    (list n5 (make-window 325 100 50 35))
                    (list n6 (make-window 390 150 20 20))
                    (list n7 (make-window 100 165 20 20))
                    (list n8 (make-window 50 225 75 50))
                    (list n9 (make-window 425 225 50 50))
                    (list n10 (make-window 390 190 20 20)))
              (list (list l1 n1 's n3 'n nil)
                    (list l2 n1 'se n2 'nw nil)
                    (list l3 n2 'sw n3 'ne nil)
                    (list l4 n5 'ne n4 'sw nil)
                    (list l5 n6 'n n4 's nil)
                    (list l6 n5 'se n6 'nw nil)
                    (list l7 n3 'e n6 'w nil)
                    (list l8 n2 'e n5 'w nil)
                    (list l9 n8 'n n7 'sw nil)
                    (list l10 n8 'ne n10 'sw nil)
                    (list l11 n9 'nw n10 'se nil)
                    (list l12 n7 'n n3 's nil)
                    (list l13 n10 'n n6 's nil))))

(defun make-test-display (&optional (x 0) (y 0) (display-str ""))
  (let ((dm (make-dm-at-corner 'truck
			    '(arm1 arm2)
			    '(bay1 bay2)
			    500
			    *map-obj*
			    :x x :y y
			    :display display-str)))
    (funcall #'dm-set dm 'current-location n1)
    dm))

(setf (symbol-function 'kill-display) #'disp.terminate)

(defun output (dm str)
  ;(dm-speak dm str)
  (write-string str *terminal-io*)
  (write-string "-->" *terminal-io*)
  (finish-output *terminal-io*)
  (clear-input *terminal-io*)
  (read-char *terminal-io*)
  t)

(defun standard-tests ()
  (let* ((dm (make-test-display))
         (box-1 (make-box-obj))
         (box-1-id (unique-id box-1))
         (box-2 (make-box-obj))
         (box-2-id (unique-id box-2))
         (box-3 (make-box-obj))
         (box-3-id (unique-id box-3))
         (box-4 (make-box-obj))
         (box-4-id (unique-id box-4))
         (crate-1 (make-crate-obj))
         (crate-1-id (unique-id crate-1))
         (crate-2 (make-crate-obj))
         (crate-2-id (unique-id crate-2))
         (crate-3 (make-crate-obj))
         (crate-3-id (unique-id crate-3)))
    (output dm "Put a box in the tire bay.")
    (dm-add dm 'tire-bay box-1)
    (output dm "Move it to the weapon bay.")
    (dm-del dm 'tire-bay box-1)
    (dm-add dm 'weapon-bay box-1)
    (output dm "Fill fuel gauge 3/4.")
    (dm-set dm 'fuel-gauge 375)
    (output dm "Set heading gauge to south,west")
    (dm-set dm 'heading-gauge 'sw)
    (output dm "Set speed gague to SLOW")
    (dm-set dm 'speed-gauge 'slow)
    (output dm "Set status to HAPPY")
    (dm-set dm 'status-gauge 'happy)
    (output dm "Put a box in bay 1.")
    (dm-add dm 'bay1 box-2)
    (output dm "Put a crate in bay 1.")
    (dm-add dm 'bay1 crate-1)
    (output dm "Put a box in bay 2.")
    (dm-add dm 'bay2 box-3)
    (output dm "Put a crate in bay 2.")
    (dm-add dm 'bay2 crate-2)
    (output dm "Put a box at current location.")
    (dm-add dm 'current-location box-4)
    (output dm "Put a crate at current location.")
    (dm-add dm 'current-location crate-3)
    (output dm "Move arm 1 to box in weapon bay.")
    (dm-move dm 'arm1 box-1-id)
    (output dm "Move arm 1 inside this box.")
    (dm-move dm 'arm1 'inside)
    (output dm "Move arm 2 to fuel gauge.")
    (dm-move dm 'arm2 'fuel-gauge)
    (output dm "Move arm 1 to next empty space in current location.")
    (dm-mnes dm 'arm1 'current-location)
    (output dm "Fold arm 1.")
    (dm-move dm 'arm1 'folded)
    (output dm "Move crate in bay 1 to arm 2 bay.")
    (dm-move dm 'arm2 crate-1-id)
    (output dm " ")
    (dm-del dm 'bay1 crate-1)
    (output dm " ")
    (dm-add dm 'arm2 crate-1)
    (output dm "Move crate in bay 2 to arm 2 bay.")
    (dm-move dm 'arm2 crate-2-id)
    (output dm " ")
    (dm-del dm 'bay2 crate-2)
    (output dm " ")
    (dm-add dm 'arm2 crate-2)
    (output dm "Move box in bay 1 to current location.")
    (dm-move dm 'arm1 box-2-id)
    (output dm " ")
    (dm-del dm 'bay1 box-2)
    (output dm " ")
    (dm-add dm 'arm1 box-2)
    (output dm " ")
    (dm-mnes dm 'arm1 'current-location)
    (output dm " ")
    (dm-del dm 'arm1 box-2)
    (output dm " ")
    (dm-add dm 'current-location box-2)
    (output dm "Empty current location.")
    (dm-empty dm 'current-location)
    (output dm "Arms folded.")
    (dm-move dm 'arm1 'folded)
    (output dm " ")
    (dm-move dm 'arm2 'folded)
    (output dm "Move to the MAINT node.")
    (dm-set dm 'current-location l2)
    (output dm " ")
    (dm-set dm 'current-location n2)
    (output dm " ")
    (dm-set dm 'current-location l8)
    (output dm " ")
    (dm-set dm 'current-location n5)
    (output dm " ")
    (dm-set dm 'current-location l6)
    (output dm " ")
    (dm-set dm 'current-location n6)
    (output dm " ")
    (dm-set dm 'current-location l13)
    (output dm " ")
    (dm-set dm 'current-location n10)
    (output dm " ")
    (dm-set dm 'current-location l11)
    (output dm " ")
    (dm-set dm 'current-location n9)))

