(comment (herald status))

(defclass status-disp  ()
  ((display-window :accessor display-window :initarg :display-window)
   (inner-window :accessor inner-window :initarg :inner-window)
   (old-sym :accessor old-sym :initform nil :initarg :old-sym)))

;************************************************************************

(defun make-status-disp (win)
  (let ((the-instance 
		 (make-instance 'status-disp
						:display-window win
						:inner-window (make-window (+ (x-coord win) 10)
												   (+ (y-coord win) 17)
												   (- (width win) 10)
												   (- (height win) 17))
						:old-sym 'stopped)))
	(dm-refresh the-instance)
	the-instance))

;************************************************************************

(defmethod dm-set ((self status-disp) x sym)
  (declare (ignore x))
  (setf (old-sym self) sym)
  (status-write-status self))

(defmethod dm-refresh ((self status-disp))
  (disp.clear-rectangle (display-window self))
  (status-write-shell self)
  (status-write-status self))

;************************************************************************

(defun status-write-shell (self)
  (disp.draw-rectangle (inner-window self))
  (disp.with-clip-window (display-window self)
	(disp.with-font (disp.medium-font)
      (disp.text-at "STATUS" (make-position 10 10)))))
  
(defun status-write-status (self)
  (disp.clear-rectangle-interior (inner-window self))
  (disp.with-font (disp.small-font)
	(disp.center-text-in-window (copy-seq (symbol-name (old-sym self)))
		                        (inner-window self))))




