;********************************************************************
;  DISPLAYER/SPEED.LISP

(defclass speed-disp ()
  ((current-level  :accessor current-level  :initarg :current-level)
   (display-window :accessor display-window :initarg :display-window)
   (inner-window   :accessor inner-window   :initarg :inner-window)
   (speed-stripes  :accessor speed-stripes  :initarg :speed-stripes)))

;*********************************************************************

(defun make-speed-disp (win)
  (let ((the-displayer (really-make-speed-displayer win)))
	(dm-refresh the-displayer)
	the-displayer))

(defun really-make-speed-displayer (win)
  (let* ((x (+ (x-coord win) 35))
         (y (+ (y-coord win) 10))
         (w (- (width win) 35))
         (h (- (height win) 20))
         (h3 (truncate (/ h 3)))
         (fast-stripe (make-window (+ x 1) (+ y 1) (- w 2) (- h 1)))
         (med-stripe (make-window (+ x 1) (+ y h3) (- w 2) (* 2 (+ h3 1))))
         (slow-stripe (make-window (+ x 1) (+ y (* 2 h3)) (- w 2) (+ h3 1)))
         (stop-stripe (make-window (+ x 1) (+ y (- h 2)) (- w 2) 1))
         (speed-stripes (list (cons 'fast fast-stripe)
                              (cons 'medium med-stripe)
                              (cons 'slow slow-stripe)
                              (cons 'stop stop-stripe)
                              (cons 'stopped stop-stripe)
                              (cons 'zero stop-stripe))))
    (make-instance 'speed-disp
				   :current-level 'stop
                   :display-window win
				   :inner-window (make-window x y w h)
                   :speed-stripes speed-stripes)))


;**********************************************************************

(defmethod dm-set ((self speed-disp) x amount)
  (declare (ignore x))
  (let ((new-stripe (cdr (assq amount (speed-stripes self)))))
    (cond 
	  ((null new-stripe)
	   nil)
	  (t (disp.clear-rectangle-interior (inner-window self))
		 (disp.fill-rectangle new-stripe)
		 (setf (current-level self) amount)
		 t))))

(defmethod dm-refresh ((self speed-disp))
  (speed-draw-shell self)
  (dm-set self 'speed-gauge (current-level self)))

;*************************************************************************

(defun speed-draw-shell (self)
  (let* ((iwin (inner-window self))
		 (w (width iwin))
		 (h3 (truncate (height iwin) 3)))
	(disp.draw-rectangle (inner-window self))
	(disp.with-clip-window (display-window self)
	  (disp.with-font (disp.small-font)
		(disp.text-at "FAST" (make-position 3 15))
		(disp.text-at " MED" (make-position 3 (+ 15 h3)))
		(disp.text-at "SLOW" (make-position 3 (+ 15 (* 2 h3))))
		(disp.text-at "STOP" (make-position 3 (+ 15 (* 3 h3))))))
	(disp.with-clip-window (inner-window self)
	  (do* ((l (list h3 (* 2 h3)) (cdr l))
			(y (car l) (car l)))
		   ((null l) nil)
		 (disp.draw-line (make-position -3 y)
			             (make-position 0 y))
		 (disp.draw-line (make-position w y)
			             (make-position (+ 3 w) y))))
	(values)))



