;***************************************************************
; MAP.LISP

(defun make-map-disp (map-obj map-disp-window)
  (let ((the-displayer (really-make-map-disp map-obj map-disp-window)))
   (dm-refresh the-displayer)
   the-displayer))

(defun really-make-map-disp (map-struct map-disp-window)
  (let* ((the-nodes (map-node-list map-struct))
		 (the-roads (map-road-list map-struct))
		 (node-displayers 		  
		  (mapcar #'(lambda (node) (map-make-node-displayer node map-disp-window))
				  the-nodes))
		 (road-displayers
		  (mapcar #'(lambda (road) 
					  (map-make-road-displayer road map-disp-window
											   the-nodes node-displayers))
				  the-roads)))
	(make-instance 'map-disp
				   :display-window map-disp-window
				   :items (append the-nodes the-roads)
				   :displayers (append node-displayers road-displayers))))

;*************************************************************************

(defun map-make-node-displayer (the-node map-disp-window)
  (let* ((node-disp-window (display-info the-node))
		 (real-display-window (add-window-offset node-disp-window
												 map-disp-window)))
	(make-instance 'node-displayer
	  :display-string (copy-seq (symbol-name (kind-id the-node)))
	  :display-window real-display-window
	  :inner-window (make-window (+ (x-coord real-display-window) 2)
								 (+ (y-coord real-display-window) 2)
								 (- (width real-display-window) 4)
								 (- (height real-display-window) 4)))))

;*******************************************************************

(defun map-display-node (node-disp-obj)
  (let ((disp-win (display-window node-disp-obj))
		(display-string (display-string node-disp-obj)))
    (disp.draw-rectangle disp-win)
    (multiple-value-bind (p1x p1y) 
  	  (disp.with-font (disp.small-font)
		(disp.text-extent display-string))
	  (multiple-value-bind (p2x p2y)
	    (disp.with-font (disp.tiny-font)
		  (disp.text-extent display-string))
		(declare (ignore p1y p2y))
		(cond 
		  ((< p1x (width disp-win))
	       (disp.write-text-within-window display-string
										  disp-win
										  (disp.small-font)))
	      ((< p2x (width disp-win))
	       (disp.write-text-within-window display-string
					      disp-win
					      (disp.tiny-font)))
		  (t nil))))))  ; just write nothing in this case

;******************************************************************

(defun map-make-road-displayer (the-road map-disp-window nodes node-displayers)
  (let ((start-node (start-node the-road))
        (start-dir  (start-node-direction the-road))
        (end-node   (finish-node the-road))
        (end-dir    (finish-node-direction the-road))
		(other-point (display-info the-road)))
    (setf other-point (add-position-offset other-point map-disp-window))
    (really-make-road-disp
	   (extract-node-displayer start-node nodes node-displayers)
	   start-dir
	   (extract-node-displayer end-node nodes node-displayers)
	   end-dir
	   other-point)))

(defun extract-node-displayer (node node-list displayer-list)
  (let ((the-pos (position node node-list :test #'eq)))
	(if (null the-pos)
		nil
	    (nth the-pos displayer-list))))
   
(defun really-make-road-disp (start-disp start-dir end-disp end-dir other-point)
  (let* ((main-path (map-make-path-lines start-disp
                                         start-dir
                                         end-disp
                                         end-dir
                                         other-point))
         (highlight-path (map-offset-lines main-path))
         (the-displayer (make-instance 'road-displayer
									   :main-path main-path 
									   :path highlight-path)))
    (disp.draw-connected-lines main-path)
    the-displayer))

;************************************************************************

(defun map-find-displayer (node-or-road state)
  (let ((item-pos (position node-or-road (items state) :test #'eq)))
	(if item-pos
		(nth item-pos (displayers state))
		nil)))

;**********************************************************************

(defun map-road-endpoints (self dir)
  (map-road-endpoints-aux (display-window self) dir))

(defun map-road-endpoints-aux (win dir)
  (let ((wp (make-position (case dir
                             ((nw w sw) (x-coord win))
                             ((n s) (horizontal-midpoint win))
                             ((ne e se) (+ (x-coord win) (width win))))
                           (case dir
                             ((nw n ne) (y-coord win))
                             ((e w) (vertical-midpoint win))
                             ((sw s se) (+ (y-coord win) (height win))))))
        (x-offset (case dir
                    ((n s) 0)
                    ((e) 5)
                    ((w) -5)
                    ((ne se) 3)
                    ((nw sw) -3)))
        (y-offset (case dir
                    ((e w) 0)
                    ((n) -5)
                    ((s) 5)
                    ((ne nw) -3)
                    ((se sw) 3))))
    (list wp
          (make-position (+ (x-coord wp) x-offset) (+ (y-coord wp) y-offset)))))

;*********************************************************************

(defun map-make-path-lines (start-node start-dir end-node end-dir other-point)
  (let ((start-points (map-road-endpoints start-node start-dir))
        (end-points (map-road-endpoints end-node end-dir)))
    (if other-point
        (list (car start-points)
              (cadr start-points)
              other-point
              (cadr end-points)
              (car end-points))
        (list (car start-points)
              (cadr start-points)
              (cadr end-points)
              (car end-points)))))

(defun map-offset-lines (point-list)
  (cond 
	((null (cdr point-list)) 
	 nil)
	(t (let* 
		 ((p1 (car point-list))
		  (p2 (cadr point-list))
		  (slope (if (= (x-coord p1) (x-coord p2))
					 100
					 (abs (/ (- (y-coord p2) (y-coord p1))
							 (- (x-coord p2) (x-coord p1)))))))
		 (cond 
		   ((< slope 1)
			(cons (make-position (x-coord p1) (- (y-coord p1) 2))
				  (cons (make-position (x-coord p2) (- (y-coord p2) 2))
						(map-offset-lines (cdr point-list)))))
		   (t (cons (make-position (+ (x-coord p1) 2) (y-coord p1))
					(cons (make-position (+ (x-coord p2) 2)
										 (y-coord p2))
						  (map-offset-lines (cdr point-list))))))))))

