;************************************************************************
;  MAP-METHODS.LISP

(defclass map-disp  ()
  ((items :accessor items :initarg :items :initform '())
   (displayers :accessor displayers :initarg :displayers :initform '())
   (currently-highlighted :accessor currently-highlighted :initform nil)
   (display-window :accessor display-window :initarg :display-window)))

(defmethod dm-refresh ((self map-disp))
  (disp.draw-rectangle (display-window self))
  (mapc #'dm-refresh (displayers self))
  (dm-highlight (currently-highlighted self)))

(defmethod dm-set ((self map-disp) x node)
  (declare (ignore x))
  (let ((the-displayer (map-find-displayer node self)))
	(cond
	  (the-displayer
	    (if (currently-highlighted self)
			(dm-unhighlight (currently-highlighted self)))
		(dm-highlight the-displayer)
		(setf (currently-highlighted self) the-displayer))
	  ((typep node 'map-link-subnode)
	    (dm-set self x (environment node)))
	  (t (cerror "To continue" "Cannot highlight this map object: ~a" node)))))

;************************************************************************

(defclass node-displayer  ()
  ((inner-window   :accessor inner-window   :initarg :inner-window)
   (display-window :accessor display-window :initarg :display-window)
   (display-string :accessor display-string :initarg  :display-string)))


(defmethod dm-highlight ((self node-displayer))
  (disp.draw-rectangle (inner-window self)))

(defmethod dm-unhighlight ((self node-displayer))
  (disp.with-erasure (disp.draw-rectangle (inner-window self))))

(defmethod dm-refresh ((self node-displayer))
  (map-display-node self))

;************************************************************************

(defclass road-displayer ()
  ((highlight-path :accessor highlight-path :initarg :path)
   (main-path      :accessor main-path      :initarg :main-path)))

(defmethod dm-refresh ((self road-displayer))
  (disp.draw-connected-lines (main-path self)))

(defmethod dm-highlight ((self road-displayer))
  (disp.draw-connected-lines (highlight-path self)))

(defmethod dm-unhighlight ((self road-displayer))
  (disp.with-erasure (disp.draw-connected-lines (highlight-path self))))

