;***************************************************************************
;  LOC-SUPPORT.LISP

(defclass loc-disp ()
  ((display-window  :accessor display-window :initarg :display-window)
   (row1-vector :accessor row1-vector :initarg :row1-vector)
   (row2-vector :accessor row2-vector :initarg :row2-vector)
   (current-location-obj :accessor current-location-obj 
						 :initarg :current-location-obj
						 :initform NIL)))

;***********************************************

(defun loc-x-coord (self)
  (x-coord (display-window self)))

(defun loc-y-coord (self)
  (y-coord (display-window self)))

(defun loc-width (self)
  (width (display-window self)))

(defun loc-height (self)
  (height (display-window self)))

;*************************************************

(defun vloc->icon-win (vecnumlist state)
  (let ((vec (car vecnumlist))
        (num (cadr vecnumlist)))
    (cond ((eq vec (row1-vector state))
           (if (>= num (loc-max-icons-in-row state))
             (cerror "To continue"
                     "Trying to get at nonexistent location icon"))
           (make-window (+ (loc-x-coord state) 15)
                        (+ (loc-y-coord state)
                           (+ 5 (* num (+ *small-icon-height* 15))))
                        (+ *small-icon-width* 1)
                        (+ *small-icon-height* 1)))
          ((eq vec (row2-vector state))
           (if (>= num (loc-max-icons-in-row state))
             (cerror "To continue"
                     "Trying to get at nonexistent location icon"))
           (make-window (+ (loc-x-coord state) (+ *small-icon-width* 30))
                        (+ (loc-y-coord state)
                           (+ 12
                              (+ (truncate *small-icon-height* 2)
                                 (* num (+ *small-icon-height* 15)))))
                        *small-icon-width*
                        *small-icon-height*))
          (t (cerror "To continue" "Trying to get at nonexistent location row")))))

(defun loc-first-empty-vector-pos (vec)
  (position 'dummy
            vec
            :test
            #'(lambda (dummy vec-elt)
                (declare (ignore dummy))
                (null vec-elt))))

(defun next-available-icon-position (state)
  (let ((pos (loc-first-empty-vector-pos (row1-vector state))))
    (cond (pos (list (row1-vector state) pos))
          (t (setf pos
                   (loc-first-empty-vector-pos (row2-vector state)))
             (if pos (list (row2-vector state) pos) nil)))))

(defun obj->vloc (obj state)
  (let ((vpos (position obj (row1-vector state))))
    (cond (vpos (list (row1-vector state) vpos))
          (t (setf vpos (position obj (row2-vector state)))
             (if vpos (list (row2-vector state) vpos) nil)))))

(defun obj->icon-win (obj state)
  (vloc->icon-win (obj->vloc obj state) state))

;********************************************************************

(defun loc-draw-border-window (self obj)
  (if (not (null obj))
  (let ((border-window (make-window (loc-x-coord self)
                                    (- (loc-y-coord self) 30)
                                    (loc-width self)
                                    30)))
	(disp.draw-rectangle (display-window self))
    (disp.with-font (disp.small-font)
     (let* ((str (copy-seq (symbol-name (kind-id obj)))))
	   (multiple-value-bind (te-x te-y) (disp.text-extent str)
         (let ((shade-w (- (truncate (- (loc-width self) te-x) 2)  4)))
		   (disp.clear-rectangle border-window)
		   (disp.draw-rectangle border-window)
		   (disp.with-clip-window 
				border-window
				(disp.draw-line (make-position 0 29)
					            (make-position (- (loc-width self) 1) 29)))
		   (disp.fill-rectangle (make-window 0 0 shade-w 30))
		   (disp.fill-rectangle (make-window (+ shade-w (+ te-x 9))
											 0
											 shade-w
											 30))
		   (disp.center-text-in-window str border-window))))))))

