/**************************************************************************/
/* input.h                                                      /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#ifndef _input_h
#define _input_h


#ifndef INPUT_EXTERN
#	define INPUT_EXTERN extern
#endif



#include "config.h"

#define START           0
#define COMMENT         1
#define READING         2
#define READY           3

#define COMMENT_CHAR    '#'
#define LINE_SIZE       512


INPUT_EXTERN char line[LINE_SIZE];
INPUT_EXTERN int lineno;


void exception(char *s);
void skip_spaces(FILE *fp);
void skip_rest(FILE *fp);
void read_line(FILE *fp, char *line);
void read_edges(FILE *fp, int nr);
void read_points(FILE *fp, int *nr);
void read_robotfile(FILE *robot);

#endif
