/**************************************************************************/
/* config.h                                                     /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _config_h
#define _config_h



/*
 * Define here what kind of reals you like: float or double.
 */
#define REAL		double



/*
 * system-dependent flags are set by Imakefile.  I checked those
 * for Dec Alpha, SunOS, Solaris, and SGI.  If you need to
 * change this file, please send me the changes.
 *
 * Define HAVE_SIGNBIT if you have the signbit() and iszero() functions.
 * Otherwise, they will be replaced by l_signbit() and l_iszero()
 * which are defined in matrix/ieee.c.
 * If your machine does not have IEEE routines or is missing the include
 * file <fp_class.h>, define HAVE_SIGNBIT=0 and HAVE_IEEE_INCLUDES=0.
 * Defining SYSV does, among other things, assume you don't have bzero().
 *
 * If you do not have the getdtablesize() function, set HAVE_GETDTABLESIZE=0.
 */
#if SYSV
#		define HAVE_SIGNBIT		0
#	if SVR4
#		define HAVE_IEEE_INCLUDES	0
#		define HAVE_GETDTABLESIZE	0
#	else
#		define HAVE_IEEE_INCLUDES	1
#		define HAVE_GETDTABLESIZE	1
#	endif
#elif DEC
#	define HAVE_SIGNBIT		0
#	define HAVE_IEEE_INCLUDES	1
#	define HAVE_GETDTABLESIZE	1
#elif linux
#	define HAVE_SIGNBIT		0
#	define HAVE_IEEE_INCLUDES	0
#	define HAVE_GETDTABLESIZE	1
#else
#	define HAVE_SIGNBIT		1
#	define HAVE_IEEE_INCLUDES	1
#	define HAVE_GETDTABLESIZE	1
#endif

/*
 * These were the previously known values:
 *
 * SUNOS: 
	HAVE_SIGNBIT		1
	HAVE_IEEE_INCLUDES	1
	HAVE_GETDTABLESIZE	1
 *
 * SOLARIS:
	HAVE_SIGNBIT		0
	HAVE_IEEE_INCLUDES	0
	HAVE_GETDTABLESIZE	0
 *
 * SGI:
	HAVE_SIGNBIT		0
	HAVE_IEEE_INCLUDES	1
	HAVE_GETDTABLESIZE	1
 *
 * LINUX:
	HAVE_SIGNBIT		0
	HAVE_IEEE_INCLUDES	0
	HAVE_GETDTABLESIZE	1
 *
 * HP700:
	HAVE_SIGNBIT		0
	HAVE_IEEE_INCLUDES	0
	HAVE_GETDTABLESIZE	0
	EWOULDBLOCK		246
 *
 * ALPHA:
	HAVE_SIGNBIT		0
	HAVE_IEEE_INCLUDES	1
	HAVE_GETDTABLESIZE	1
  */



/*
 * If your C library does not have the function
 * getdtablesize(), set HAVE_GETDTABLESIZE to 0.
 */
#if HAVE_GETDTABLESIZE
#	define GETDTABLESIZE getdtablesize()
#else
#	define GETDTABLESIZE 256
#endif




/*
 * This must happen AFTER the definition of REAL!
 */
#include "global.h"

#endif
