/**************************************************************************/
/* server.c - socket setup routines for server side             /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#include "config.h"

#include <stdio.h>
#include "socket.h"


struct sockaddr_in 	clientAddr;	/* client's address */



int setup_server_socket(int socket_address	/* the socket address */,
		    int *sock		/* the socket file descriptor */,
		    int n_clients	/* max # allowed binding clients */
		    )
{
  struct sockaddr_in	serverAddr;	/* server's address */
  extern int		errno;		/* for UNIX error referencing */

  /* Zero out the sock_addr structures.
   * This MUST be done before the socket calls.
   */

  if (socket_address <= 5000)
  {
	fprintf(stderr, "SERVER: illegal socket address\n");
	return -1;
  }

  bzero (&serverAddr, sizeof (serverAddr));
  bzero (&clientAddr, sizeof (clientAddr));

  /* Open the socket.
   * Use ARPA Internet address format and stream sockets.
   */

  *sock = socket (PF_INET, SOCK_STREAM, 0);

  if (*sock == ERROR)
	return -1;

  /* Set up our internet address, and bind it so the client can connect. */
  serverAddr.sin_family = AF_INET;
  serverAddr.sin_addr.s_addr = INADDR_ANY;
  serverAddr.sin_port   = socket_address;

  if (bind(*sock, (struct sockaddr *)&serverAddr, sizeof(serverAddr)) == ERROR)
  {
	perror("SERVER");
	close(*sock);
	return -1;
  }

  /* Listen, for the client to connect to us. */

  if (listen (*sock, n_clients) == ERROR)
  {
	fprintf(stderr, "SERVER: listen failed\n");
	close(*sock);
	return -1;
  }

  return 0;
}




int accept_client(int sock, int *communication_fd)
{
  int client_len;

  /* accept a connection */
  
  client_len = sizeof(clientAddr);

  *communication_fd = accept(sock, (struct sockaddr *)&clientAddr, &client_len);

  if (*communication_fd == ERROR)
  {
	fprintf(stderr, "SERVER: accept failed\n");
	close(sock);
	return -1;
  }

  return 0;
}
