/**************************************************************************/
/* main.h                                                       /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#ifndef _main_h
#define _main_h

#ifndef MAIN_EXTERN
#	define MAIN_EXTERN extern
#endif


#include "config.h"

#define DEFAULT_DUMP "wireframe"


MAIN_EXTERN REAL focus, angle, distance, theta, scale_fac;
MAIN_EXTERN REAL i_focus, i_angle, i_distance, i_theta, i_scale_fac;
MAIN_EXTERN int z_projection;
MAIN_EXTERN unsigned wait_time;		/* for delay */
MAIN_EXTERN REAL x_off,y_off;		/* offset center of window */
MAIN_EXTERN char *user_geometry;	/* geometry specification of window */
MAIN_EXTERN char *dumpfile;
MAIN_EXTERN REAL pic_scale, fig_scale;
MAIN_EXTERN int z_projection;
/*
 * To give better user feedback, it is wise to stop accepting
 * homogeneous matrices for a while.  When the left mouse button
 * depressed, this variable is set to 0 to temporarily reserve
 * bemmel for user input.
 */
MAIN_EXTERN int accept_homos;



void init_values(void);
void main(int argc, char *argv[]);
void check_options(int argc, char **argv, FILE **filep);


#endif
