/**************************************************************************/
/* datastruct.h --- after a version by F. J. Jungen             /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/


#ifndef _datastruct_h
#define _datastruct_h


#ifndef DATASTRUCT_EXTERN
#	define DATASTRUCT_EXTERN extern
#endif


#include "config.h"

#include "matrix.h"


struct line {
	int start,finish;
};

struct link {
	int nr_points,nr_lines;
	matrix points;
	matrix result;
	struct line *lines;
};

struct segment {			/* This is in fact the same as */
	short x1,y1,x2,y2;		/* the XSegment structure used */
					/* by the XDrawSegment request */
};


DATASTRUCT_EXTERN int nr_links, no_segments;
DATASTRUCT_EXTERN struct link *links;
DATASTRUCT_EXTERN struct segment *segs;
DATASTRUCT_EXTERN homo *homogen;



/*
 * During read-in of the robot the number of links is
 * not known.  We have to dynamically allocate memory
 * to store the points.  This structure is a temporary
 * buffer used to store these points; after read in,
 * convert() moves the values to the links structure.
 */
struct line_struct
{
	int start, finish;
	struct line_struct *next;
};

struct point_struct
{
	REAL points[4];
	struct point_struct *next;
};

struct link_struct
{
	struct point_struct *point_start, *point_end;
	int nr_points;
	struct line_struct *line_start, *line_end;
	int nr_lines;
	struct link_struct *next;
};

DATASTRUCT_EXTERN struct link_struct *link_start, *link_end;


void add_link(void);
void add_point(REAL x, REAL y, REAL z);
void add_line(int p1, int p2);
void convert(void);


#endif
