/*  TREEOBJECTS.P  */


section $-eden;


needs defaultobjects;


define vertical(context);
    lvars context;
    switchon context
    case ="forward_held" then "continue"
    case ="forward_ext" then
        if forwardvector().vec_x = 0 then
            "continue"
        else
            "fail"
        endif
    case ="back_held" then "continue"
    case ="back_ext" then
        if forwardvector().vec_x = 0 then
            "continue"
        else
            "fail"
        endif
    case ="grab_held" then "fail"
    case ="grab_ext" then "fail"
    case ="drop_held" then "continue"
    case ="drop_ext" then "fail"
    case ="left_held" then "continue"
    case ="left_ext" then "fail"
    case ="right_held" then "continue"
    case ="right_ext" then "fail"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


define horizontal(context);
    lvars context;
    switchon context
    case ="forward_held" then "continue"
    case ="forward_ext" then
        if forwardvector().vec_y = 0 then
            "continue"
        else
            "fail"
        endif
    case ="back_held" then "continue"
    case ="back_ext" then
        if forwardvector().vec_y = 0 then
            "continue"
        else
            "fail"
        endif
    case ="grab_held" then "fail"
    case ="grab_ext" then "fail"
    case ="drop_held" then "continue"
    case ="drop_ext" then "fail"
    case ="left_held" then "continue"
    case ="left_ext" then "fail"
    case ="right_held" then "continue"
    case ="right_ext" then "fail"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


define cross(context);
    lvars context;
    switchon context
    case ="forward_held" then "continue"
    case ="forward_ext" then
        if object_at_bug() = `|` and
           forwardvector().vec_x = 0 then
            "continue"
        elseif object_at_bug() = `-` and
            forwardvector().vec_y = 0 then               
            "continue"
        else
            "fail"
        endif
    case ="back_held" then "continue"
    case ="back_ext" then
        if object_at_bug() = `|` and
           forwardvector().vec_x = 0 then
            "continue"
        elseif object_at_bug() = `-` and
            forwardvector().vec_y = 0 then
            "continue"
        else
            "fail"
        endif
    case ="grab_held" then "fail"
    case ="grab_ext" then "fail"
    case ="drop_held" then "continue"
    case ="drop_ext" then "fail"
    case ="left_held" then "continue"
    case ="left_ext" then "continue"
    case ="right_held" then "continue"
    case ="right_ext" then "continue"
    case ="use_held" then "continue"
    case ="use_ext" then "continue"
    case ="wait_held" then "continue"
    case ="wait_ext" then "continue"
    endswitchon;
enddefine;


{%"vertical",vertical%}     ->  objects(`|`);
{%"horizontal",horizontal%} ->  objects(`-`);
{%"cross",cross%}           ->  objects(`X`);


endsection;
