/*  REINCARNATING_BUG.PL  */


/*
This bug illustrates the use of bugdead. When first started, it
initialises a world counter to 1. This is stored as an assertion,
'current_world(W)'. Each time 'bugdead' is called, it checks to see
whether this is greater then 50, the number of training worlds (see HELP
TRAINING_WORLDS). If not, then it returns the list
    [ rerun, W ]
where W is the name of the next training world to enter. If all the
worlds have been used, it returns
    stop    

For more details on 'bugdead', see HELP BUGDEAD.
*/


start_thinking :-
    assert( current_world(1) ).


think( left ).


bugdead( success, stop ) :-
    current_world(50),
    !.

bugdead( _, [ rerun, Name ] ) :-
    retract( current_world( W ) ),
    WNext is W + 1,
    assert( current_world( WNext ) ),
    Name is ><( tw, WNext ).
