/*  EXEC_BUG.PL  */


/*
This is a bug which heads towards the food until in the same square,
same square, then grabs it, and then uses it. In doing this, it's like
the bug in VERY_SIMPLE_BUG.PL. However, it uses processes, and so
demonstrates the use of EXEC.PL.

The ``brain'' predicate is -brain-. This, as far as it is concerned,
runs continuously in a recursive loop, and calls -exec- everytime it
decides to obey an action.

-start_thinking- makes -brain- into a process or coroutine, and stores
it as the argument of the assertion -co-. Each time -think- is called,
it restarts -co-, causing it to run until it calls -exec- to return an
action.

-bug_dead- calls -start_thinking- before returning its result. This
ensures that on reincarnation, -co- contains a new brain process which,
once again, would run from the beginning. This is necessary because
-brain- is ``used up'' after each life.
*/


:- library(exec).


start_thinking :-
    goal_to_process( brain, Co ),
    asserta( co(Co) ).


think( Action ) :-
    co( Co ),
    restart_process( Co, Action ).


brain :-
    smell( here ),
    !,
    exec( grab ),
    exec( use ),
    brain.

brain :-
    smell( S ),
    exec( S ),
    brain.


bugdead( _, rerun ) :-
   start_thinking.
