/*  PS_BUG.P  */


/*
This module defines a bug which uses the production system in LIB
PRODSYS, described in HELP PRODSYS. It does the same as
VERY_SIMPLE_BUG.P, but using production-system rules.

There are several parts to the code. The first section loads the
library, and sets two flags: chatty=false (don't give a trace), and
repeating=false (don't use the same rule twice on the same data). It
then defines the rules.

To start the production system, think() calls run(). run() is the
procedure that starts running the rules: see HELP PRODSYS. If a rule
wants to return an action, it assigns to the global variable 'action',
which 'think' picks up and returns as its result. It also calls
end_sys(). This latter is vital, since otherwise the production system
will keep running.

The second section defines the interface with Bug's perceptions. Rule
conditions can only access data that's in the 'database' variable.
(Actually, I think they _can_ get at other stuff too, but that destroys
the purity of the production-system idea.) So 'think' starts by dumping
all the perceptions into 'database', as lists.

The third section defines start_thinking, think, and bugdead.

You can watch the rules being fired if you set 'chatty' to true. You
should do this in no-Ved mode, otherwise the chatty output will
corrupt the edit window.
*/


/*
Rules
-----
*/


needs prodsys;


nil->rulebase;

false->repeating;
false->chatty;


vars action;


rule 1 [smell here];
    "grab" -> action;
    end_sys();
endrule;


rule 2 [inventory `+`];
    "use" -> action;
    end_sys();
endrule;


rule 3 [smell ?dir];
    dir -> action;
    end_sys();
endrule;


/*
Interfacing Bug's perceptions with the database
-----------------------------------------------
*/


define perceptions_to_database();
    perceptions_to_list() -> database;
enddefine;


define perceptions_to_list();
    [ ^^(retina_to_list()) ^(sentence_to_list())
      ^(smell_to_list()) ^(inventory_to_list())
      ^(energy_to_list()) 
    ]
enddefine;


define retina_to_list();
    lvars i, j, c;
    [%  for i to 5 do
            for j to 7 do
                if ( retina()(i,j) ->> c ) /= ` ` then
                    [ see ^i ^j ^c ]
                endif;
            endfor;
        endfor;
    %]
enddefine;


define sentence_to_list();
    [ sentence ^(sentence()) ]
enddefine;


define smell_to_list();
    [ smell ^(smell()) ]
enddefine;


define inventory_to_list();
    [ inventory ^(inventory()) ]
enddefine;


define energy_to_list();
    [ energy ^(energy()) ]
enddefine;


/*
Brain
-----
*/


define start_thinking();
enddefine;


define bugdead( success );
    lvars success;
    "rerun"
enddefine;


define think();
    perceptions_to_database();
    run();
    action;               
enddefine;
