;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)


(DEFUN STUFF-CS-SLOTS (CS-INSTANCE BODY MANDATORIES FORBIDDEN)
  (DOLIST (SPECIFIER BODY)
	  (FORMAT *TRACE-OUTPUT* "    ~S~%" (CAR SPECIFIER))
          (CASE (CAR SPECIFIER)
                (ESTABLISH-REJECT= 
		 (SETF (SLOT-VALUE CS-instance 'DISPLAY-ESTABLISH-REJECT)
		       (CDR SPECIFIER))
		 (SETF MANDATORIES (REMOVE 'ESTABLISH-REJECT 
					   MANDATORIES)))
                (TRANSLATOR= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'DISPLAY-TRANSLATOR)
		       (CADR SPECIFIER)))
                (establish-THRESHOLD= 
		 (SETF 
		  (SLOT-VALUE CS-instance 'DISPLAY-establish-THRESHOLD)
		  (CADR SPECIFIER)))
		;;backwards compatibility
                (local-THRESHOLD= 
		 (SETF 
		  (SLOT-VALUE CS-INSTANCE 'DISPLAY-establish-THRESHOLD)
		  (CADR SPECIFIER)))
                (suspend-THRESHOLD= 
		 (SETF 
		  (SLOT-VALUE CS-INSTANCE 'DISPLAY-suspend-THRESHOLD)
		  (CADR SPECIFIER)))
                (SUB-SPECIALISTS= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'SUBSPECIALISTS)
		       (CDR SPECIFIER)))
                (SUPER-SPECIALISTS= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'SUPERSPECIALISTS)
		       (CDR SPECIFIER)))
                (CLASSIFIER= (SETF (SLOT-VALUE CS-INSTANCE 'CLASSIFIER)
                                   (CADR SPECIFIER))
			     (SETF MANDATORIES (REMOVE 'CLASSIFIER 
						       MANDATORIES)))
		(refine-form= (if (> (length (cdr specifier)) 1)
				  (setf
				   (slot-value cs-instance
					       'display-refine-form)
				   (cons 'progn (cdr specifier)))
				  (setf (slot-value cs-instance
						    'display-refine-form)
					(cadr specifier))))
		(parent-join= (setf 
			       (slot-value cs-instance 'parent-join)
			       (cadr specifier)))
		(child-join= (setf (slot-value cs-instance 'child-join)
				   (cdr specifier)))
		(context-type= (if (not
			       (member
				(cadr specifier)
				'(establish suspend none)))
			      (error
			       "~S is not a correct value for a CONTEXT-TYPE= ~
				specifier. It should be ESTABLISH, SUSPEND, ~
				or NONE." (cadr specifier))
			      (setf (slot-value cs-instance 'context-type)
				    (cadr specifier))))
                (ESTABLISH-CONFIDENCE-VOCABULARY=
                 (SETF 
		  (SLOT-VALUE CS-INSTANCE 'ESTABLISH-CONFIDENCE-VOCABULARY)
		  (RETURN-GENERIC-INSTANCE (CADR SPECIFIER))))
                (DISPLAY-NAME= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'DISPLAY-NAME)
		       (CADR SPECIFIER)))
		(use-cache= (setf (slot-value cs-instance 'use-cache)
				  (cadr specifier)))
                (ARGUMENTS= (SETF (SLOT-VALUE CS-INSTANCE 'ARGUMENTS)
                                  (CDR SPECIFIER)))
                (ESTABLISHED-ACTION= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'DISPLAY-ESTABLISHED-ACTION)
		       (CDR SPECIFIER)))
                (NOT-ESTABLISHED-ACTION= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'DISPLAY-NOT-ESTABLISHED-ACTION)
		       (CDR SPECIFIER)))
                (AUTHOR= (SETF (SLOT-VALUE CS-INSTANCE 'AUTHOR)
                               (CADR SPECIFIER))
                       (SETF MANDATORIES (REMOVE 'AUTHOR MANDATORIES)))
                (CREATION-DATE= (SETF (SLOT-VALUE CS-INSTANCE
                                             'CREATION-DATE)
                                      (CADR SPECIFIER))
                       (SETF MANDATORIES (REMOVE 'CREATION-DATE 
                                                MANDATORIES)))
                (LAST-MODIFICATION-DATE= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'LAST-MODIFICATION-DATE)
		       (CADR SPECIFIER))
		 (SETF MANDATORIES 
		       (REMOVE 'last-MODIFICATION-DATE MANDATORIES)))
		(control-additions= (setf
				     (slot-value cs-instance
						 'control-additions)
				     (cdr specifier)))
		(tracing-control-additions=
		 (setf (slot-value cs-instance 'tracing-control-additions)
		       (cdr specifier)))
                (SPECIFIC-FUNCTION= (SETF (SLOT-VALUE CS-INSTANCE
						      'SPECIFIC-FUNCTION)
                                          (CADR SPECIFIER)))
                (ASSOCIATED-CONCEPTS= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'ASSOCIATED-CONCEPTS)
		       (CDR SPECIFIER))
		 (ADD-DRAGON-TO-CONCEPTS (SLOT-VALUE CS-INSTANCE
						     'UNIQUE-NAME)
					 (CDR SPECIFIER)))
                (COMPONENT-OF= (SETF (SLOT-VALUE CS-INSTANCE
                                            'COMPONENT-OF)
                                     (CDR SPECIFIER)))
                (COMPONENTS= 
		 (IF 
		  (MEMBER 'COMPONENTS FORBIDDEN)
		  (ERROR "COMPONENTS is not a permitted specification for ~S."
			 (SLOT-VALUE CS-INSTANCE
				     'UNIQUE-NAME)))
		 (SETF (SLOT-VALUE CS-INSTANCE 'COMPONENTS)
		       (CDR SPECIFIER)))
                (TOOL-USER-SLOTS= 
		 (SETF (SLOT-VALUE CS-INSTANCE 'TOOL-USER-SLOTS)
		       (CDR SPECIFIER)))
                (RATIONALE= (SETF (SLOT-VALUE CS-INSTANCE 'RATIONALE)
                                  (CADR SPECIFIER)))
                (EXPERT= (SETF (SLOT-VALUE CS-INSTANCE 'EXPERT)
                               (CADR SPECIFIER)))
                (CITATIONS= (SETF (SLOT-VALUE CS-INSTANCE 'CITATIONS)
                                  (CADR SPECIFIER)))
                (DISCLAIMER= (SETF (SLOT-VALUE CS-INSTANCE 'DISCLAIMER)
                                   (CADR SPECIFIER)))
                (OTHER-KNOWLEDGE-SOURCES= 
		 (SETF 
		  (SLOT-VALUE cs-instance 'other-knowledge-sources)
		  (CADR SPECIFIER)))
                (MEMORY-RETENTION-LIMIT= 
		 (SETF 
		  (SLOT-VALUE CS-INSTANCE 'MEMORY-RETENTION-LIMIT)
		  (CADR SPECIFIER)))
                (MEMORY-RETENTION-WARNING-LIMIT=
                 (SETF (SLOT-VALUE CS-INSTANCE '
                              MEMORY-RETENTION-WARNING-LIMIT)
                       (CADR SPECIFIER)))
                (OTHERWISE 
		 (ERROR "In ~S, this is not a recognized specification for a classification specialist: ~S"
			(SLOT-VALUE CS-INSTANCE 'UNIQUE-NAME)
			SPECIFIER))))
  (IF MANDATORIES (ERROR "ERROR in compiling ~S. Required specifications for ~S have not been made."
			 (SLOT-VALUE CS-INSTANCE 'UNIQUE-NAME)
			 MANDATORIES))
  (FORMAT *TRACE-OUTPUT* 
          "Specification stuffed into appropriate slots. ~%"))


(defmethod CONTROLLERS ((CS-INSTANCE classification-specialist))
   (RETURN-FROM
    CONTROLLERS
     (ACONS
     'ESTABLISH-REFINE
     `(LAMBDA
       ,(append
	 (cadr (assoc 'establish-refine
		      (slot-value cs-instance 'arguments)))
	 '(&optional result-type))
       (DECLARE (SPECIAL *CSRL-establish-THRESHOLD* *csrl-suspend-threshold*
			 *current-dragon* *current-case*)
		(ignore result-type))

       (BLOCK
        ESTABLISH-REFINE

	;; first, if we've already done this case, just return what
	;; we got already
	(if (and
	     (slot-value *current-dragon* 'use-cache)
	     (equal (get-case *current-dragon*) *current-case*)
	     (not (eq (get-status *current-dragon*) 'not-run)))
	    (progn

	      ;; make sure we refine - in case we were stipulated,
	      ;; and make sure we do establish-action or not-establish
	      ;; action
	      (if (eq (get-status *current-dragon*) 'established)
		  (progn
		    ,(slot-value cs-instance 'established-action)
		    (if (null (get-refine-result *current-dragon*))
			(setf (slot-value *current-dragon* 'refine-result)
			      (IF 
			       ,(if 
				    (SLOT-VALUE CS-INSTANCE 'SUBSPECIALISTS)
				    t nil)
			       ,(slot-value cs-instance 'refine-form)
			       (list 
				',(slot-value cs-instance 'unique-name)))))

		    ;; check to see if subs are exhaustive, if so, 
		    ;; and all subs ruled out reset status as
		    ;; necessary (if refine-result is nil at this point,
		    ;; all subs either suspended or ruled out)
		    ;; we only do this check if parent established

		    ,(if (member 'exhaustive 
				 (slot-value cs-instance 'child-join))
			 `(if (null (get-refine-result *current-dragon*))
			      (if
				  (do* ((sub-list 
					 ',(slot-value 
					    cs-instance 'subspecialists))
					(sub (pop sub-list) (pop sub-list)))
				       ((null sub) nil)
				       (if (not (equal 
						 (get-status sub) 'ruled-out))
					   (return t)))
				  ;; somebody didn't rule out
				  t
				  ;; everybody ruled out
				  (progn
				    (setf (slot-value *current-dragon* 'status)
					  'ruled-out)
				    (remember 
				     'exhaustive-subs-all-ruled-out))))))

		  ,(slot-value cs-instance 'not-established-action))

			      
	      (remember 'establish-result= (get-last-result *current-dragon*)
		   'establish-threshold= (get-establish-threshold
					  *current-dragon*)
		   'suspend-threshold= (get-suspend-threshold
					*current-dragon*)
		   'status= (get-status *current-dragon*)
		   'case= *current-case*
		   'refine-result= (slot-value *current-dragon*
					       'refine-result))
	      (return-from establish-refine
			   (slot-value *current-dragon* 'refine-result))))


	(progn
	  (new-case *current-dragon*)
	  (LET
	   ((ESTABLISH-VAL ,(SLOT-VALUE CS-INSTANCE 'ESTABLISH-REJECT))
	    (estab-THRESH 
	     (IF (NOT (slot-empty-p *current-dragon* 'establish-threshold))
		 
		 (SLOT-VALUE *CURRENT-DRAGON* 'establish-THRESHOLD)
		 *CSRL-establish-THRESHOLD*))
	    (suspend-THRESH (IF (NOT 
				 (slot-empty-p *current-dragon*
					       'suspend-threshold))
				(SLOT-VALUE *CURRENT-DRAGON* 
					    'suspend-THRESHOLD)
				*CSRL-suspend-THRESHOLD*))
	    result-status)


	   ,(IF (NOT (slot-empty-p cs-instance 'translator))
		`(SETF ESTABLISH-VAL
		       (APPLY ',(SLOT-VALUE CS-INSTANCE 'TRANSLATOR)
			      (LIST ESTABLISH-VAL))))


	   (setf result-status
		 (if ,(check-alias-compare-form
		       'ge
		       'establish-val 'estab-thresh
		       (slot-value cs-instance 
				   'establish-confidence-vocabulary))
		     'established
		     (if ,(check-alias-compare-form
			   'ge
			   'establish-val 'suspend-thresh
			   (slot-value cs-instance 
				       'establish-confidence-vocabulary))
			 'suspended
		         'ruled-out)))

	 ;; try for context only if we're interested -- i.e. only if
	 ;; agent could establish -- takes too long
	 ;; to do it every time 

         ;; what we do here depends on context-type= specifier -- if
	 ;; the user specified the context type as ESTABLISH, we tell
	 ;; get-context to give us context only if the right combination
	 ;; of supers has established (based on and-join or or-join),
	 ;; if the context type is SUSPEND, we tell get-context to give us
	 ;; context if the parents are established or suspended, and
	 ;; if the context-type is NONE, we don't look for context.
	 ;; If get-context returns RULED-OUT, it means that some combination
	 ;; of our ancestors (at least one of our parents, for an and-join,
	 ;; or all of our parents, for an or-join) have ruled-out,
	 ;; so we must rule out also.
	 ;; Context-type is determined at build-time, so the following
	 ;; code is set up then.

	 ,(case (slot-value cs-instance 'context-type)
		(establish
		 `(if (not (eq result-status 'ruled-out))
		      (let
			  ((context 
			    (get-context *current-dragon* :case *current-case*
					 :context-type 'establish)))
			(case context
			      ;; got context - leave result-status alone
			      (got-context
			       (remember 'context=got-context))
			      (no-context
			       (remember 'context=no-context)
			       ;; didn't get context -- an ancestor suspended
			       ;; so can't establish
			       (if (eq result-status 'established)
				   (progn
				     (setf result-status 'suspended)
				     (remember 
				      'status-suspended--no-context))))
			      (ruled-out
			       ;; somebody above us ruled out, so we rule out
			       (remember 'context=ruled-out)
			       (setf result-status 'ruled-out))))
		      (remember 'didnt-try-for-context--ruled-out)))
		(suspend
		 `(if (not (eq result-status 'ruled-out))
		      (let
			  ((context 
			    (get-context *current-dragon* :case *current-case*
					 :context-type 'suspend)))
			(case context
			      ;; got context - leave result-status alone
			      (got-context
			       (remember 'context=got-context))
			      (no-context
			       (error "This should not happen. Agent ~S with ~
 				context-type of suspend got a result of ~
				no-context from get-context."
				      ',(slot-value cs-instance 'unique-name)))
			      (ruled-out
			       ;; somebody above us ruled out, so we rule out
			       (remember 'context=ruled-out)
			       (setf result-status 'ruled-out))))
		      (remember 'didnt-try-for-context--ruled-out)))
		(none
		 ;; we don't care about context. Leave status the same
		 ;; as before.
		 `(remember 'context=dontcare)))


			     
	 (remember 'establish-val= establish-val
		   'establish-threshold= estab-thresh
		   'suspend-threshold= suspend-thresh
		   'status= result-status
		   'case= *current-case*)

	 (setf (slot-value *current-dragon* 'status) result-status
	       (slot-value *current-dragon* 'case)
	       *current-case*
	       (slot-value *current-dragon* 'last-result)
	       establish-val
	       (slot-value *current-dragon* 'last-establish-threshold)
	       estab-thresh
	       (slot-value *current-dragon* 'last-suspend-threshold)
	       suspend-thresh)
	 

	 (if (eq result-status 'established)
	     (progn
	       ;; if classifier for this CS requires propagation,
	       ;; then propagate status
	       (if (propagate? (slot-value *current-dragon* 'classifier))
		   (progn
		     (invoke (eval 
			      (slot-value *current-dragon* 'classifier))
			     'stipulate 
			     (slot-value *current-dragon* 'unique-name))
		     (remember 'propagating)))

	       ,(SLOT-VALUE CS-INSTANCE 'ESTABLISHED-ACTION)

	       (remember 'refining)

       
		;; return (cs-instance) if no subs established
		;; (but it has subs), (cs-instance sub1 sub2..)
		;; (sub1 is what sub1 returned if it established)
		;; and cs-instance if this is a leaf node

		(setf (slot-value *current-dragon* 'refine-result)
			  ,(slot-value cs-instance 'refine-form))

		;; check to see if subs are exhaustive, if so, and
		;; all subs ruled out reset status as necessary (if
		;; refine-result is nil at this point,
		;; all subs either suspended or ruled out)

		,(if (member 'exhaustive (slot-value cs-instance 'child-join))
		     `(if (null (get-refine-result *current-dragon*))
			  (if
			      (do* ((sub-list 
				     ',(slot-value cs-instance
						   'subspecialists))
				    (sub (pop sub-list) (pop sub-list)))
				   ((null sub) nil)
				   (if (not (equal 
					     (get-status sub) 'ruled-out))
				       (return t)))
			      ;; somebody didn't rule out
			      t
			      ;; everybody ruled out
			      (progn
				(setf (slot-value *current-dragon* 'status)
				      'ruled-out)
				(remember 'exhaustive-subs-all-ruled-out)))))


	       (RETURN-FROM ESTABLISH-REFINE 
			    (slot-value *current-dragon* 'refine-result)))
	   
	   (pROGN
                 ,(SLOT-VALUE CS-INSTANCE 'NOT-ESTABLISHED-ACTION)
                 (RETURN-FROM ESTABLISH-REFINE NIL)))))))

     (ACONS
      'ESTABLISH
      `(LAMBDA
	,(append
	  (cadr (assoc 'establish
		       (slot-value cs-instance 'arguments)))
	  '(&optional result-type))
        (DECLARE (SPECIAL *CSRL-establish-THRESHOLD* *current-dragon*
			  *current-case* *csrl-suspend-threshold*)
		 (ignore result-type))


	;; first, if we've already done this case, just return what
	;; we got already
	(if (and
	     (slot-value *current-dragon* 'use-cache)
	     (equal (get-case *current-dragon*) *current-case*)
	     (not (eq (get-status *current-dragon*) 'not-run)))
	    (progn
	      (remember 'establish-result= (get-last-result *current-dragon*)
		   'establish-threshold= (get-establish-threshold
					  *current-dragon*)
		   'suspend-threshold= (get-suspend-threshold
					*current-dragon*)
		   'status= (get-status *current-dragon*)
		   'case= *current-case*)
	      (if (eq (get-status *current-dragon*) 'established)
		  (progn
		    ,(SLOT-VALUE CS-INSTANCE 'ESTABLISHED-ACTION)
		    T)
		  (PROGN
		   ,(SLOT-VALUE CS-INSTANCE 
				      'NOT-ESTABLISHED-ACTION)
		   NIL)))


	    (progn
	      (new-case *current-dragon*)
	      (LET
	       ((ESTABLISH-VAL ,(SLOT-VALUE CS-INSTANCE 'ESTABLISH-REJECT))
		result-status
		(estab-THRESH 
		 (IF 
		  (NOT 
		   (slot-empty-p *current-dragon* 'establish-threshold))

		  (SLOT-VALUE *CURRENT-DRAGON* 'establish-THRESHOLD)
		  '*CSRL-establish-THRESHOLD*))
		(suspend-THRESH 
		 (IF 
		  (NOT 
		   (slot-empty-p *current-dragon* 'suspend-threshold))
		  (SLOT-VALUE *CURRENT-DRAGON* 'suspend-THRESHOLD)
		  '*CSRL-suspend-THRESHOLD*)))

	       ,(IF (NOT (slot-empty-p cs-instance 'translator))
		    `(SETF ESTABLISH-VAL
			   (APPLY ',(SLOT-VALUE CS-INSTANCE 'TRANSLATOR)
				  (LIST ESTABLISH-VAL))))


	     (setf result-status
		   (if ,(check-alias-compare-form
			 'ge
			 'establish-val 'estab-thresh
			 (slot-value cs-instance 
				     'establish-confidence-vocabulary))
		       'established
		       (if ,(check-alias-compare-form
			     'ge
			     'establish-val 'suspend-thresh
			     (slot-value cs-instance 
					 'establish-confidence-vocabulary))
			   'suspended
			   'ruled-out)))


	     ;; try for context only if we're interested -- i.e. only if
	     ;; agent could establish -- takes too long
	     ;; to do it every time. Check it when agent has suspended status
	     ;; to see if lack of context would force it to rule out.

	     ;; what we do here depends on context-type= specifier -- if
	     ;; the user specified the context type as ESTABLISH, we tell
	     ;; get-context to give us context only if the right combination
	     ;; of supers has established (based on and-join or or-join),
	     ;; if the context type is SUSPEND, we tell get-context to give us
	     ;; context if the parents are established or suspended, and
	     ;; if the context-type is NONE, we don't look for context.
	     ;; If get-context returns RULED-OUT, it means that some
	     ;; combination of our ancestors (at least one of our parents,
	     ;; for an and-join, or all of our parents, for an or-join) 
	     ;; have ruled-out, so we must rule out also.
	     ;; Context-type is determined at build-time, so the following
	     ;; code is set up then.

	     ,(case (slot-value cs-instance 'context-type)
		    (establish
		     `(if (not (eq result-status 'ruled-out))
			  (let
			      ((context 
				(get-context *current-dragon*
					     :case *current-case*
					     :context-type 'establish)))

			    (case context
				  ;; got context - leave result-status alone
				  (got-context
				   (remember 'context=got-context))
				  (no-context
				   (remember 'context=no-context)
				   ;; didn't get context -- 
				   ;; an ancestor suspended so can't establish
				   (if (eq result-status 'established)
				       (progn
					 (setf result-status 'suspended)
					 (remember 
					  'status-suspended--no-context))))
				  (ruled-out
				   ;; somebody above us ruled out, so rule out
				   (remember 'context=ruled-out)
				   (setf result-status 'ruled-out))))
			(remember 'didnt-try-for-context--ruled-out)))
		    (suspend
		     `(if (not (eq result-status 'ruled-out))
			  (let
			      ((context 
				(get-context *current-dragon*
					     :case *current-case*
					     :context-type 'suspend)))
			    
			    (case context
				  ;; got context - leave result-status alone
				  (got-context
				   (remember 'context=got-context))
				  (no-context
				   (error 
				    "This should not happen. Agent ~S with ~
 				    context-type of suspend got a result of ~
				    no-context from get-context."
				    ',(slot-value cs-instance 'unique-name)))
				  (ruled-out
				   ;; somebody above us ruled out, so rule out
				   (remember 'context=ruled-out)
				   (setf result-status 'ruled-out))))
			(remember 'didnt-try-for-context--ruled-out)))
		    (none
		     ;; we don't care about context. Leave status the same
		     ;; as before.
		     `(remember 'context=dontcare)))

	     

	     (remember 'establish-val= establish-val
		       'establish-threshold= estab-thresh
		       'suspend-threshold= suspend-thresh
		       'status= result-status
		       'case= *current-case*)


	     (setf (slot-value *current-dragon* 'status) result-status
		   (slot-value *current-dragon* 'case)
		   *current-case*
		   (slot-value *current-dragon* 'last-result)
		   establish-val
		   (slot-value *current-dragon* 'last-establish-threshold)
		   estab-thresh
		   (slot-value *current-dragon* 'last-suspend-threshold)
		   suspend-thresh)
	     
	     (if (eq result-status 'established)
		 (progn
		   ;; if classifier for this CS requires propagation,
		   ;; then propagate status
		   (if (propagate? (slot-value *current-dragon* 'classifier))
		       (progn
			 (invoke (eval 
				  (slot-value *current-dragon* 'classifier))
				 'stipulate 
				 (slot-value *current-dragon* 'unique-name))
			 (remember 'propagating)))

		   ,(SLOT-VALUE CS-INSTANCE 'ESTABLISHED-ACTION)
		   T)
	         (PROGN
		  ,(SLOT-VALUE CS-INSTANCE 
				     'NOT-ESTABLISHED-ACTION)
		  NIL))))))

      (ACONS 'REFINE
       `(LAMBDA
	 ,(append
	   (cadr (assoc 'refine
			(slot-value cs-instance 'arguments)))
	   '(&optional result-type))
	 (declare (ignore result-type) (special *current-dragon* 
						*current-case*))

	  (if (and
	       (slot-value *current-dragon* 'use-cache)
	       (equal (get-case *current-dragon*) *current-case*)
	       (not (eq (get-status *current-dragon*) 'not-run)))
	      (progn
		(remember 'case= *current-case*
			  'refine-result= (slot-value
					   *current-dragon* 'refine-result))
		(slot-value *current-dragon* 'refine-result))

	      (progn
		(new-case *current-dragon*)
		(setf (slot-value *current-dragon* 'case) *current-case*
		      (slot-value *current-dragon* 'refine-result)
		      ,(slot-value cs-instance 'refine-form))

		;; update status of dragon if it is established
		;; check to see if subs are exhaustive, if so, and all
		;; subs ruled out reset status as necessary (if
		;; refine-result is nil at this point,
		;; all subs either suspended or ruled out)

		,(if (member 'exhaustive (slot-value cs-instance 'child-join))
		   `(if (and (eq (get-status *current-dragon*) 'established)
			     (null (get-refine-result *current-dragon*)))
			(if
			    (do* ((sub-list 
				   ',(slot-value cs-instance 'subspecialists))
				  (sub (pop sub-list) (pop sub-list)))
				 ((null sub) nil)
				 (if (not (equal (get-status sub) 'ruled-out))
				     (return t)))
			    ;; somebody didn't rule out
			    t
			    ;; everybody ruled out
			    (progn
			      (setf (slot-value *current-dragon* 'status)
				    'ruled-out)
			      (remember 'exhaustive-subs-all-ruled-out)))))

		(remember 'case= *current-case*
			  'refine-result= (slot-value
					   *current-dragon* 'refine-result))
		(slot-value *current-dragon* 'refine-result))))

       NIL)))))


(DEFUN PARSE-ESTABLISH-REJECT (ESTAB-LIST)
   (LET
    ((ESTAB-FORM (CAR ESTAB-LIST)))
    (COND
       ((AND (= (LENGTH ESTAB-LIST)
                1)
             (SYMBOLP ESTAB-FORM))
        (RETURN-FROM parse-ESTABLISH-REJECT `,ESTAB-FORM))
       ((NUMBERP ESTAB-FORM)
        (RETURN-FROM PARSE-ESTABLISH-REJECT ESTAB-FORM))
       ((LISTP ESTAB-FORM)
	(if
	    (member (car estab-form) 
		    '(judge ask ask-user invoke establish-refine
			    establish refine))
	    (return-from parse-establish-reject
			 (translate-invoke-form estab-form))
            (RETURN-FROM PARSE-ESTABLISH-REJECT
			 `,(CAR ESTAB-LIST))))
       (t (error "Establish-reject form ~S is not a dragon call, variable name, number value, or Lisp function call." estab-form)))))


(DEFUN PARSE-THRESHOLD (THRESH) (RETURN-FROM PARSE-THRESHOLD
                                       (COND
                                          ((NUMBERP THRESH)
                                           THRESH)
                                          ((SYMBOLP THRESH)
                                           THRESH))))

(defun parse-refine-form (form cs-instance classifier)
  (cond ((symbolp form)
	  (if (eq form 'or)
	      ;;use standard refine form
	      (return-from parse-refine-form 
			   `(let ((sub-refine nil)
				  (result-list nil))
			      (dolist (sub ',(slot-value
					      (eval cs-instance)
					      'subspecialists))

				      (setf sub-refine
					    (invoke (eval sub)
						    'establish-refine))
				      (if sub-refine
					  (setf result-list
						(cons sub-refine 
						      result-list))))
			      (if ',(slot-value (eval cs-instance)
						'subspecialists)
				  (append (list 
					   ',(slot-value (eval cs-instance)
							 'unique-name))
					result-list)
				  ',(slot-value (eval cs-instance)
						'unique-name))))
	        (if (eq form 'return-first)
		    (return-from parse-refine-form
				 `(let ((result-list nil))
				    (dolist (sub ',(slot-value 
						    (eval cs-instance)
						    'subspecialists)
						 (if
						     ',(slot-value
							(eval cs-instance)
							'subspecialists)
						     (list 
						      ',(slot-value
							 (eval cs-instance)
							 'unique-name))
						     ',(slot-value
							(eval cs-instance)
							'unique-name)))
					    (setf result-list
						 (invoke (eval sub)
							  'establish-refine))
					    (if result-list
						(return 
						 (append
						  (list
						   ',(slot-value
						      (eval cs-instance)
						      'unique-name))
						  (cons 
						   result-list
						   nil)))))))

		    (error "~S is not a recognized specification for a ~
				 refine-form." form))))
	((listp form)
	 (return-from parse-refine-form 
		      (transform-sub-forms
		       (transform-get-subs
			form cs-instance classifier) cs-instance classifier)))
	(t (error "~S, specified as a refine form is neither a recognized ~
				symbol or a list." form))))

(defun transform-sub-forms (tree instance-name classifier)
  (cond ((symbolp tree) tree)
	((listp tree)
	 (case (car tree)
	       (sub `(nth (get-subs ',instance-name ,classifier) 
			  ,(second tree)))
	       (otherwise (cons (transform-sub-forms (car tree)
						     instance-name 
						     classifier)
				(transform-sub-forms (cdr tree)
						     instance-name 
						     classifier)))))
	(t tree)))

(defun transform-get-subs (tree instance-name classifier)
  (cond ((symbolp tree) tree)
	((listp tree)
	 (case (car tree)
	       (get-subs
		(if (> (length tree) 1) 
		    tree
		    `(get-subs ',instance-name ,classifier)))
	       (otherwise (cons (transform-get-subs (car tree)
						    instance-name
						    classifier)
				(transform-get-subs (cdr tree)
						     instance-name
						     classifier)))))
	 (t tree)))
				 

(DEFUN PARSE-TRANSLATOR (TRANS CONF-SET) (COND
                                            ((LISTP TRANS)
					         (RETURN-FROM 
						  PARSE-TRANSLATOR 
						  TRANS))
                                            ((EQUAL TRANS 'INVERT)
                                             (RETURN-FROM 
                                                    PARSE-TRANSLATOR
                                                    (INVERT-FORM
                                                     CONF-SET)))
                                            (T (ERROR "ERROR in the TRANSLATOR specification: ~A is not 
	     an INVERT form or a list." TRANS))))



(DEFUN ADD-TO-CLASSIFIER (DRAGON-NAME CLASSIFIER SUPERS SUBS 
				      &optional (redefine nil))
   (IF (NOT (TYPEP CLASSIFIER 'CLASSIFIER))
       (ERROR "~S does not name a classifier.~%" CLASSIFIER))
   (LET ((UNRESOLVED (CDR (ASSOC DRAGON-NAME (SLOT-VALUE CLASSIFIER
                                                    'UNRESOLVED))))
         RETURN)
        (IF (NOT (NULL UNRESOLVED))
            (DOLIST (RELATION UNRESOLVED)
                   (IF (EQ DRAGON-NAME (CAR RELATION))
                       (IF (NOT (MEMBER (CDR RELATION)
                                       SUBS))
                           (ERROR 
  "~S claims to be a child of ~S, but ~S does not define it as such.~%"
                                  (CDR RELATION)
                                  DRAGON-NAME DRAGON-NAME))
                       (IF (NOT (MEMBER (CAR RELATION)
                                       SUPERS))
                           (ERROR 
 "~S claims to be a parent of ~S, but ~S does not define it as such.~%"
                                  (CAR RELATION)
                                  DRAGON-NAME DRAGON-NAME)))))
        (SETF RETURN (MULTIPLE-VALUE-LIST (ADD-NODE DRAGON-NAME SUPERS 
                                                 SUBS
                                                 (SLOT-VALUE
                                                  CLASSIFIER
                                                  'HIERARCHY)
						 :redefine redefine)))
       
       ;; don't change anything till we know it doesn't fall
       ;; out at one of the ERROR's

        (SETF (SLOT-VALUE CLASSIFIER 'UNRESOLVED)
              (REMOVE (ASSOC DRAGON-NAME (SLOT-VALUE CLASSIFIER
                                                'UNRESOLVED))
                     (SLOT-VALUE CLASSIFIER 'UNRESOLVED)))
        (SETF (SLOT-VALUE CLASSIFIER 'HIERARCHY)
              (CAR RETURN))
        (SETF (SLOT-VALUE CLASSIFIER 'UNRESOLVED)
              (ADD-UNRESOLVED-RELATIONS (CADR RETURN)
                     (SLOT-VALUE CLASSIFIER 'UNRESOLVED)))))



(DEFMETHOD COMPILE-dragon-type (CS-NAME (CS-INSTANCE
                                                       
                                              CLASSIFICATION-SPECIALIST
                                                       )
                                                    GT-CODE-BODY)
  (declare (special *cs-use-cache*))
   (LET
    ((MANDATORIES '(ESTABLISH-REJECT AUTHOR CLASSIFIER))
     (FORBIDDEN NIL)
     ;; if someone tries to redefine a CS, simply print a warning and do it
     (redefine t))
    (FORMAT *TRACE-OUTPUT* 
           "Storing the specifcations into appropriate slots.~%")
       
       ;; stuff the rest of the slots, making sure all of the  
       
       ;; MANDATORIES and none of the FORBIDDEN list are
       
       ;; present

    (STUFF-CS-SLOTS CS-INSTANCE GT-CODE-BODY MANDATORIES FORBIDDEN)
    (FORMAT *TRACE-OUTPUT* "Adding default values.~%")
    (IF (slot-empty-p cs-instance 'display-name)
        (SETF (SLOT-VALUE CS-INSTANCE 'DISPLAY-NAME)
              (SYMBOL-NAME (SLOT-VALUE CS-INSTANCE 'UNIQUE-NAME))))
    (IF (slot-empty-p cs-instance 'establish-confidence-vocabulary)
        (SETF (SLOT-VALUE CS-INSTANCE 'ESTABLISH-CONFIDENCE-VOCABULARY)
              (RETURN-GENERIC-INSTANCE 'USUAL-9-VAL)))
    (IF (slot-empty-p cs-instance 'parent-join)
        (SETF (SLOT-VALUE CS-INSTANCE 'parent-join) 'and))
    (if (slot-empty-p cs-instance 'use-cache)
	(setf (slot-value cs-instance 'use-cache)
	      *cs-use-cache*))
    (if (slot-empty-p cs-instance 'context-type)
	(setf (slot-value cs-instance 'context-type)
	      *context-type-default*))

    (FORMAT *TRACE-OUTPUT* "Setting up ESTABLISH agent.~%")
    (SETF (SLOT-VALUE CS-INSTANCE 'ESTABLISH-REJECT)
          (PARSE-ESTABLISH-REJECT (SLOT-VALUE CS-INSTANCE '
                                         DISPLAY-ESTABLISH-REJECT)))
    (if (NOT (slot-empty-p cs-instance 'display-establish-threshold))
	(progn
          (FORMAT *TRACE-OUTPUT* "Setting up establish threshold value.~%")
          (SETF (SLOT-VALUE CS-INSTANCE 'establish-THRESHOLD)
                (PARSE-THRESHOLD (SLOT-VALUE CS-INSTANCE '
                                        DISPLAY-establish-THRESHOLD))))
	  (setf (slot-value cs-instance 'establish-threshold) nil))
    (if (NOT (slot-empty-p cs-instance 'display-suspend-threshold))
	(progn
          (FORMAT *TRACE-OUTPUT* "Setting up suspend threshold value.~%")
          (SETF (SLOT-VALUE CS-INSTANCE 'suspend-THRESHOLD)
                (PARSE-THRESHOLD (SLOT-VALUE CS-INSTANCE '
                                        DISPLAY-suspend-THRESHOLD))))
	  (setf (slot-value cs-instance 'suspend-threshold) nil))
    (FORMAT *TRACE-OUTPUT* "Setting up translator.~%")
    (IF (NOT (slot-empty-p cs-instance 'display-translator))
        (SETF (SLOT-VALUE CS-INSTANCE 'TRANSLATOR)
              (PARSE-TRANSLATOR (SLOT-VALUE CS-INSTANCE '
                                      DISPLAY-TRANSLATOR)
                     (SLOT-VALUE CS-INSTANCE '
                            ESTABLISH-CONFIDENCE-VOCABULARY)))
        (SETF (SLOT-VALUE CS-iNSTANCE 'TRANSLATOR)
              NIL))
    (format *trace-output* "Setting up refine method.~%")
    (if (not (slot-empty-p cs-instance 'display-refine-form))
	(setf (slot-value cs-instance 'refine-form)
	      (mapcar
	       #'transform-invoke-forms
	       (parse-refine-form
		(slot-value cs-instance
			    'display-refine-form)
		(slot-value cs-instance 'unique-name)
		(slot-value cs-instance 'classifier))))
        (setf (slot-value cs-instance 'refine-form)
	      `(let ((sub-refine nil) (the-result-list nil))
		 (dolist (sub ',(slot-value cs-instance 'subspecialists))
			 (setf sub-refine 
			       (invoke (eval sub) 'establish-refine))
			 (if sub-refine
			     (setf the-result-list
				   (cons sub-refine the-result-list))))
		 (if ',(slot-value cs-instance 'subspecialists)
		     (append (list ',(slot-value cs-instance 'unique-name))
			   the-result-list)
		     ',(slot-value cs-instance 'unique-name)))))
    (FORMAT *TRACE-OUTPUT* 
           "Setting up establish and not-established actions.~%")
    (IF
     (NOT (slot-empty-p cs-instance 'display-established-action))
     (SETF
      (SLOT-VALUE CS-INSTANCE 'ESTABLISHED-ACTION)
      (CASE (LENGTH (SLOT-VALUE CS-INSTANCE 'DISPLAY-ESTABLISHED-ACTION
                           ))
            (0 NIL)
            (1 `,(CAR (MAPCAR #'TRANSFORM-INVOKE-FORMS
                             (SLOT-VALUE CS-INSTANCE '
                                    DISPLAY-ESTABLISHED-ACTION))))
            (OTHERWISE `,(CONS 'PROGN (MAPCAR #'TRANSFORM-INVOKE-FORMS
                                             (SLOT-VALUE CS-INSTANCE
                                                    '
                                             DISPLAY-ESTABLISHED-ACTION
                                                    ))))))
     (SETF (SLOT-VALUE CS-INSTANCE 'ESTABLISHED-ACTION)
           NIL))
    (IF
     (NOT (slot-empty-p cs-instance 'display-not-established-action))

     (SETF
      (SLOT-VALUE CS-INSTANCE 'NOT-ESTABLISHED-ACTION)
      (CASE (LENGTH (SLOT-VALUE CS-INSTANCE '
                           DISPLAY-NOT-ESTABLISHED-ACTION))
            (0 NIL)
            (1 `,(CAR (MAPCAR #'TRANSFORM-INVOKE-FORMS
                             (SLOT-VALUE CS-INSTANCE '
                                    DISPLAY-NOT-ESTABLISHED-ACTION))))
            (OTHERWISE `,(CONS 'PROGN (MAPCAR #'TRANSFORM-INVOKE-FORMS
                                             (SLOT-VALUE CS-INSTANCE
                                                    '
                                         DISPLAY-NOT-ESTABLISHED-ACTION
                                                    ))))))
     (SETF (SLOT-VALUE CS-INSTANCE 'NOT-ESTABLISHED-ACTION)
           NIL))
    (FORMAT *TRACE-OUTPUT* "Adding to classifier.~%")
    (ADD-TO-CLASSIFIER CS-NAME (EVAL (SLOT-VALUE CS-INSTANCE
                                            'CLASSIFIER))
           (SLOT-VALUE CS-INSTANCE 'SUPERSPECIALISTS)
           (SLOT-VALUE CS-INSTANCE 'SUBSPECIALISTS)
	   redefine)

    (FORMAT *TRACE-OUTPUT* "Building controller.~%")
    (setf (slot-value cs-instance 'parsed-controller) nil
	  (slot-value cs-instance 'parsed-tracing-controller) nil)
    (if (not (slot-empty-p cs-instance 'control-additions))
	(parse-controller-slot cs-instance 'classification-specialist))
    (SETF (SLOT-VALUE CS-INSTANCE 'PARSED-CONTROLLER)
          (append 
	   ;; make sure things come out in the right order -- the
	   ;; user-specified lambdas must come first in the assoc list,
	   ;; so they can shadow any system-define verbs they redefine
	   (slot-value cs-instance 'parsed-controller)
	   (CONTROLLERS CS-INSTANCE))

	  (slot-value cs-instance 'parsed-tracing-controller)
	  (append (slot-value cs-instance 'parsed-tracing-controller)
		  (controllers cs-instance)))

    (FORMAT *TRACE-OUTPUT* "Compiling controller.~%")
    (if *compile-controller*
	(SETF (SLOT-VALUE CS-INSTANCE 'ACTIONS)
	      (COMPILE-CONTROLLER (SLOT-VALUE CS-INSTANCE '
					      PARSED-CONTROLLER)))
        (setf (slot-value cs-instance 'actions)
	      (slot-value cs-instance 'parsed-controller)))
    (FORMAT *TRACE-OUTPUT* 
           "Finished compiling classifcation specialist ~S.~%" CS-NAME)))


(DEFUN ADD-UNRESOLVED-RELATIONS (NEW-RELATIONS OLD-LIST)
   (DOLIST (DRAG-LIST NEW-RELATIONS)
          (IF (NOT (ASSOC (CAR DRAG-LIST)
                          OLD-LIST))
              (SETF OLD-LIST (ACONS (CAR DRAG-LIST)
                                    (CDR DRAG-LIST)
                                    OLD-LIST))
              (RPLACD (ASSOC (CAR DRAG-LIST)
                             OLD-LIST)
                     (REMOVE-DUPLICATES
                      (APPEND (CDR DRAG-LIST)
                             (CDR (ASSOC (CAR DRAG-LIST)
                                         OLD-LIST)))))))
   (RETURN-FROM ADD-UNRESOLVED-RELATIONS OLD-LIST))


(defun new-case (drags)
  (let (drag-list eval-drag)
    (if (not (listp drags)) 
	(setf drag-list (list drags))
        (setf drag-list drags))

    (dolist (drag drag-list)
	    (if (symbolp drag)
		(setf eval-drag (eval drag))
	        (setf eval-drag drag))
	    (if (not (typep eval-drag 'classification-specialist))
		(error "~S is not a classification-specialist."
		       drag))
	    (setf (slot-value eval-drag 'case) nil
		  (slot-value eval-drag 'last-result) nil
		  (slot-value eval-drag 'last-establish-threshold) nil
		  (slot-value eval-drag 'last-suspend-threshold) nil
		  (slot-value eval-drag 'status) 'not-run
		  (slot-value eval-drag 'refine-result) nil))))

