#ifndef XPNET_H
#define XPNET_H
/*
    Added by Hay
   Defining constants to be used for creating command line options
   records to be passed to XtInitialize
*/
#define XtNnodeColor "nodeColor"
#define XtNlinkColor "linkColor"
#define XtNnewPar    "newPar"
#define XtNnewCut    "newCut"
#define XtNnewPerp   "newPerp"
#define XtNnewTensor "newTensor"
#define XtNshort     "short"
#define XtNpsShort   "psShort"

#define XtCNodeColor "NodeColor"
#define XtCLinkColor "LinkColor"
#define XtCNewPar    "NewPar"
#define XtCNewCut    "NewCut"
#define XtCNewPerp   "NewPerp"
#define XtCNewTensor "NewTensor"
#define XtCShort     "Short"
#define XtCPsShort   "PsShort"

#include <stdio.h>
#include <string.h>
#include <varargs.h>

/* *lots* of X garbage */
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#if 0
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#endif

#include <X11/Command.h>
#include <X11/Label.h>
#include <X11/Dialog.h>
#include <X11/Box.h>
#include <X11/Form.h>

#define DEFAULT_PERP_STR "~"
#define DEFAULT_TENSOR_STR "tensor"
#define DEFAULT_PAR_STR "par"
#define DEFAULT_CUT_STR "cut"


#define op_str_length 50
#define MAX_FORMULA 1000
#define UNINITIALIZED -1000
#define ALL -1
#define MOVE_MARK 1
#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#define set_and_inc(arg,n,v,i) XtSetArg (arg[i], n, v); ++i;
typedef enum {from_parent0, from_parent1, from_child,
		from_sibling, from_none} from_type;
     
/* abort and quit added by Hay on 11/13/91 */ 
/* scale, scale_x, scale_y, scale_u, xpn2ps, psprn are added by Hay */
/* Important: 
   If any changes are made to the type (op_type) below,
   make sure the to modify op_msg[] in panel.c */
typedef enum {none, move, axiom, pax, tensor, par, cut,
		delete, expand, file, save, read, 
		xpn2ps, psprn, cut_elm,	scale, scale_x, 
		scale_y, scale_u, abort, quit} op_type;

typedef enum {none, ax_prs, cut_prs, del_prs} cut_type;

struct _node;			/* we declare this later */

typedef struct
{
  struct _node *sibling;	/* other part (negated literal) of axiom */
  struct _node *child;	        /* user of this axiom */
  short bar_pos;		/* height of connecting bar */
} axiom_info;

typedef struct
{
  struct _node *child;	        /* user of this axiom */
  struct _node **siblings;      /* siblings of this node in proper axiom */
  short num_siblings;           /* number of siblings of this node */
  short bar_pos;		/* height of connecting bar */
} pax_info;

typedef struct
{
  struct _node *parents[2];	/* premisses of tensor or par */
  struct _node *child;	        /* user of tensor or par */
} tensor_info, par_info;

typedef struct
{
  struct _node *parents[2];	/* premisses of cut */
} cut_info;

typedef struct _node
{
  op_type type;		        /* node type (axiom, tensor, par, or cut) */
  struct _node *next;		/* next thing in list */
  short x, y;			/* position of UL corner of label displayed */
  short width;		        /* width of label on screen in pixels */
  char *name;			/* the complete formula for this node */
  short mark;			/* used for bookkeeping */
  union
    {
      axiom_info axiom; 	/* specifics for axiom */
      pax_info pax;             /* specifics for proper axiom */
      tensor_info tensor;	/* specifics for tensor */
      par_info par;		/* specifics for par */
      cut_info cut;		/* specifics for cut */
    } op;
} node;

typedef struct _node_pairs
{
  node *nd_pair[2];
  struct _node_pairs *next;
} node_pairs_list;

typedef struct _nodelist
{
  node *entry;
  struct _nodelist *next;
} nodelist;

typedef struct
{
  Widget toplevel;		/* toplevel widget */
  Widget form;		        /* thing that everything else is put in */
  Widget panel;		        /* control panel with all the buttons */
  Widget axiom;                 /* axiom creation button */
  Widget pax;                   /* proper axiom creation button */
  Widget tensor;                /* tensor creation button */
  Widget par;                   /* par creation button */
  Widget cut;                   /* cut creation button */
  Widget cut_elm;
  Widget move;		        /* move everything in net */
  Widget scale;                 /* scale the proof net */
  Widget delete;                /* delete one node & its dependents */
  Widget restart;		/* kill net and start over */
  Widget expand;                /* print out full name of node */
  Widget check;                 /* check the proof net */
  Widget file;                  /* file sub menu */
  Widget file_pshell;           /* popup for scaling proof net */
  Widget file_box;           /* dialog under comd_pshell */
  Widget file_cancel;           /* cancel file menu */
  Widget name_file;             /* title for scale menu widget */
  Widget save;                  /* save the proof net in file */
  Widget read;                  /* read the proof net from file */
  Widget xpn2ps;                /* Output to post-script file format */
  Widget psprn;                 /* psprint to printer */
  Widget abort;                 /* abort current operation */
  Widget quit;                  /* quit the program */
  Widget scale_pshell;          /* popup for scaling proof net */
  Widget scale_box;             /* dialog under comd_pshell */
  Widget name_scale;            /* title for scale menu widget */
  Widget scale_x;               /* scale the proof net along x axis */
  Widget scale_y;               /* scale the proof net along y axis */
  Widget scale_u;               /* scale uniformly in both direction */
  Widget scale_cancel;          /* cancel scaling operation */
  Widget name_pshell;	        /* popup for typing name */
  Widget name_dialog;	        /* dialog under name_pshell */
  Widget name_ok;	    	/* ok name */
  Widget name_cancel;           /* cancel operation */
  Widget canvas;		/* where proof nets are drawn */
  Widget message;		/* where messages are printed */
} widgets_type, *widgets_list;

/* declarations of global vars */
extern op_type current_operation, previous_operation;
extern widgets_list widgets;
extern int font_height, full_formula, ps_full_formula;
extern node *head, *head_delete;
extern char perp_str[], cut_str[], par_str[], tensor_str[];
extern XSegment *segments;


/* Added by Hay */
/* the following is used to select colors of nodes and links in canvas win */
/* It is also used to select the various operation modes such as operators
   symbols and short/full formular displayed/printed at nodes */
typedef struct 
         {
	   Pixel    NodeColor;
	   Pixel    LinkColor;
	   char    *NewPar;
	   char    *NewCut;	     
	   char    *NewPerp;
	   char    *NewTensor;
	   Boolean  Short;
	   Boolean  PsShort;
	 }
       AppData, *AppDataPtr;
/* End Hay */

extern AppData app_data;
extern int num_nodes;

/* declarations of functions */
node *make_new_node (), *get_selected_node (), *get_child (), *get_parent ();
char *create_node_name (), *copystring (), *catstrings (), *vcatstrings ();
char *get_label_displayed ();

#endif /* ifndef XPNET_H */

