#include "xpnet.h"

/* the next couple of things below are needed to set up the
   node and linc colors as command-line options */

/* Added by Hay */
XtResource xpnet_resources[] =
{
  {
    XtNnodeColor, XtCNodeColor, XtRPixel, sizeof(Pixel), 
    XtOffset(AppDataPtr, NodeColor), XtRString, (caddr_t) "blue",
  },
  {
    XtNlinkColor, XtCLinkColor, XtRPixel, sizeof(Pixel),
    XtOffset(AppDataPtr, LinkColor), XtRString, (caddr_t) "red",
  },
  {
    XtNnewPar, XtCNewPar, XtRString, sizeof(String),
    XtOffset(AppDataPtr, NewPar), XtRString, DEFAULT_PAR_STR,
  },
  {
    XtNnewTensor, XtCNewTensor, XtRString, sizeof(String),
    XtOffset(AppDataPtr, NewTensor), XtRString, DEFAULT_TENSOR_STR,
  },
  {
    XtNnewPerp, XtCNewPerp, XtRString, sizeof(String),
    XtOffset(AppDataPtr, NewPerp), XtRString, DEFAULT_PERP_STR,
  },
  {
    XtNnewCut, XtCNewCut, XtRString, sizeof(String),
    XtOffset(AppDataPtr, NewCut), XtRString, DEFAULT_CUT_STR,
  },
  {
    XtNshort, XtCShort, XtRBoolean, sizeof(Boolean),
    XtOffset(AppDataPtr, Short), XtRImmediate, (XtPointer) FALSE,
  },
  {
    XtNpsShort, XtCPsShort, XtRBoolean, sizeof(Boolean),
    XtOffset(AppDataPtr, PsShort), XtRImmediate, (XtPointer) FALSE,
  },
};


XrmOptionDescRec xpnet_options[] =
{
  {"-nc",        "*nodeColor", XrmoptionSepArg, NULL},
  {"-nodeColor", "*nodeColor", XrmoptionSepArg, NULL},
  {"-lc",        "*linkColor", XrmoptionSepArg, NULL},
  {"-linkColor", "*linkColor", XrmoptionSepArg, NULL},
  {"-par",       "*newPar",    XrmoptionSepArg, NULL},
  {"-tensor",    "*newTensor", XrmoptionSepArg, NULL},
  {"-perp",      "*newPerp",   XrmoptionSepArg, NULL},
  {"-cut",       "*newCut",    XrmoptionSepArg, NULL},
  {"-short",     "*short",     XrmoptionNoArg,  "True"},
  {"-psShort",   "*psShort",   XrmoptionNoArg,  "True"},
};
/* End Hay */

main (argc, argv)
     int argc;
     char *argv[];
{
  /* initialize everything with command-line options */
  widgets = (widgets_list) malloc (sizeof (widgets_type));
  widgets->toplevel = XtInitialize (argv[0], "XPnet", 
				    xpnet_options, XtNumber(xpnet_options),
				    &argc, argv);
  /* give error message if there are things unaccounted for on command line */
  if (argc > 1)
    {
      if (Syntax(argc, argv))
	return;
    };
  /* get the user-selected colors for nodes and links from command line */
  XtGetApplicationResources(widgets->toplevel, &app_data, xpnet_resources, 
			    XtNumber(xpnet_resources), NULL, 0);

  Test_Set_Operators();
  /* initialize the form, which holds all other widgets */
  widgets->form = XtCreateManagedWidget ("form", formWidgetClass,
					 widgets->toplevel, NULL, 0);
  /* init all the other widgets */
  init_panel (widgets);
  init_canvas (widgets);
  init_message (widgets);
  XtRealizeWidget (widgets->toplevel);
  init_canvas_gc ();
  XtMainLoop ();
}

/* this should be called after init_canvas so it can find size of canvas */
init_message (widgets)
     widgets_list widgets;
{
  Arg arg[8];
  int i;
  Dimension canvas_width;

  /* get width of canvas */
  XtSetArg (arg[0], XtNwidth, &canvas_width);
  XtGetValues (widgets->canvas, arg, 1);

  /* create message window */
  i = 0;
  set_and_inc (arg, XtNwidth, (XtArgVal) canvas_width, i);
  set_and_inc (arg, XtNfromVert, (XtArgVal) widgets->canvas, i);
  set_and_inc (arg, XtNfromHoriz, (XtArgVal) widgets->panel, i);
  set_and_inc (arg, XtNleft, (XtArgVal) XtChainLeft, i);
  set_and_inc (arg, XtNright, (XtArgVal) XtChainRight, i);
  set_and_inc (arg, XtNtop, (XtArgVal) XtChainBottom, i);
  set_and_inc (arg, XtNbottom, (XtArgVal) XtChainBottom, i);
  set_and_inc (arg, XtNlabel, (XtArgVal) "", i);
  widgets->message = XtCreateManagedWidget ("message", labelWidgetClass,
					    widgets->form, arg, i);
}

set_label (widget, string)
     Widget widget;
     String string;
{
  Arg arg[1];
  
  XtSetArg (arg[0], XtNlabel, (XtArgVal) string);
  XtSetValues (widget, arg, 1);
}

cat_message (va_alist)
     int va_alist;
{
  va_list args;
  char *result;
  
  va_start (args);
  result = vcatstrings (args);
  set_label (widgets->message, result);
  free (result);
}

clear_message ()
{
  set_label (widgets->message, "");
}


/* Added by Hay */
/* give error message indicating the right way to use command-line options */
Syntax(argc, argv)
     int argc;
     char *argv[];
{
  int i;
  int exit_program;

  for (i=1; i<argc; i++)
    {
      if (strcmp(argv[i], "-h"))
	/* if the option is not "-h" then complain about it */
	fprintf(stderr, "xpnet: unknown command line option, %s\n", argv[i]);
      else
	/* if the arg is "-h", set exit_program to 1 so the program will
	   not continue to run */
	exit_program = 1;
    }

  fprintf(stderr, "Xpnet understands all standard Xt command-line options.\n");
  fprintf(stderr, "It also understands the following additional options: \n");
  fprintf(stderr, "   Syntax                         Example\n");
  fprintf(stderr, "-nodeColor NameOfColor        -nodeColor blue\n");
  fprintf(stderr, "-nc NameOfColor               -nc blue\n");
  fprintf(stderr, "-linkColor NameOfColor        -linkColor yellow\n");
  fprintf(stderr, "-lc NameOfColor               -lc yellow\n");
  fprintf(stderr, "-par NewParSymbol             -par ++\n");
  fprintf(stderr, "-perp NewPerpSymbol           -perp ^\n");
  fprintf(stderr, "-cut NewCutSymbol             -cut #\n");
  fprintf(stderr, "-tensor NewTensorSymbol       -tensor *\n");
  fprintf(stderr, "-short                        -short\n");
  fprintf(stderr, "-psShort                      -psShort\n");

  return exit_program;
}

Test_Set_Operators()
{
  /* Copy parameters(for operators) which are either set through 
     application resource file(XPnet) or through command line options to the 
     their corresponding global variables */
  strcpy(par_str, app_data.NewPar);
  strcpy(perp_str, app_data.NewPerp);
  strcpy(tensor_str, app_data.NewTensor);
  strcpy(cut_str, app_data.NewCut);

  /* Any parameters(for operators) which are not preset or passed in the 
     command line are set to dedault values */
  if (!strcmp(perp_str, ""))
    strcpy(perp_str, DEFAULT_PERP_STR);
  if (!strcmp(par_str, ""))
    strcpy(par_str, DEFAULT_PAR_STR);
  if (!strcmp(cut_str, ""))
    strcpy(cut_str, DEFAULT_CUT_STR);
  if (!strcmp(tensor_str, ""))
    strcpy(tensor_str, DEFAULT_TENSOR_STR);
  full_formula     = !app_data.Short;
  ps_full_formula  = !app_data.PsShort;
}
/* End Hay */
