#include "xpnet.h"

/* By Hay Tran */
/* Begin cxpn2ps */
/* Define some poscript stuff; see aux.ps file */
#define DashedLine "DashedLine\n"
#define ShowPage "showpage\n"
#define SolidLine "SolidLine\n"
#define ParSymbol "ParSymbol\n"
#define PerpSymbol "currentpoint 8 add moveto\n PerpFont PerpSymbol currentpoint 8 sub moveto\n"
#define TensorSymbol "TensorSymbol\n"
#define MoveTo "moveto "
#define StrFont "StringFont "
#define OprFont "SymbolFont "
#define CalcCenteredX "CalcCenteredX "
#define SHORTEN 4
static int (*prn_ops[4])();
static char ops[4][30];

char *getenv();

prn_par(out_file)
     FILE *out_file;
/* 
  By Hay Tran
  Desc:
  prn_par prints output the postscript command line to call
  a function in aux.ps to print the par symbol
*/
{
  fprintf(out_file, "currentpoint 10 add 2 1 roll 10 add 2 1 roll %s\n", 
	  MoveTo);
  fprintf(out_file, "%s", ParSymbol);
  fprintf(out_file, "currentpoint 10 sub %s\n", MoveTo);
}

prn_perp(out_file)
     FILE *out_file;
/* 
  By Hay Tran
  Desc:
  prn_perp prints output the postscript command line to call
  a function in aux.ps to print the perp symbol
*/
{
 fprintf(out_file, "%s%s", OprFont, PerpSymbol);
}

prn_tensor(out_file)
     FILE *out_file;
/* 
  By Hay Tran
  Desc:
  prn_tensor prints output the postscript command line to call
  a function in aux.ps to print the tensor symbol
*/
{
  fprintf(out_file, "%s%s", OprFont, TensorSymbol);
}

int
output_ps_routines(out_file)
     FILE *out_file;
     /* 
       Copy the postscript auxiliary routines contained the file aux.ps 
       to the output file pointed to by out_file. Returns 1 if all went OK,
       0 otherwise.
       */
{
  FILE *in_file;
  char *home;
  char s[100];
  int sl = 100;

  /* look for aux.ps in /usr/local/lib */
  in_file = fopen("/usr/local/lib/aux.ps", "r");
  if (in_file == (FILE *) 0)
    {
      /* look for it in user's home directory */
      home = getenv ("HOME");
      strcpy (s, home);
      strcat (s, "/aux.ps");
      in_file = fopen(s, "r");
    }
  if (in_file == (FILE *) 0)
    /* look for it in this directory */
    in_file = fopen("aux.ps", "r");
  if (in_file == (FILE *) 0)
    /* forget it : it doesn't seem to be anywhere */
    return 0;
  while (!feof(in_file))
    {
      fgets(s, sl, in_file);
      fputs(s, out_file);
      *s = '\0';
    }

  /* 
    Move the page's origine to top left corner, hence:
     1. x-axis increases right-ward
     2. y-axis decreases down-ward
  */
  fprintf(out_file, "\n\n\n");
  fclose(in_file);

  return 1;
}



/* Remove pattern pat from the string s and put the result in r,
   also return a pointer to r as the function returned value */
char *rmpat(s, r, pat)
     char *s,  *r, *pat;
{
 char *s1, *t, *ps;
 int len_pat, i;

 ps = r;
 s1 = s;
 len_pat = strlen(pat);
 while (s1)
   {
    if (s1=strstr(s, pat))
      {
	t = s;
	while (t != s1)
	  {
	    *r++ =  *s++;
	    t++;
	  }
	*r++ = ' ';
	*r++ = ' ';
	for (i=0; i<len_pat; i++)
	  s++;
      }
   }
 while (*s != '\0')
   *r++ = *s++;

 *r = '\0';
 return ps;
}

/*
   Recursively printing the string name and replace the appropriate
   operator string with their corresponding symbol by first replacing
   tensor(prn=3), par(prn=2), and then perp(prn=1), and then axiom name(prn=0)
*/
ps_draw_mixed_string(name, prn, OutFile)
     char *name;
     int prn;
     FILE *OutFile;
{
  char *pt, t[100], *s1;
  int len_pat, i;
  
  
  if (!prn)  /* Just axiom names without perp, par, and/or tensor */
    fprintf(OutFile, "(%s) show\n", name);
  else
    {
      len_pat = strlen(ops[prn]);
      if (s1=strstr(name, ops[prn]))
	{
	  pt = t;
	  /* Parse and copy name to pt till an operator is found */
	  while (name != s1)
	    *pt++ = *name++;
	  *pt = '\0';
	  /* Print pt with remaining operator; one operator less */
	  ps_draw_mixed_string(t, prn-1, OutFile);
	  /* Print the corresponding operator symbol */
	  prn_ops[prn](OutFile);
	  fprintf(OutFile, "%s", StrFont);
	  /* Skips the operator string */
	  for (i=0; i<len_pat; i++)
	    name++;
	  /* Print the rest of the string */
	  ps_draw_mixed_string(name, prn, OutFile);
	}
      else /* There no such operator corresponding to prn, ie. prn=3 =>
	      the string, name, does not contain tensor operator;
	      check on the remaining operator */
	ps_draw_mixed_string(name, prn-1, OutFile);
    }

}

char *esc_letter(s, t, l1, l2)
     char *s, *t, l1, l2;
/* Escapes special charactors, l1 and l2 in string s and put the result in t */
{
  char *pt;

  pt = t;
  while (*s != '\0')
    {
      if ((l1 == *s) || (l2 == *s))
	*t++ = '\\';
      *t++ = *s++;
    }
  *t = '\0';
  return pt;
}



/* Print string, name, centering it at (x,y), to OutFile in poscript commands*/
ps_draw_string(x, y, name, OutFile)
     int x, y;
     char *name;
     FILE *OutFile;
{
  char r[200], t[200]; 

  strcpy(ops[1], perp_str);
  strcpy(ops[2], par_str);
  strcpy(ops[3], tensor_str);

  prn_ops[1] = prn_perp;
  prn_ops[2] = prn_par;
  prn_ops[3] = prn_tensor;

  fprintf(OutFile, "%s", StrFont);
  /* Calculate the starting position so that string will be centered 
     at (x, y+12) */
  fprintf(OutFile, "%d (%s) %s %d %s ", x,
	  rmpat(rmpat(rmpat(name, r, perp_str), t, par_str), r, tensor_str),
	  CalcCenteredX, -(y+12), MoveTo);

  /* draw the string and replaces all the operator strings with their
     corresponding  symbols */
  ps_draw_mixed_string(esc_letter(name, t, '(', ')'), 3, OutFile);
}


ps_draw_segments (dashed_line, num_segments, shorten, out_file)
     int dashed_line, num_segments, shorten;
     FILE *out_file;
     /*
       Draw a dashed segment, in the case of par, to the page 
       or Draw the corresponding par or tensor symbol, in other
       cases, to the page
       */
{
  int i, tshorten;

  if (dashed_line)  /* Draw Par lines */
    {
      for (i=0; i<num_segments; i++)
	{
	  if ((tshorten = segments[i].y2 - segments[i].y1) <= shorten)
	    tshorten = 0;
	  else
	    tshorten = shorten;
	  fprintf(out_file, "%d %d %d %d %s", segments[i].x1, 
		  -segments[i].y1 - tshorten, segments[i].x2, 
		  -segments[i].y2 + tshorten, DashedLine);
	}
    }
  else 
    if (num_segments == 2)  /* Draw Tensor lines */
      {
	if ((tshorten = segments[0].y2 - segments[0].y1) <= shorten)
	  tshorten = 0;
	else
	  tshorten = shorten;
	fprintf(out_file, "%d %d %d %d %s", segments[0].x1,
		-segments[0].y1 - tshorten, segments[0].x2, 
		-segments[0].y2 + tshorten, SolidLine);

	if ((tshorten = segments[1].y2 - segments[1].y1) <= shorten)
	  tshorten = 0;
	else
	  tshorten = shorten;
	fprintf(out_file, "%d %d %d %d %s", segments[1].x1,
		-segments[1].y1 - tshorten, segments[1].x2,
		-segments[1].y2 + tshorten, SolidLine);
      }
    else /* Axiom, Pax, or Cut lines */
      {
	/* Find out if there is a need for shortening */
	tshorten = shorten;
	for (i=0; tshorten && (i<num_segments-1); i++)
	  {
	    if ((segments[i].y2 - segments[num_segments-1].y2) <= shorten)
	      tshorten = 0;
	  };
	for (i=0; i<num_segments-1; i++)	
	  fprintf(out_file, "%d %d %d %d %s", segments[i].x1,
		  -segments[i].y1 - tshorten, segments[i].x2, 
		  -segments[i].y2 + tshorten, SolidLine);
	
        /* Last line is the horizontal lines and need to short same way */

	fprintf(out_file, "%d %d %d %d %s", segments[i].x1, 
		-segments[i].y1 - tshorten , segments[i].x2, 
		-segments[i].y2 - tshorten, SolidLine);
      }
}

int
cxpn2ps(xpn_graph, out_file)
     node *xpn_graph;
     FILE *out_file;
     /*
       cxpn2ps convert xpn_graph to poscript representation of the graph
       and store it in out_file.  Then to print the graph on a ps-printer
       just type psprint out_file; or it could be included with latex file
       also. Returns 1 if everything went OK, 0 otherwise.
       */
{
  int x, i, num_nodes, bar_pos, tmp_full_formula;
  node *cnode, *parent, *nd;
 
  tmp_full_formula = full_formula;
  full_formula = ps_full_formula;
  if (output_ps_routines(out_file) == 0)
    {
      set_label (widgets->message, "Could not find file \"aux.ps\".");
      return 0;
    }
  cnode = xpn_graph; 
  while (cnode != (node *) 0)
    {
      /* display node and its connections */
      switch (cnode->type)
	{
	case axiom:
	case pax:
	  bar_pos = get_bar_pos (cnode);
	  num_nodes = (cnode->type == axiom) ? 2 :
	    cnode->op.pax.num_siblings + 1;
	  /* fill in vertical segment info */
	  for (nd = cnode, i = 0; i < num_nodes; ++i, nd = nd->next)
	    put_vert_seg_info (nd->x, nd->y, nd->width, i);

	  put_bar_pos_info (bar_pos, num_nodes);
	  /* draw formulas and connecting bar */
	  for (nd = cnode, i = 0; i < num_nodes; ++i, nd = nd->next)
	    {
	      if (pax==cnode->type)
		ps_draw_string(segments[i].x1, nd->y, 
			       nd->name, out_file);
	      else
		ps_draw_string ((i % 2) ? segments[i].x1 + 5 : 
				segments[i].x1,
				nd->y, nd->name, out_file);
	    }
	  ps_draw_segments (0, num_nodes + 1, SHORTEN, out_file);
	  /* skip to the last node in this bunch */
	  for (i = 1; i < num_nodes; ++i, cnode = cnode->next);
	  break;
	case tensor:
	case par:
	  parent = get_parent (cnode, 0);
	  segments[0].x1 = parent->x + parent->width / 2; 
	  segments[0].y1 = parent->y + font_height-3;
	  parent = get_parent (cnode, 1);
	  segments[1].x1 = parent->x + parent->width / 2; 
	  segments[1].y1 = parent->y + font_height-3;
	  segments[0].y2 = segments[1].y2 = cnode->y;
	  segments[0].x2 = /* cnode->x + x; */ 
	  segments[1].x2 = cnode->x + cnode->width / 2; 
	  /* draw node */
	  ps_draw_segments (cnode->type == par, 2, SHORTEN, out_file);
	  ps_draw_string (segments[0].x2, cnode->y, 
			  get_label_displayed (cnode), out_file);
	  break;
	case cut:
	  /* fill in drawing data */
	  parent = get_parent (cnode, 0);
	  put_vert_seg_info (parent->x, parent->y + font_height,
			     parent->width, 0);
	  parent = get_parent (cnode, 1);
	  put_vert_seg_info (parent->x, parent->y + font_height,
			     parent->width, 1);
	  put_bar_pos_info (cnode->y, 2);
	  /* draw in node */
	  ps_draw_segments (0, 3, 0, out_file);
	  ps_draw_string ((int)((segments[0].x1 + segments[1].x1)/2), 
			  cnode->y, cut_str, out_file);
	  break;
	}
      /* go to next node */
      cnode = cnode->next;
    }
  fputs(ShowPage, out_file);
  fputs("\n\n", out_file);
  full_formula = tmp_full_formula;

  return 1;
}



psprint_graph(printername)
     char *printername;
/* 
  By Hay
  Description:
   psprint_graph print a proof net represented in head to the printer
   named, printername.   printername can be one of the following values:
   -h               uses system's default value with -h option
   [-P]printerName [-h] print to printerName with -h optional
*/
{
  FILE *out_file;
  char shell_command[100], template[50];

  /* 
    Try to create a temporary file whose path is /tmp/tmp.ps for writing
    a the result from converting head to a poscript format before writing to
    the printer via psprint command 
    */

  /* get a unique temporary file name in the /tmp directory */
  strcpy(template, "/tmp/xpnetXXXXXXX");
  do
    {
    }
  while (mkstemp(template) == -1);

  if ((out_file = fopen (template, "w")) == (FILE *) 0)
    {
      cat_message ("Cannot open file \"", template, "\".", (char *) 0);
      return;
    }

  /* 
    Convert the graph, head, to postscript commands and store them in 
    out_file 
    */
  if (cxpn2ps(head, out_file) == 0)
    {
      fclose (out_file);
      reset_operation();
      return;
    }

  fclose (out_file);

  /* System calls to print the result in tempplate */
  strcpy(shell_command, "psprint ");

  /* if printername is "-P" or ""
     then printer name takes on system's default value*/
  if (strcmp(printername, "") && strcmp(printername, "-P"))
    { /* test to see if printer name is given with -P 
         or use system's default value with -h */
      if (strncmp(printername, "-P", 2) && strcmp(printername, "-h"))
	strcat(strcat(shell_command, "-P"), printername);
      else
	strcat(shell_command, printername);
    };
     
  strcat(shell_command, " ");
  strcat(shell_command, template);
  strcat(strcat(shell_command, "; rm "), template);
  system(shell_command);
  reset_operation();
  set_label (widgets->message, "Graph sent to printer spool.");
}

ps_write_graph_to_file (filename)
     char *filename;
/* 
   By Hay 
   Desc:
   ps_write_graph_to_file writes head to an output file named, filename,
   in postcript representation, i.e. postscript program equvivalent 
   filename is any valid OS's path name */

{
  FILE *out_file;

  /* check if the file exists and open it */
  if ((out_file = fopen (filename, "w")) == (FILE *) 0)
    {
      cat_message ("Cannot open file \"", filename, "\".", (char *) 0);
      reset_operation();
      return;
    }
  if (cxpn2ps(head, out_file) == 0)
    {
      fclose (out_file);
      reset_operation();
      return;
    }
  fclose (out_file);
  reset_operation();
  set_label (widgets->message, "Done.");
}

