#include "xpnet.h"

extern char *copystring(), *strstr ();

int     
copy_literal_plus (old_str, i_p, new_str, j_p, old_perp, new_perp)
char *old_str, *new_str, *old_perp, *new_perp;
int *i_p, *j_p;
{
  /* This routine copies a literal, plus possible parentheses around it,
     changing the old_perp to new_perp if old_perp is there */
  int i, j, begin_literal;
  char *ptr;

  i = *i_p;
  j = *j_p;
  /* copy open parentheses */
  while (old_str[i] == '(')
    new_str[j++] = old_str[i++];
  begin_literal = j;   /* beginning of the literal in the new str */
  skip_whitespace (old_str, &i);
  /* copy the string until we find whitespace or ')' or '\0' -- this
     will get the entire literal */
  while (!isspace (old_str[i]) && old_str[i] != ')' && old_str[i] != '\0')
    new_str[j++] = old_str[i++];
  /* now see if we have an old_perp in the literal just copied */
  new_str[j] = '\0';
  if ((ptr = strstr (new_str + begin_literal, old_perp)) != (char *) 0)
    {
      /* copy over new_perp */
      strcpy (ptr, new_perp);
      j = j - strlen (old_perp) + strlen (new_perp);
    }
  /* copy close parentheses */
  while (old_str[i] == ')')
    new_str[j++] = old_str[i++];
  *i_p = i;
  *j_p = j;
}

/* returns 1 if connective was OK (ie, tensor or par), ow returns 0 */
int
copy_connective (old_str, i_p, new_str, j_p, old_tensor, new_tensor,
		 old_par, new_par, old_cut)
char *old_str, *new_str, *old_tensor, *new_tensor, *old_par, *new_par;
char *old_cut;
int *i_p, *j_p;
{
  int i, j;

  i = *i_p;
  j = *j_p;

  /* this routine copies the connective, changing tensor and par strings */
  if (str_eq (old_str + i, old_tensor))
    {
      strcpy (new_str + j, new_tensor);
      i += strlen (old_tensor);
      j += strlen (new_tensor);
    }
  else if (str_eq (old_str + i, old_par))
    {
      strcpy (new_str + j, new_par);
      i += strlen (old_par);
      j += strlen (new_par);
    }
  else if (str_eq (old_str + i, old_cut))
    {
      set_label (widgets->message, "Cut found in pax formula.");
      return 0;
    }
  else
    {
      set_label (widgets->message, "Unknown connective in pax formula.");
      return 0;
    }
      
  /* everything's OK; return 1 */
  *i_p = i;
  *j_p = j;
  return 1;
}

int
parse_formula (formula)
char *formula;
{

  /* This procedure has two main purposes: Firstly, the formulas are
     entered in the file with the connectives written as "tensor" and "par"
     and perp written as "~", and these need to be replaced with the
     constants tensor_str, par_str, and perp_str which may or may not be
     the same. Secondly, formulas with cuts in them are not valid since
     they cannot be used as premises of formulas.

     The formula is already assumed to have the following properties:
     First, all desired precedence and associativity must be explicit:
     for example, "a tensor b par c" is illegal and must be written as
     either "(a tensor b) par c" or "a tensor (b par c)" depending on how
     you want it parsed, and "a par b par c" must be written as
     "(a par b) par c" or "a par (b par c)". Second, perp cannot be
     applied to a formula that is more complicated than a literal, thus it
     must be brought inside, using De Morgan's Law, so that it applies only
     to literals. Third, there must be some whitespace before and after
     every connective ("tensor" and "par") and there can be no space
     between the perp ("~") and the axiom name in negated literals.
     Fourth, every formula must have a ";" after it to indicate the end 
     of the formula.

     It parses the string in place, ie, it returns the parsed string in
     the same string it was sent in, and asumes the string is large enough
     to hold the possibly larger new string. */

  int i, j, end;
  char str[MAX_FORMULA];

  /* copy the formula, with the names changed, into str */
  i = j = 0;
  end = strlen (formula);
  skip_whitespace (formula, &i);
  copy_literal_plus (formula, &i, str, &j, "~", perp_str);
  skip_whitespace (formula, &i);
  str[j++] = ' ';
  while (i < end)
    {
      if (copy_connective (formula, &i, str, &j, "tensor", tensor_str,
			   "par", par_str, "cut") == 0)
	return 0;
      skip_whitespace (formula, &i);
      str[j++] = ' ';
      copy_literal_plus (formula, &i, str, &j, "~", perp_str);
      skip_whitespace (formula, &i);
      str[j++] = ' ';
    }
  str[j - 1] = '\0';

  /* now copy str back into formula */
  strcpy (formula, str);
  
  /* everything went OK */
  return 1;
}

char *
unparse_formula (formula, str)
char *formula, *str;
{
  /* This routine is mostly an inverse to parse_formula: it replaces
     tensor_str, par_str, and perp_str with "tensor", "par", and "~".
     It places the resulting string in str, which is assumed
     to be an array large enough to hold the unparsed string. Then it 
     returns the argument str */

  /* copy the formula, with the names changed, into str */
  int i, j, end;

  i = j = 0;
  end = strlen (formula);
  skip_whitespace (formula, &i);
  copy_literal_plus (formula, &i, str, &j, perp_str, "~");
  skip_whitespace (formula, &i);
  str[j++] = ' ';
  while (i < end)
    {
      copy_connective (formula, &i, str, &j, tensor_str, "tensor", 
		       par_str, "par", cut_str);
      skip_whitespace (formula, &i);
      str[j++] = ' ';
      copy_literal_plus (formula, &i, str, &j, perp_str, "~");
      skip_whitespace (formula, &i);
      str[j++] = ' ';
    }
  str[j - 1] = '\0';
  
  return (str);
}

assign_siblings (first_node, num_nodes)
node *first_node;
int num_nodes;
{
  node *n1, *n2;
  int k1, k2, i;
  
  for (k1 = 0, n1 = first_node; k1 < num_nodes; ++k1, n1 = n1->next)
    {
      /* assign number of siblings */
      n1->op.pax.num_siblings = num_nodes - 1;
      /* allocate siblings array for n1 */
      n1->op.pax.siblings = (node **)
	malloc ((num_nodes - 1) * sizeof (node *));
      /* put in pointers to all other nodes in pax */
      for (k2 = i = 0, n2 = first_node; k2 < num_nodes; ++k2, n2 = n2->next)
	if (n1 != n2)
	  n1->op.pax.siblings[i++] = n2;
    }
}

skip_over_whitespace (file)
FILE *file;
{
  int c;

  while (isspace(c = getc (file)));
  ungetc (c, file);
}

parse_pax_file (filename)
char *filename;
{
  FILE *file;
  int num_formulas = 0, c, i;
  char formula[MAX_FORMULA];
  node *pax_head = (node *) 0, *pax_tail = (node *) 0;

  /* check if the file exists and open it */
  if ((file = fopen (filename, "r")) == (FILE *) 0)
    {
      cat_message ("Cannot open file \"", filename, "\".", (char *) 0);
      /*  Setting "current_operation" to none, and reverse the box! */
      reset_operation();
      return;
    }

  /* get rid of blank lines before formulas */
  skip_over_whitespace (file);
  /* formula, allocate a node and put in the formula */
  while ((c = getc (file)) != EOF)
    {
      /* make a new node and attach it to the end */
      add_node (make_new_node (pax), &pax_head, &pax_tail);
      /* put formula into string (copy all chars except '\n' and ';',
	 if character is '\n' put a blank in the string) */
      for (i = 0; c != ';'; c = getc (file))
	{
	  if (c == '\n')
	    formula[i++] = ' ';
	  else
	    formula[i++] = c;
	}
      formula[i] = '\0';
      if (parse_formula (formula) == 0)
	{
	  /*  Setting "current_operation" to none, and reverse the box! */
	  reset_operation();
	  return;
	}
      pax_tail->name = copystring (formula);
      ++num_formulas;
      /* deal with blank lines after formulas */
      skip_over_whitespace (file);
    }

  fclose (file);
  if (num_formulas == 0)
      {
      set_label (widgets->message, "No formulas in file.");
      /*  Setting "current_operation" to none, and reverse the box! */
      reset_operation();
      return;
    }

  /* assign sibling arrays and pointers */
  assign_siblings (pax_head, num_formulas);
  
  /* now arrange to place the thing on the canvas */
  setup_pax (pax_head, num_formulas);
}
