/*
 11/08/91
  Correct the opperations on null graph problem.
  most of the call backs functions that need data from the main graph, head.
  These are the *_cb functions
*/

#include "xpnet.h"
#define NBUTTONS 14
#define BUTTON_GAP 5

char *op_msg[]={"None", "Move", "Axiom", "Pax", "Tensor", "Par", "Cut", 
		  "Delete", "Expand", "File", "Save", "Read", 
		  "Xpn2ps", "Psprn", "CutElim", "Scale", "Scale_x", 
		  "Scale_y", "Scale_u", "Abort", "Quit"};




void reverse_colors(w)
Widget w;
{ Arg arg[2];
  Pixel fg, bg;

  XtSetArg (arg[0], XtNforeground, (XtArgVal) &fg);
  XtSetArg (arg[1], XtNbackground, (XtArgVal) &bg);
  XtGetValues (w, arg, 2);
  XtSetArg (arg[0], XtNforeground, (XtArgVal) bg);
  XtSetArg (arg[1], XtNbackground, (XtArgVal) fg);
  XtSetValues(w, arg, 2);

}

get_pointer_location (toplevel_widget, x_p, y_p)
     Widget toplevel_widget;
     int *x_p, *y_p;
{
  Display *display;
  Window root, child;
  int win_x, win_y;
  unsigned int keys_buttons;
  
  display = XtDisplay (toplevel_widget);
  XQueryPointer (display, RootWindowOfScreen (XtScreen (toplevel_widget)),
		 &root, &child, x_p, y_p, &win_x, &win_y, &keys_buttons);
}

popup_name (widgets, title_of_dialog)
     widgets_list widgets;
{
  int x, y;
  Arg arg[2];
  
  /* move the popup shell to current pointer location */
  get_pointer_location (widgets->toplevel, &x, &y);
  XtSetArg (arg[0], XtNx, x);
  XtSetArg (arg[1], XtNy, y);
  XtSetValues (widgets->name_pshell, arg, 2);
  /* clear text */
  XtSetArg (arg[0], XtNvalue, "");
  XtSetValues (widgets->name_dialog, arg, 1);
  /* retitle dialog */
  set_label (widgets->name_dialog, title_of_dialog);
  /* bring it up */
  XtPopup (widgets->name_pshell, XtGrabNonexclusive);
}

popup_comd (widgets, title_of_dialog)
     widgets_list widgets;
{
  int x, y;
  Arg arg[2];
  
  /* move the popup shell to current pointer location */
  get_pointer_location (widgets->toplevel, &x, &y);
  XtSetArg (arg[0], XtNx, x);
  XtSetArg (arg[1], XtNy, y);
  XtSetValues (widgets->scale_pshell, arg, 2);
  /* Set title */
  XtSetArg (arg[0], XtNvalue, "");
  XtSetValues (widgets->name_scale, arg, 1);
  /* retitle dialog */
  set_label (widgets->name_scale, title_of_dialog);
  /* bring it up */
  XtPopup (widgets->scale_pshell, XtGrabNonexclusive);
}

popup_file (widgets, title_of_dialog)
     widgets_list widgets;
{
  int x, y;
  Arg arg[2];
  
  /* move the popup shell to current pointer location */
  get_pointer_location (widgets->toplevel, &x, &y);
  XtSetArg (arg[0], XtNx, x);
  XtSetArg (arg[1], XtNy, y);
  XtSetValues (widgets->file_pshell, arg, 2);
  /* Set title */
  XtSetArg (arg[0], XtNvalue, "");
  XtSetValues (widgets->name_file, arg, 1);
  /* retitle dialog */
  set_label (widgets->name_file, title_of_dialog);
  /* bring it up */
  XtPopup (widgets->file_pshell, XtGrabNonexclusive);
}

/* checks current_operation; if an operation is already underway, returns
   0 to indicate error; otherwise sets current_operation to new operation */
int
  check_and_set_op (widgets, new_op)
widgets_list widgets;
op_type new_op;
{
  char msg[100];

  /* check & set the operation */
  if (current_operation == none)
    {
      current_operation = new_op;
      set_label(widgets->message,"");
      return 1;
    }

  set_label (widgets->message, 
	     strcat(strcat(strcpy(msg, "Previous operation, "), 
			   op_msg[current_operation]),
		    ", is not finished"));
  return 0;
}

GraphIsEmpty()
{
  if (head == NULL)
    {
      current_operation = none;
      set_label(widgets->message, "Graph is empty.");
      return 1;
    };
  return 0;
}

void
  delete_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if ((current_operation != delete) &&
      (!check_and_set_op (widgets, none)))
    return;

  if (GraphIsEmpty())
    return;

  if ((current_operation == delete) && (head_delete))
    {
      recursive_delete(head_delete, 1);
      head_delete = NULL;
      set_label (widgets->message, "Thanks.");
      redisplay_canvas();
      clear_action_functions();
      reset_operation();
    }
  else
    {
      if (!check_and_set_op (widgets, delete))
	return;
      reverse_colors(widgets->delete);
      setup_delete ();
    }
}


void
  restart_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, none))
    return;
  free_graph ();
  clear_message ();
  clear_canvas ();
}

void
  move_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, move))
    return;

  if (GraphIsEmpty())
    return;

  reverse_colors(widgets->move);
  setup_move ();
}


void
  axiom_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, axiom))
    return;
  reverse_colors(widgets->axiom);
  popup_name (widgets, "Name of axiom:");
}

void
pax_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, pax))
    return;
  reverse_colors(widgets->pax);
  popup_name (widgets, "File with formulas: ");
}

/*ARGSUSED*/
void
  name_ok_cb (w, wid, call_data)
Widget w;
widgets_list wid;
caddr_t call_data;
{
  char  *str;

  XtPopdown (widgets->name_pshell);
  str = XawDialogGetValueString (widgets->name_dialog);
  switch (current_operation)
    {
      /* Added and/or modified by Hay */
    case scale_x:
    case scale_y:
    case scale_u:
      XtPopdown (widgets->scale_pshell);
      get_factor_and_scale_graph (str);
      reverse_colors(widgets->scale); 
      break;
    case save:
    case read:
    case xpn2ps:
    case psprn:
      XtPopdown (widgets->file_pshell);
      switch (current_operation)
	{
	case save:
	  write_graph_to_file (str);
	  break;
	case read:
	  read_graph_from_file (str);
	  break;
	case xpn2ps:
	  ps_write_graph_to_file (str);
	  break;
	case psprn:
	  psprint_graph(str);
	  break;
	};
      reverse_colors(widgets->file);
      break;
      /* End Hay */
    case axiom:
      if (!strcmp(str, ""))
	{
	  reset_operation(); /* current_operation = none; */
	  set_label(widgets->message, "No axiom name!");
	}
      else
	setup_operation (axiom, str);
      break;
    case pax:
      parse_pax_file (str);
      break;
    }
}

void
  popup_cancel_cb (w, widgets, call_data)
Widget w;
widgets_list widgets;
caddr_t call_data;
{
  /*  Setting "current_operation" to none, and reverse the box! */
  reset_operation();
  if (previous_operation == file)
    {
      current_operation = file;
      previous_operation == none;
    }
  else
    if(previous_operation == scale)
      {
	current_operation = scale;
	previous_operation == none;
      };
  reset_operation();
  XtPopdown (widgets->name_pshell);
  XtPopdown (widgets->scale_pshell);
  XtPopdown (widgets->file_pshell);
}

void
  tensor_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, tensor))
    return;

  if (GraphIsEmpty())
    return;

  reverse_colors(widgets->tensor);
  setup_operation (tensor, (char *) 0);
}

void
  par_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, par))
    return;

  if (GraphIsEmpty())
    return;

  reverse_colors(widgets->par);
  setup_operation (par, (char *) 0);
}

void 
  cut_elm_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  node *temp_nd;
  int no_cuts;

  if (!check_and_set_op(widgets, none))
    return;

  if (GraphIsEmpty())
    return;

  /* Check for existance of a cut node */
  no_cuts = 1;
  for (temp_nd = head; 
       temp_nd != (node *) 0;
       temp_nd = temp_nd->next)
    if (temp_nd->type == cut)
      no_cuts = 0;
  if (no_cuts)
    {
      set_label(widgets->message, "There is no <cut> node to eliminate.");
      return;
    };

  current_operation = cut_elm;
  reverse_colors(widgets->cut_elm);
  setup_cut_elm();
}


void
  cut_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{

  if (!check_and_set_op (widgets, cut))
    return;

  if (GraphIsEmpty())
    return;

  reverse_colors(widgets->cut);
  setup_operation (cut, (char *) 0);
}

void
  expand_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{

  if (!check_and_set_op (widgets, expand))
    return;

  if (GraphIsEmpty())
    return;

  reverse_colors(widgets->expand);
  setup_expand ();
}

void
  check_cb
  (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{

  if (!check_and_set_op (widgets, none))
    return;

  if (GraphIsEmpty())
    return;

  if (graph_is_proof_net ())
    set_label (widgets->message, "Net is ok.");
  else
    set_label (widgets->message, "This is not a proof net.");
}

void
  save_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{

  if (!check_and_set_op (widgets, save))
    return;

  if (GraphIsEmpty())
    return;

  reverse_colors(widgets->save);
  popup_name (widgets, "Name of file:");
}

void
  psprn_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, psprn))
    return;
  
  if (GraphIsEmpty())
    return;

  reverse_colors(widgets->psprn);
  popup_name (widgets, "Printer Name:");
}

void
  xpn2ps_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{

  if (!check_and_set_op (widgets, xpn2ps))
    return;

  if (GraphIsEmpty())
    return;

  reverse_colors(widgets->xpn2ps);
  popup_name (widgets, "File Name:");
}




void
  read_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, read))
    return;

  reverse_colors(widgets->read);
  popup_name (widgets, "Name of file: ");
}

void
  scale_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{

  if (!check_and_set_op (widgets, scale))
    return;

  if (GraphIsEmpty())
    return;

  /*  Setting "current_operation" to none, and reverse the box! */
  reset_operation();
  previous_operation = scale; 
  popup_comd (widgets, "Scale Menu: ");
}

void
  file_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, file))
    return;
  /*  Setting "current_operation" to none, and reverse the box! */
  reset_operation();
  /* Make a note so that upon returning, file box can be reversed highlited */
  previous_operation = file;
  popup_file (widgets, "File Menu: ");
}

/* Added by Hay */
/* popup a window and get the scale value for x */
void
  scale_x_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, scale_x))
    return;
  reverse_colors(widgets->scale_x); 
  popup_name (widgets, "Scale X by: ");
}

/* popup a window and get the scale value for y */
void
  scale_y_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, scale_y))
    return;
  reverse_colors(widgets->scale_y);
  popup_name (widgets, "Scale Y by: ");
}

/* popup a window and get a scale value for both x and y*/
void
  scale_u_cb (w, widgets, call_data)
widgets_list widgets;
caddr_t call_data;
{
  if (!check_and_set_op (widgets, scale_u))
    return;
  reverse_colors(widgets->scale_u); 
  popup_name (widgets, "Scale by: ");
}
/* End Hay */

void
  quit_cb (w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
  exit (0);
}

void
  abort_cb (w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
  set_label (widgets->message, "");
  if (current_operation == move)
    abort_move ();
  if (current_operation == cut_elm)
    abort_cut_elm();
  if (current_operation != none)
    {
      /* cancel the current operation */
      /*  Setting "current_operation" to none, and reverse the box! */
      reset_operation();
      cancel_current_canvas_op ();
      clear_message ();
    }
}


init_panel (widgets)
     widgets_list widgets;
{
  Arg arg[9];
  int i;
  /* Added by Hay */
  static XtActionsRec name_actions[] =
    {
      {"Name_ok_cb", (XtActionProc) name_ok_cb}
    };
  String name_translations = 
    "#override\n\
     <Key>Return:	Name_ok_cb()";
  /* End Hay */

  /* create the panel */
  widgets->panel = XtCreateManagedWidget ("panel", boxWidgetClass,
					  widgets->form, NULL, 0);

  /* create all the buttons */
  i = 0;
  widgets->axiom = XtCreateManagedWidget
    ("axiom", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->pax = XtCreateManagedWidget
    ("pax", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->tensor = XtCreateManagedWidget
    ("tensor", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->par = XtCreateManagedWidget
    ("par", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->cut = XtCreateManagedWidget
    ("cut", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->cut_elm = XtCreateManagedWidget
    ("cutElim", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->move = XtCreateManagedWidget
    ("move", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->delete = XtCreateManagedWidget
    ("delete", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->restart = XtCreateManagedWidget
    ("restart", commandWidgetClass, widgets->panel, NULL, 0);
  /* Added by Hay */
  widgets->scale = XtCreateManagedWidget
    ("scale", commandWidgetClass, widgets->panel, NULL, 0);
  /* End Hay */
  if (!full_formula)
    widgets->expand = XtCreateManagedWidget
      ("expand", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->check = XtCreateManagedWidget
    ("check", commandWidgetClass, widgets->panel, NULL, 0);
  /* Added by Hay */
  widgets->file = XtCreateManagedWidget
    ("file", commandWidgetClass, widgets->panel, NULL, 0);
  /* End Hay */

  widgets->abort = XtCreateManagedWidget
    ("abort", commandWidgetClass, widgets->panel, NULL, 0);
  widgets->quit = XtCreateManagedWidget
    ("quit", commandWidgetClass, widgets->panel, NULL, 0);
  
  /* set values for resources of the panel */
  i = 0;
  set_and_inc (arg, XtNx, (XtArgVal) 0, i);
  set_and_inc (arg, XtNy, (XtArgVal) 0, i);
  set_and_inc (arg, XtNhSpace, (XtArgVal) BUTTON_GAP, i);
  set_and_inc (arg, XtNvSpace, (XtArgVal) BUTTON_GAP, i);
  /* Fix the size of the panel window by chaining both top & bottom
     to the top, and both left & right to the left */
  set_and_inc (arg, XtNtop, (XtArgVal) XtChainTop, i);
  set_and_inc (arg, XtNbottom, (XtArgVal) XtChainTop, i);
  set_and_inc (arg, XtNleft, (XtArgVal) XtChainLeft, i);
  set_and_inc (arg, XtNright, (XtArgVal) XtChainLeft, i);
  set_and_inc (arg, XtNresizable, (XtArgVal) FALSE, i);
  XtSetValues (widgets->panel, arg, i);
  
  /* set the callbacks for the buttons */
  XtAddCallback (widgets->axiom, XtNcallback, axiom_cb, widgets);
  XtAddCallback (widgets->pax, XtNcallback, pax_cb, widgets);
  XtAddCallback (widgets->tensor, XtNcallback, tensor_cb, widgets);
  XtAddCallback (widgets->par, XtNcallback, par_cb, widgets);
  XtAddCallback (widgets->cut_elm, XtNcallback, cut_elm_cb, widgets);
  XtAddCallback (widgets->cut, XtNcallback, cut_cb, widgets);
  XtAddCallback (widgets->move, XtNcallback, move_cb, widgets);
  XtAddCallback (widgets->scale, XtNcallback, scale_cb, widgets);
  XtAddCallback (widgets->file, XtNcallback, file_cb, widgets);
  XtAddCallback (widgets->delete, XtNcallback, delete_cb, widgets);
  XtAddCallback (widgets->restart, XtNcallback, restart_cb, widgets);
  if (!full_formula)
    XtAddCallback (widgets->expand, XtNcallback, expand_cb, widgets);
  XtAddCallback (widgets->check, XtNcallback, check_cb, widgets);
  XtAddCallback (widgets->abort, XtNcallback, abort_cb, widgets);
  XtAddCallback (widgets->quit, XtNcallback, quit_cb, widgets);
  
  /* Added by Hay */
  /* create scale popup */
  widgets->scale_pshell = XtCreatePopupShell 
    ("scale_pshell", transientShellWidgetClass, widgets->toplevel, NULL, 0);
  widgets->scale_box = XtCreateManagedWidget 
    ("scale_box", boxWidgetClass, widgets->scale_pshell, NULL, 0);
  widgets->name_scale = XtCreateManagedWidget 
    ("name_scale", labelWidgetClass, widgets->scale_box, NULL, 0);
  widgets->scale_x = XtCreateManagedWidget 
    ("scale_x", commandWidgetClass, widgets->scale_box, NULL, 0);
  widgets->scale_y = XtCreateManagedWidget 
    ("scale_y", commandWidgetClass, widgets->scale_box, NULL, 0);
  widgets->scale_u = XtCreateManagedWidget
    ("scale_u", commandWidgetClass, widgets->scale_box, NULL, 0);
  XtSetArg (arg[0], XtNlabel, "Cancel");
  widgets->scale_cancel = XtCreateManagedWidget
    ("scale_cancel", commandWidgetClass, widgets->scale_box, arg, 1);
  XtAddCallback (widgets->scale_x, XtNcallback, scale_x_cb, widgets);
  XtAddCallback (widgets->scale_y, XtNcallback, scale_y_cb, widgets);
  XtAddCallback (widgets->scale_u, XtNcallback, scale_u_cb, widgets);
  XtAddCallback (widgets->scale_cancel, XtNcallback, popup_cancel_cb, widgets);


  /* create file popup */
  widgets->file_pshell = XtCreatePopupShell 
    ("file_pshell", transientShellWidgetClass, widgets->toplevel, NULL, 0);
  /* End Hay */

  /* Added and/or Modified by Hay */
  widgets->file_box = XtCreateManagedWidget 
    ("file_box", boxWidgetClass, widgets->file_pshell, NULL, 0);
  widgets->name_file = XtCreateManagedWidget 
    ("name_file", labelWidgetClass, widgets->file_box, NULL, 0);
  widgets->save = XtCreateManagedWidget 
    ("save", commandWidgetClass, widgets->file_box, NULL, 0);
  widgets->read = XtCreateManagedWidget 
    ("read", commandWidgetClass, widgets->file_box, NULL, 0);

  widgets->xpn2ps = XtCreateManagedWidget
    ("xpn2ps", commandWidgetClass, widgets->file_box, NULL, 0);
  widgets->psprn = XtCreateManagedWidget
    ("psprn", commandWidgetClass, widgets->file_box, NULL, 0);
  XtSetArg (arg[0], XtNlabel, "Cancel");
  widgets->file_cancel = XtCreateManagedWidget
    ("file_cancel", commandWidgetClass, widgets->file_box, arg, 1);
  /* End Hay */

  XtAddCallback (widgets->save, XtNcallback, save_cb, widgets);
  XtAddCallback (widgets->read, XtNcallback, read_cb, widgets);


  /* Added By Hay */
  XtAddCallback (widgets->xpn2ps, XtNcallback, xpn2ps_cb, widgets);
  XtAddCallback (widgets->psprn, XtNcallback, psprn_cb, widgets);
  XtAddCallback (widgets->file_cancel, XtNcallback, popup_cancel_cb, widgets);
  /* End Hay */

  /* create name enter popup */  
  widgets->name_pshell = XtCreatePopupShell
    ("name_pshell", transientShellWidgetClass, widgets->toplevel, NULL, 0);
  XtSetArg (arg[0], XtNvalue, "");
  widgets->name_dialog = XtCreateManagedWidget
    ("name_dialog", dialogWidgetClass, widgets->name_pshell, arg, 1);
  XtSetArg (arg[0], XtNlabel, "ok");
  widgets->name_ok = XtCreateManagedWidget
    ("name_ok", commandWidgetClass, widgets->name_dialog, arg, 1);
  XtSetArg (arg[0], XtNlabel, "cancel operation");
  widgets->name_cancel = XtCreateManagedWidget
    ("name_cancel", commandWidgetClass, widgets->name_dialog, arg, 1);
  XtAddCallback (widgets->name_ok, XtNcallback, name_ok_cb, widgets);
  XtAddCallback (widgets->name_cancel, XtNcallback, popup_cancel_cb, widgets);

  /* deal with translating a return key into acceptance of name */
  XtAddActions (name_actions, XtNumber (name_actions));
  XtOverrideTranslations (XtNameToWidget (widgets->name_dialog, "*value"),
			  XtParseTranslationTable (name_translations));

}
