(EVAL-WHEN (LOAD EVAL COMPILE)
	   (CHK-BASE-AND-PACKAGE 10 *PACKAGE*))

;   In order to speed up theorem-prover output, this pretty-printer is
;   based around PRINC rather than PRIN1 because in Zetalisp, PRIN1
;   has to spend time thinking about whether to add a package prefix.

(DEFUN PPRIND (FMLA LEFTMARGIN RPARCNT PPR-MACRO-LST PPRFILE)
  (PROG (MARG2 PPR-MACRO-MEMO STARTLIST)
	(SETQ MARG2 (OUR-LINEL PPRFILE))
	(COND
	 ((ATOM FMLA)
	  (IPRINC FMLA PPRFILE)
	  (RETURN NIL)))
        (SETQ POS (COND ((SETQ TEMP-TEMP (ASSOC-EQ PPRFILE IPOSITION-ALIST))
			 (CDR TEMP-TEMP))
			(T 0)))
	(SETQ SPACELEFT (- MARG2 LEFTMARGIN))
	(PPR1 FMLA (1+ RPARCNT))
	(SETQ NEXTNODE (CDAR STARTLIST))
	(SETQ NEXTIND (CAAR STARTLIST))
	(SETQ PPR-MACRO-MEMO (NREVERSE PPR-MACRO-MEMO))
	(SETQ NEXT-MEMO-KEY (CAAR PPR-MACRO-MEMO))
	(SETQ NEXT-MEMO-VAL (CDAR PPR-MACRO-MEMO))
	(PPR2 FMLA LEFTMARGIN RPARCNT)
        (IPOSITION PPRFILE POS NIL)
	(RETURN NIL)))

(DEFUN PPRPACK NIL
  (CONS (COND ((< MINREM DLHDFMLA) (SETQ REMAINDER 0) (- (1+ MINREM)))
	      (T (SETQ REMAINDER (- MINREM DLHDFMLA)) (1+ DLHDFMLA)))
	FMLA))

(DEFUN PPR1 (FMLA RPARCNT)
  (LET (DLHDFMLA RUNFLAT MINREM L RUNSTART RUNEND
		 (PPR-MACRO-LST PPR-MACRO-LST))
    (PROG NIL
	  (COND
	   ((ATOM FMLA)
	    (SETQ FLATSIZE (+ RPARCNT
			      (OUR-FLATC FMLA)))
	    (SETQ REMAINDER (- SPACELEFT FLATSIZE))
	    (RETURN NIL)))
	  (COND
	   ((ATOM (CAR FMLA))
	    (COND
	     ((SETQ TEMP1 (ASSOC-EQ (CAR FMLA) PPR-MACRO-LST))
	      (SETQ TEMP1 (FUNCALL (CDR TEMP1) FMLA))
	      (SETQ PPR-MACRO-MEMO (CONS (CONS FMLA TEMP1) PPR-MACRO-MEMO))
	      (COND
	       ((ATOM TEMP1)
		(SETQ FLATSIZE (+ RPARCNT
				  (OUR-FLATC TEMP1)))
		(SETQ REMAINDER (- SPACELEFT FLATSIZE))
		(RETURN NIL))
	       (T (SETQ FMLA TEMP1)))))
	    (COND ((AND (EQ (QUOTE QUOTE) (CAR FMLA))
			(NOT (ATOM (CDR FMLA)))
			(NULL (CDDR FMLA)))
		   (PPR1 (CADR FMLA) RPARCNT)
		   (AND FLATSIZE (SETQ FLATSIZE (1+ FLATSIZE)))
		   (SETQ REMAINDER (1- REMAINDER))
		   (RETURN NIL)))
	    (SETQ DLHDFMLA (1+ (OUR-FLATC (CAR FMLA))))
	    (SETQ L FMLA))
	   (T (SETQ DLHDFMLA 0)
	      (SETQ L (RPLACD NILCONS FMLA))
	      (GO OVER)))
	  (COND
	   ((NULL (CDR FMLA))
	    (SETQ FLATSIZE (+ RPARCNT DLHDFMLA))
	    (SETQ REMAINDER (- SPACELEFT FLATSIZE))
	    (RETURN NIL)))
	  OVER
	  (SETQ RUNFLAT DLHDFMLA)
	  (SETQ MINREM 1000)
	  (SETQ SPACELEFT (1- SPACELEFT))
	  LOOPFLAT
	  (SETQ L (CDR L))
	  (COND
	   ((NULL L)
	    (SETQ SPACELEFT (1+ SPACELEFT))
	    (COND
	     ((AND (NOT (> RUNFLAT SPACELEFT)) (NOT (> RUNFLAT FORCEIN)))
	      (SETQ FLATSIZE RUNFLAT)
	      (SETQ REMAINDER (- SPACELEFT RUNFLAT)))
	     (T (SETQ STARTLIST (CONS (PPRPACK) NIL))
		(SETQ ENDLIST STARTLIST)
		(SETQ FLATSIZE NIL)))
	    (RETURN NIL)))
	  (COND
	   ((ATOM L)
	    (RPLACA (CDR DOTCONS) L)
	    (SETQ L DOTCONS)))
	  (COND
	   ((ATOM (CAR L))
	    (SETQ TEMP1 (OUR-FLATC (CAR L)))
	    (SETQ RUNFLAT (+ TEMP1 (1+ RUNFLAT)))
	    (SETQ TEMP1 (- SPACELEFT TEMP1))
	    (COND
	     ((NULL (CDR L))
	      (SETQ RUNFLAT (+ RPARCNT RUNFLAT))
	      (SETQ TEMP1 (- TEMP1 RPARCNT))))
	    (COND
	     ((< TEMP1 MINREM)
	      (SETQ MINREM TEMP1)))
	    (GO LOOPFLAT))
	   (T (PPR1 (CAR L)
		    (COND
		     ((NULL (CDR L)) (1+ RPARCNT))
		     (T 1)))
	      (COND
	       ((< REMAINDER MINREM) (SETQ MINREM REMAINDER)))
	      (COND
	       (FLATSIZE (SETQ RUNFLAT (+ FLATSIZE (1+ RUNFLAT)))
			 (GO LOOPFLAT)))))
	  (SETQ RUNSTART STARTLIST)
	  (SETQ RUNEND ENDLIST)
	  LOOPIND
	  (SETQ L (CDR L))
	  (COND
	   ((NULL L)
	    (SETQ STARTLIST (CONS (PPRPACK) RUNSTART))
	    (SETQ ENDLIST RUNEND)
	    (SETQ FLATSIZE NIL)
	    (SETQ SPACELEFT (1+ SPACELEFT))
	    (RETURN NIL)))
	  (COND
	   ((ATOM L)
	    (RPLACA (CDR DOTCONS) L)
	    (SETQ L DOTCONS)))
	  (COND
	   ((ATOM (CAR L))
	    (SETQ TEMP1 (- SPACELEFT (OUR-FLATC (CAR L))))
	    (COND
	     ((NULL (CDR L)) (SETQ TEMP1 (- TEMP1 RPARCNT))))
	    (COND
	     ((< TEMP1 MINREM) (SETQ MINREM TEMP1)))
	    (GO LOOPIND)))
	  (PPR1 (CAR L)
		(COND
		 ((NULL (CDR L)) (1+ RPARCNT))
		 (T 1)))
	  (COND
	   ((< REMAINDER MINREM) (SETQ MINREM REMAINDER)))
	  (COND
	   (FLATSIZE)
	   (T (RPLACD RUNEND STARTLIST) (SETQ RUNEND ENDLIST)))
	  (GO LOOPIND))))

(DEFUN PPR2 (FMLA MARG1 RPARCNT)
  (PROG (NONLFLAG TEMP)
	(COND
	 ((ATOM FMLA)
	  (PRIND FMLA PPRFILE)
	  (RETURN NIL)))
	(COND
	 ((EQ FMLA NEXT-MEMO-KEY)
	  (SETQ FMLA NEXT-MEMO-VAL)
	  (SETQ PPR-MACRO-MEMO (CDR PPR-MACRO-MEMO))
	  (SETQ NEXT-MEMO-KEY (CAAR PPR-MACRO-MEMO))
	  (SETQ NEXT-MEMO-VAL (CDAR PPR-MACRO-MEMO))
	  (COND
	   ((ATOM FMLA)
	    (PRIND FMLA PPRFILE)
	    (RETURN NIL)))))
	(COND ((AND (EQ (CAR FMLA) (QUOTE QUOTE))
		    (NOT (ATOM (CDR FMLA)))
		    (NULL (CDDR FMLA)))
	       (WRITE-CHAR1 #\' PPRFILE)
	       (PPR2 (CADR FMLA) (1+ MARG1) RPARCNT)
	       (RETURN NIL)))
	(COND
	 ((EQ FMLA NEXTNODE)
	  (SETQ MARG1 (+ MARG1 (ABS NEXTIND)))
	  (SETQ NONLFLAG (> NEXTIND 0))
	  (SETQ STARTLIST (CDR STARTLIST))
	  (COND
	   ((NULL STARTLIST))
	   (T (SETQ NEXTNODE (CDAR STARTLIST))
	      (SETQ NEXTIND (CAAR STARTLIST)))))
	 (T (PPR22 FMLA)
	    (RETURN NIL)))
	(WRITE-CHAR1 #\( PPRFILE)
	(COND
	 ((ATOM (CAR FMLA))
	  (PRIND (CAR FMLA) PPRFILE)
	  (COND
	   ((NULL (CDR FMLA))
	    (WRITE-CHAR1 #\) PPRFILE)
	    (RETURN NIL)))
	  (COND
	   ((AND (CONSP (CDR FMLA))
		 (OR (ATOM (SETQ TEMP (CADR FMLA)))
		     (AND (NOT (EQ (CADR FMLA) NEXTNODE))
			  (PROGN (COND ((EQ FMLA NEXT-MEMO-KEY)
					(SETQ TEMP NEXT-MEMO-VAL)))
				 (OR (ATOM TEMP)
				     (AND (EQ (CAR TEMP) (QUOTE QUOTE))
					  (NOT (ATOM (CDR TEMP)))
					  (ATOM (CADR TEMP))
					  (NULL (CDDR TEMP)))))))
		 (< (+ POS (OUR-FLATC TEMP) RPARCNT)
		    MARG2))
	    (WRITE-CHAR1 #\SPACE PPRFILE)
	    (PPR2 (CADR FMLA) MARG1 RPARCNT)
	    (SETQ FMLA (CDR FMLA))
	    (GO LOOP1))
	   (NONLFLAG (WRITE-CHAR1 #\SPACE PPRFILE))
	   (T (TERPRISPACES MARG1 PPRFILE)))
	  (SETQ FMLA (CDR FMLA))))
	LOOP(COND
	     ((ATOM FMLA)
	      (WRITE-CHAR1 #\. PPRFILE)
	      (WRITE-CHAR1 #\SPACE PPRFILE)
	      (PRIND FMLA PPRFILE)
	      (WRITE-CHAR1 #\) PPRFILE)
	      (RETURN NIL)))
	(PPR2 (CAR FMLA)
	      MARG1
	      (COND
	       ((NULL (CDR FMLA))
		(1+ RPARCNT))
	       (T 1)))
	LOOP1
	(COND
	 ((NULL (CDR FMLA))
	  (WRITE-CHAR1 #\) PPRFILE)
	  (RETURN NIL)))
	(COND
	 ((AND (ATOM (CAR FMLA))
	       (CONSP (CDR FMLA))
	       (OR (ATOM (SETQ TEMP (CADR FMLA)))
		   (AND (NOT (EQ TEMP NEXTNODE))
			(PROGN (COND ((EQ FMLA NEXT-MEMO-KEY)
				      (SETQ TEMP NEXT-MEMO-VAL)))
			       (OR (ATOM TEMP)
				   (AND (EQ (CAR TEMP) (QUOTE QUOTE))
					(NOT (ATOM (CDR TEMP)))
					(ATOM (CADR TEMP))
					(NULL (CDDR TEMP)))))))
	       (< (+ POS (OUR-FLATC TEMP) RPARCNT)
		  MARG2))
	  (WRITE-CHAR1 #\SPACE PPRFILE)
	  (PPR2 (CADR FMLA) MARG2 RPARCNT)
	  (SETQ FMLA (CDR FMLA))
	  (GO LOOP1)))
	(TERPRISPACES MARG1 PPRFILE)
	(SETQ FMLA (CDR FMLA))
	(GO LOOP)))

(DEFUN PPR22 (X)
  (COND
   ((ATOM X) (PRIND X PPRFILE))
   (T (WRITE-CHAR1 #\( PPRFILE)
      (PROG NIL
	    LOOP (COND
		  ((ATOM X)
		   (COND
		    ((NULL X) (WRITE-CHAR1 #\) PPRFILE))
		    (T (WRITE-CHAR1 #\. PPRFILE)
		       (WRITE-CHAR1 #\SPACE PPRFILE)
		       (PRIND X PPRFILE)
		       (WRITE-CHAR1 #\) PPRFILE)))
		   (RETURN NIL))
		  (T (PPR2 (CAR X) MARG2 0)
		     (SETQ X (CDR X))
		     (COND
		      ((NULL X))
		      (T (WRITE-CHAR1 #\SPACE PPRFILE)))
		     (GO LOOP)))))))

(DEFUN TERPRISPACES (N FILE)
  (TERPRI FILE)
  (ITERATE FOR I FROM 1 TO N DO (WRITE-CHAR #\Space FILE))
  (SETQ POS N))

