;;; -*- Mode: LISP; Syntax: Common-lisp -*-

(defun compress (ll)
  (if ll
      (let ((ff (first (first ll)))
	    (ss (first (second ll))))
	(if (string= ff ss)
	    (compress (cons (list ff (append (second (first ll)) (second (second ll))))
			    (rest (rest ll))))
	    (cons (first ll) (compress (rest ll)))))
      ll))

(defun compare (s1 s2)
  (when (and (> (length s1) 5) (string= (subseq s1 0 5) "{\\sc "))
    (setq s1 (subseq s1 5)))
  (when (and (> (length s2) 5) (string= (subseq s2 0 5) "{\\sc "))
    (setq s2 (subseq s2 5)))
  (string-lessp s1 s2))

(defun ind-create (&optional (from "js-sfbsun:/home/mkrp/manual/rahmen.idx")
		   (to "js-sfbsun:/home/mkrp/manual/index.tex"))
  (let ((list nil))
    (with-open-file (fst from)
      (do ((entry (read-line fst nil :end) (read-line fst nil :end)))
	  ((eq entry :end) t)
	(unless (eq :end entry)
	  (let ((posclose1 (1- (position #\{ entry :from-end t))))
	    (push (list (subseq entry 12 posclose1)
			(list (parse-integer entry :start (+ 2 posclose1) :junk-allowed t)))
		  list)))))
    (setq list (sort list #'compare :key #'first))
    (setq list (compress list))
    (with-open-file (tst to :direction :output)
      (format tst "\\begin{theindex}~%{\\small ")
      (mapc #'(lambda (item)
		(let ((ss (nreverse (second item))))
		  (format tst "\\item ~A\\hfill ~A~{, ~A~}~%" (first item) (first ss) (rest ss))))
	    list)
      (format tst "}\\end{theindex}~%"))
    nil))