;;; -*- Mode: LISP; Package: MKRP; Syntax: Common-lisp -*-
(* PROBLEM E95)
(*)
(* DECLARATIONS:)
(TYPE A:PERSON)
(*)
(* FUNCTIONS:)
(TYPE KNIGHT (PERSON) : STATEMENT)
(TYPE
KNAVE (PERSON) : STATEMENT)
(TYPE RICH (PERSON) :STATEMENT)
(TYPE POOR (PERSON) :STATEMENT)
(TYPE NOT1 (STATEMENT) :STATEMENT)
(TYPE AND2 (STATEMENT STATEMENT) :STATEMENT)
(TYPE OR2 (STATEMENT STATEMENT) :STATEMENT)
(*)
(* PREDICATES:)
(TYPE CORRECT (STATEMENT))
(TYPE SAYS (PERSON STATEMENT))
(*)
(* EXPLANATIONS:)
(ASSOCIATIVE (AND2))
(ASSOCIATIVE (OR2))
(ALL S: STATEMENT CORRECT (NOT1 (S)) EQV NOT CORRECT (S))
(ALL S,T: STATEMENT CORRECT (AND2 (S T)) EQV CORRECT (S) AND CORRECT (T))
(ALL S,T: STATEMENT CORRECT (OR2 (S T)) EQV CORRECT (S) OR CORRECT
(T))
(*)
(* IMPLICATIONS:)
(ALL S: STATEMENT ALL P:PERSON SAYS (P S) AND CORRECT (KNIGHT (P)) IMPL CORRECT
(S))
(ALL S: STATEMENT ALL P:PERSON SAYS (P S) AND CORRECT (KNAVE (P)) IMPL NOT CORRECT (S))
(*)
(* EVERY PERSON IS EITHER A KNIGHT OR A KNAVE:)
(ALL P:PERSON CORRECT (KNIGHT (P)) EQV NOT (CORRECT (KNAVE (P))))
(*)
(* EVERY PERSON IS EITHER RICH OR POOR:)
(ALL P:PERSON CORRECT (RICH (P)) EQV NOT (CORRECT (POOR (P))))

(* THEOREM FOR E95)
(EX S:STATEMENT SAYS (A S) IMPL CORRECT (RICH (A)) AND CORRECT (KNAVE (A)))