;;; -* Package: MKRP; Base:10.; Syntax: Common-lisp; Mode: LISP -*-
(* PROBLEM E90.)
(*)
(* IN THIS AND THE NEXT TWO PROBLEMS THERE ARE AGAIN THREE INHABITANTS)
(* A,B,C, EACH OF WHOM IS EITHER A KNIGHT OR A KNAVE. HOWEVER ONLY TWO)
(* OF THEM, A, B, MAKE STATEMENTS. BUT IN THESE STATEMENTS, THE WORD US)
(* REFERS TO THE THREE PEOPLE A,B,C  NOT TO JUST A AND B. SUPPOSE A,B MAKE)
(* THE FOLLOWING STATEMENTS:)
(* A: AT LEAST ONE OF THE THREE OF US IS A KNIGHT.)
(* B: AT LEAST ONE OF THE THREE OF US IS A KNAVE.)
(* GIVEN THAT AT LEAST ONE OF THEM IS A WEREWOLF, AND THAT NONE OF THEM)
(* IS BOTH A KNIGHT AND A WEREWOLF, WHICH ONE ARE WEREWOLVES?)
(*)
(* WE DEFINE THE FOLLOWING PREDICATES:)
(*)
(* KNIGHT (X) -- MEANS THAT X IS A KNIGHT.)
(* KNAVE (X) -- MEANS THAT X IS A KNAVE.)
(* WEREWOLF (X) -- MEANS THAT X IS A WEREWOLF.)
(* TRUTH (X) -- MEANS THAT THE STATEMENT X IS TRUE.)
(* EXIST-KNIGHT (X Y Z) -- MEANS THAT AT LEAST ONE OF X,Y,Z IS A KNIGHT.)
(* EXIST-KNAVE (X Y Z) -- MEANS THAT AT LEAST ONE OF X,Y,Z IS A KNAVE.)
(* ST-EXIST-KNIGHT (U V W X) -- THE STATEMENT U MEANS THAT AT LEAST ONE OF V,W,X IS A KNIGHT.)
(*)
(* ST-EXIST-KNAVE (U V W X) -- THE STATEMENT U MEANS THAT AT LEAST)
(* ONE OF V,W,X IS A KNAVE.)
(*)
(* WE DEFINE THE FOLLOWING FUNCTION:)
(*)
(* STATE (X) -- ASSIGNS EACH PERSON A STATEMENT.)
(*)
(TYPE A,B,C:PERSON)
(TYPE KNAVE (PERSON))
(TYPE KNIGHT (PERSON))
(TYPE WEREWOLF (PERSON))
(TYPE TRUTH (STMT))
(TYPE EXIST-KNIGHT (PERSON PERSON PERSON))
(TYPE EXIST-KNAVE (PERSON PERSON PERSON))
(TYPE ST-EXIST-KNIGHT (STMT PERSON PERSON PERSON))
(TYPE ST-EXIST-KNAVE (STMT PERSON PERSON PERSON))
(TYPE STATE (PERSON) :STMT)
(*)
(* EVERY INHABITANT IS EITHER A KNIGHT OR A KNAVE:)
(ALL X:PERSON KNIGHT (X) OR KNAVE (X))
(ALL X:PERSON NOT (KNIGHT (X) AND KNAVE (X)))
(*)
(* KNIGHTS ALWAYS TELL THE TRUTH AND KNAVES ALWAYS LIE:)
(ALL X:PERSON (KNIGHT (X) IMPL TRUTH (STATE (X))) AND (TRUTH (STATE (X)) IMPL KNIGHT (X)))
(ALL X:PERSON (KNAVE (X) IMPL NOT TRUTH (STATE (X))) AND (NOT TRUTH (STATE (X)) IMPL KNAVE (X))) 
(*)
(* AT LEAST ONE OF THEM IS A WEREWOLF:)
(WEREWOLF (A) OR WEREWOLF (B) OR WEREWOLF (C))
(*)
(* NONE OF THEM IS BOTH A KNIGHT AND A WEREWOLF:)
(ALL X:PERSON NOT (KNIGHT (X) AND WEREWOLF (X)))
(*)
(* EQUIVALENCES:)
(ALL X,Y,Z:PERSON (EXIST-KNIGHT (X Y Z) IMPL KNIGHT (X) OR KNIGHT (Y) OR KNIGHT (Z)) AND
                  (KNIGHT (X) OR KNIGHT (Y) OR KNIGHT (Z) IMPL EXIST-KNIGHT (X Y Z)))
(ALL X,Y,Z:PERSON (EXIST-KNAVE (X Y Z) IMPL KNAVE (X) OR KNAVE (Y) OR KNAVE (Z)) AND
                  (KNAVE (X) OR KNAVE (Y) OR KNAVE (Z) IMPL EXIST-KNAVE (X Y Z)))
(*)
(* IMPLICATIONS ABOUT STATEMENTS:)
(ALL U:STMT ALL V,W,X:PERSON ST-EXIST-KNIGHT (U V W X) AND TRUTH (U) IMPL EXIST-KNIGHT (V W X))
(ALL U:STMT ALL V,W,X:PERSON ST-EXIST-KNIGHT (U V W X) AND NOT TRUTH (U) IMPL NOT EXIST-KNIGHT (V W X))
(ALL U:STMT ALL V,W,X:PERSON ST-EXIST-KNAVE (U V W X) AND TRUTH (U) IMPL EXIST-KNAVE (V W X))
(ALL U:STMT ALL V,W,X:PERSON ST-EXIST-KNAVE (U V W X) AND NOT TRUTH (U) IMPL NOT EXIST-KNAVE (V W X))
(*)
(* ACTUAL STATEMENTS:)
(ST-EXIST-KNIGHT (STATE (A) A B C))
(ST-EXIST-KNAVE (STATE (B) A B C))

(* THEOREM:)
(WEREWOLF (C))
