;;; -*- Mode: LISP; Package: MKRP; Syntax: Common-lisp -*-
(* IN SHAKESPEARE^S MERCHANT OF VENICE PORTIA HAD THREE CASKETS)
(* HE WAS LUCKY ENOUGH (OR WISE ENOUGH) TO CHOOSE THE ONE WITH)
(* THE PORTRAIT, THEN HE COULD CLAIM PORTIA AS HIS BRIDE.)
(* ON THE LID OF EACH CASKET WAS AN INSCRIPTION TO HELP THE SUITOR)
(* CHOOSE WISELY.)
(* NOW SUPPOSE PORTIA WANTED TO CHOOSE HER HUSBAND NOT ON THE BASIS)
(* OF VIRTUE, BUT SIMPLY ON THE BASIS OF INTELLIGENCE. SHE HAD THE)
(* FOLLOWING INSCRIPTIONS
PUT ON THE CASKETS:)
(*)
(* GOLD : THE PORTRAIT IS IN THIS CASKET.)
(* SILVER : THE PORTRAIT IS NOT IN THIS CASKET.)
(* LEAD : THE PORTRAIT IS NOT IN THE GOLD CASKET.)
(*)
(* PORTIA EXPLAINED TO THE SUITOR THAT OF THE THREE STATEMENTS AT)
(* MOST ONE WAS TRUE.)
(* WHICH CASKET SHOULD THE SUITOR CHOOSE ?)
(*)
(* WE DEFINE THE FOLLOWING PREDICATES:)
(* PORTRAIT (X) --- THE PORTRAIT IS IN CASKET X)
(* TRUTH (X) --- THE INSCRIPTION X IS TRUE)
(* INSCR.PORTRAIT (X Y) --- THE INSCRIPTION X TELLS THAT)
(* THE PORTRAIT IS IN CASKET Y)
(* NEG.INSCR.PORTRAIT (X Y) --- THE INSCRIPTION X TELLS THAT)
(* THE PORTRAIT IS NOT IN CASKET Y)
(*)
(* DECLARATIONS:)
(TYPE GOLD,SILVER,LEAD:CASKET)
(TYPE INSCRIPTION (CASKET) : INSCRIPT)
(TYPE PORTRAIT (CASKET))
(TYPE TRUTH (INSCRIPT))
(TYPE INSCR.PORTRAIT (INSCRIPT CASKET))
(TYPE NEG.INSCR.PORTRAIT (INSCRIPT CASKET))
(*)
(* THEN THE FOLLOWING PROPOSITIONS HOLD.)
(*)
(* THERE IS EXACTLY ONE PORTRAIT:)
(PORTRAIT (GOLD) OR PORTRAIT
(SILVER) OR PORTRAIT (LEAD))
(NOT (PORTRAIT (GOLD) AND PORTRAIT (SILVER) OR PORTRAIT (SILVER) AND PORTRAIT (LEAD) OR PORTRAIT (LEAD) AND PORTRAIT (GOLD)))
(*)
(* AT MOST ONE INSCRIPTION TELLS THE TRUTH:)
(NOT (TRUTH (INSCRIPTION
(GOLD)) AND TRUTH (INSCRIPTION (SILVER)) OR TRUTH (INSCRIPTION (SILVER)) AND TRUTH (INSCRIPTION (LEAD)) OR TRUTH (INSCRIPTION (LEAD)) AND TRUTH (INSCRIPTION (GOLD))))
(*)
(* IMPLICATIONS TO BE DRAWN FROM INSCRIPTION:)
(ALL X:INSCRIPT ALL Y:CASKET INSCR.PORTRAIT (X Y) AND TRUTH
(X) IMPL PORTRAIT (Y))
(ALL X:INSCRIPT ALL Y:CASKET INSCR.PORTRAIT (X Y) AND NOT TRUTH (X) IMPL NOT PORTRAIT (Y))
(ALL X:INSCRIPT ALL Y:CASKET NEG.INSCR.PORTRAIT (X Y) AND TRUTH (X) IMPL NOT PORTRAIT (Y))
(ALL X:INSCRIPT ALL Y:CASKET NEG.INSCR.PORTRAIT (X Y) AND NOT TRUTH (X) IMPL PORTRAIT (Y))
(*)
(* ACTUAL INSCRIPTIONS:)
(INSCR.PORTRAIT (INSCRIPTION (GOLD) GOLD))
(NEG.INSCR.PORTRAIT (INSCRIPTION (SILVER) SILVER))
(NEG.INSCR.PORTRAIT (INSCRIPTION
(LEAD) GOLD))

(* THEOREMS FOR THE FIRST PORTIA PROBLEM (SM.E67A))
(*)
(PORTRAIT (SILVER))