(*  Title: 	HOL/subset
    ID:         $Id: subset.ML,v 1.1 1993/09/16 10:21:12 clasohm Exp $
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1991  University of Cambridge

Derived rules involving subsets
Union and Intersection as lattice operations
*)

(*** insert ***)

val subset_insertI = prove_goal Set.thy "B <= insert(a,B)"
 (fn _=> [ (rtac subsetI 1), (etac insertI2 1) ]);

(*Useful for rewriting!*)
goalw Set.thy [subset_def,Ball_def] "insert(a,B)<=C = (a:C & B<=C)";
(*by(SIMP_TAC (HOL_ss addsimps [insert_iff]) 1);*)
by(simp_tac (HOL_ss addsimps [insert_iff]) 1);
by(fast_tac HOL_cs 1);
val insert_subset_iff = result();

(*** Big Union -- least upper bound of a set  ***)

val prems = goal Set.thy
    "B:A ==> B <= Union(A)";
by (REPEAT (ares_tac (prems@[subsetI,UnionI]) 1));
val Union_upper = result();

val [prem] = goal Set.thy
    "[| !!X. X:A ==> X<=C |] ==> Union(A) <= C";
br subsetI 1;
by (REPEAT (eresolve_tac [asm_rl, UnionE, prem RS subsetD] 1));
val Union_least = result();

(** General union **)

val prems = goal Set.thy
    "a:A ==> B(a) <= (UN x:A. B(x))";
by (REPEAT (ares_tac (prems@[UN_I RS subsetI]) 1));
val UN_upper = result();

val [prem] = goal Set.thy
    "[| !!x. x:A ==> B(x)<=C |] ==> (UN x:A. B(x)) <= C";
br subsetI 1;
by (REPEAT (eresolve_tac [asm_rl, UN_E, prem RS subsetD] 1));
val UN_least = result();

goal Set.thy "B(a) <= (UN x. B(x))";
by (REPEAT (ares_tac [UN1_I RS subsetI] 1));
val UN1_upper = result();

val [prem] = goal Set.thy "[| !!x. B(x)<=C |] ==> (UN x. B(x)) <= C";
br subsetI 1;
by (REPEAT (eresolve_tac [asm_rl, UN1_E, prem RS subsetD] 1));
val UN1_least = result();


(*** Big Intersection -- greatest lower bound of a set ***)

val prems = goal Set.thy "B:A ==> Inter(A) <= B";
br subsetI 1;
by (REPEAT (resolve_tac prems 1 ORELSE etac InterD 1));
val Inter_lower = result();

val [prem] = goal Set.thy
    "[| !!X. X:A ==> C<=X |] ==> C <= Inter(A)";
br (InterI RS subsetI) 1;
by (REPEAT (eresolve_tac [asm_rl, prem RS subsetD] 1));
val Inter_greatest = result();

val prems = goal Set.thy "a:A ==> (INT x:A. B(x)) <= B(a)";
br subsetI 1;
by (REPEAT (resolve_tac prems 1 ORELSE etac INT_D 1));
val INT_lower = result();

val [prem] = goal Set.thy
    "[| !!x. x:A ==> C<=B(x) |] ==> C <= (INT x:A. B(x))";
br (INT_I RS subsetI) 1;
by (REPEAT (eresolve_tac [asm_rl, prem RS subsetD] 1));
val INT_greatest = result();

goal Set.thy "(INT x. B(x)) <= B(a)";
br subsetI 1;
by (REPEAT (resolve_tac prems 1 ORELSE etac INT1_D 1));
val INT1_lower = result();

val [prem] = goal Set.thy
    "[| !!x. C<=B(x) |] ==> C <= (INT x. B(x))";
br (INT1_I RS subsetI) 1;
by (REPEAT (eresolve_tac [asm_rl, prem RS subsetD] 1));
val INT1_greatest = result();

(*** Finite Union -- the least upper bound of 2 sets ***)

goal Set.thy "A <= A Un B";
by (REPEAT (ares_tac [subsetI,UnI1] 1));
val Un_upper1 = result();

goal Set.thy "B <= A Un B";
by (REPEAT (ares_tac [subsetI,UnI2] 1));
val Un_upper2 = result();

val prems = goal Set.thy "[| A<=C;  B<=C |] ==> A Un B <= C";
by (cut_facts_tac prems 1);
by (DEPTH_SOLVE (ares_tac [subsetI] 1 
          ORELSE eresolve_tac [UnE,subsetD] 1));
val Un_least = result();

(*** Finite Intersection -- the greatest lower bound of 2 sets *)

goal Set.thy "A Int B <= A";
by (REPEAT (ares_tac [subsetI] 1 ORELSE etac IntE 1));
val Int_lower1 = result();

goal Set.thy "A Int B <= B";
by (REPEAT (ares_tac [subsetI] 1 ORELSE etac IntE 1));
val Int_lower2 = result();

val prems = goal Set.thy "[| C<=A;  C<=B |] ==> C <= A Int B";
by (cut_facts_tac prems 1);
by (REPEAT (ares_tac [subsetI,IntI] 1
     ORELSE etac subsetD 1));
val Int_greatest = result();

(*** Set difference ***)

val Diff_subset = prove_goal Set.thy "A-B <= A::'a set"
 (fn _ => [ (REPEAT (ares_tac [subsetI] 1 ORELSE etac DiffE 1)) ]);

(*** Monotonicity ***)

val [prem] = goal Set.thy "mono(f) ==> f(A) Un f(B) <= f(A Un B)";
by (rtac Un_least 1);
by (rtac (Un_upper1 RS (prem RS monoD)) 1);
by (rtac (Un_upper2 RS (prem RS monoD)) 1);
val mono_Un = result();

val [prem] = goal Set.thy "mono(f) ==> f(A Int B) <= f(A) Int f(B)";
by (rtac Int_greatest 1);
by (rtac (Int_lower1 RS (prem RS monoD)) 1);
by (rtac (Int_lower2 RS (prem RS monoD)) 1);
val mono_Int = result();
