(*  Title: 	HOL/sexp
    ID:         $Id: sexp.thy,v 1.1 1993/09/16 10:21:15 clasohm Exp $
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1992  University of Cambridge

S-expressions, general binary trees for defining recursive data structures
*)

Sexp = Univ +
consts
  Sexp      :: "'a node set set"

  Sexp_case :: "['a node set, 'a=>'b, nat=>'b, 	\
\                ['a node set,'a node set]=>'b] => 'b"

  Sexp_rec  :: "['a node set, 'a=>'b, nat=>'b, 	\
\                ['a node set,'a node set,'b,'b]=>'b] => 'b"
  
  pred_Sexp :: "('a node set * 'a node set)set"

rules
  Sexp_def "Sexp == lfp(%Z. range(Leaf) Un range(Numb) Un Z<*>Z)"

  Sexp_case_def	
   "Sexp_case(M,c,d,e) == @ z. (? x.   M=Leaf(x) & z=c(x))  \
\                            | (? k.   M=Numb(k) & z=d(k))  \
\                            | (? N1 N2. M = N1 . N2  & z=e(N1,N2))"

  pred_Sexp_def
     "pred_Sexp == UN M: Sexp. UN N: Sexp. {<M, M.N>, <N, M.N>}"

  Sexp_rec_def
   "Sexp_rec(M,c,d,e) == wfrec(pred_Sexp, M,  \
\             %M g. Sexp_case(M, c, d, %N1 N2. e(N1, N2, g(N1), g(N2))))"
end

