(*  Title: 	HOL/llist
    ID:         $Id: llist.ML,v 1.3 1993/12/01 12:05:25 lcp Exp $
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1993  University of Cambridge

For llist.thy.  

SHOULD LListD_Fun_CONS_I, etc., be equations (for rewriting)?

TOO LONG!  needs splitting up
*)

open LList;

(** Simplification **)

val llist_simps = [case_Inl, case_Inr];
val llist_ss = univ_ss addsimps llist_simps
                       addcongs [split_weak_cong, case_weak_cong]
                       setloop (split_tac [expand_split, expand_case]);

(** the llist functional **)

val LList_unfold = rewrite_rule [List_Fun_def]
	 (List_Fun_mono RS (LList_def RS def_gfp_Tarski));

(*This justifies using LList in other recursive type definitions*)
goalw LList.thy [LList_def] "!!A B. A<=B ==> LList(A) <= LList(B)";
by (rtac gfp_mono 1);
by (etac List_Fun_mono2 1);
val LList_mono = result();

(*Elimination is case analysis, not induction.*)
val [major,prem1,prem2] = goalw LList.thy [NIL_def,CONS_def]
    "[| L : LList(A);  \
\       L=NIL ==> P; \
\       !!M N. [| M:A;  N: LList(A);  L=CONS(M,N) |] ==> P \
\    |] ==> P";
by (rtac (major RS (LList_unfold RS equalityD1 RS subsetD RS usumE)) 1);
by (etac uprodE 2);
by (rtac prem2 2);
by (rtac prem1 1);
by (REPEAT (ares_tac [refl] 1
     ORELSE eresolve_tac [singletonE,ssubst] 1));
val LListE = result();


(*** Type checking by co-induction, using List_Fun ***)

val prems = goalw LList.thy [LList_def]
    "[| M : X;  X <= List_Fun(A, X Un LList(A)) |] ==>  M : LList(A)";
by (REPEAT (resolve_tac (prems@[List_Fun_mono RS coinduct]) 1));
val LList_coinduct = result();

(** Rules to prove the 2nd premise of LList_coinduct **)

goalw LList.thy [List_Fun_def,NIL_def] "NIL: List_Fun(A,X)";
by (resolve_tac [singletonI RS usum_In0I] 1);
val List_Fun_NIL_I = result();

goalw LList.thy [List_Fun_def,CONS_def]
    "!!M N. [| M: A;  N: X |] ==> CONS(M,N) : List_Fun(A,X)";
by (REPEAT (ares_tac [uprodI RS usum_In1I] 1));
val List_Fun_CONS_I = result();

(*Utilise the "strong" part, i.e. gfp(f)*)
goalw LList.thy [LList_def]
    "!!M N. M: LList(A) ==> M : List_Fun(A, X Un LList(A))";
by (etac (List_Fun_mono RS gfp_fun_UnI2) 1);
val List_Fun_LList_I = result();

(*** LList_corec satisfies the desired recurion equation ***)

(*A continuity result?*)
goalw LList.thy [CONS_def] "CONS(M, UN x.f(x)) = (UN x. CONS(M, f(x)))";
by (simp_tac (univ_ss addsimps [In1_UN1, Scons_UN1_y]) 1);
val CONS_UN1 = result();

goal Prod.thy "split(p, %x y.UN z.f(x,y,z)) = (UN z. split(p, %x y.f(x,y,z)))";
by (simp_tac (pair_ss setloop (split_tac [expand_split])) 1);
val split_UN1 = result();

goal Sum.thy "case(s, f, %y. UN z.g(y,z)) = (UN z. case(s, f, %y. g(y,z)))";
by (simp_tac (sum_ss setloop (split_tac [expand_case])) 1);
val case2_UN1 = result();

val prems = goalw LList.thy [CONS_def]
    "[| M<=M';  N<=N' |] ==> CONS(M,N) <= CONS(M',N')";
by (REPEAT (resolve_tac ([In1_mono,Scons_mono]@prems) 1));
val CONS_mono = result();

val corec_fun_simps = [LList_corec_fun_def RS def_nat_rec_0,
		       LList_corec_fun_def RS def_nat_rec_Suc];
val corec_fun_ss = llist_ss addsimps corec_fun_simps;

(** The directions of the equality are proved separately **)

goalw LList.thy [LList_corec_def]
    "LList_corec(a,f) <= case(f(a), %u.NIL, \
\			   %v. split(v, %z w. CONS(z, LList_corec(w,f))))";
by (rtac UN1_least 1);
by (res_inst_tac [("n","k")] natE 1);
by (ALLGOALS (asm_simp_tac corec_fun_ss));
by (REPEAT (resolve_tac [allI, impI, subset_refl RS CONS_mono, UN1_upper] 1));
val LList_corec_subset1 = result();

goalw LList.thy [LList_corec_def]
    "case(f(a), %u.NIL, %v. split(v, %z w. CONS(z, LList_corec(w,f)))) <= \
\    LList_corec(a,f)";
by (simp_tac (corec_fun_ss addsimps [CONS_UN1]) 1);
by (safe_tac set_cs);
by (ALLGOALS (res_inst_tac [("x","Suc(?k)")] UN1_I THEN' 
	      asm_simp_tac corec_fun_ss));
val LList_corec_subset2 = result();

(*the recursion equation for LList_corec -- NOT SUITABLE FOR REWRITING!*)
goal LList.thy
    "LList_corec(a,f) = case(f(a), %u. NIL, \
\			     %v. split(v, %z w. CONS(z, LList_corec(w,f))))";
by (REPEAT (resolve_tac [equalityI, LList_corec_subset1, 
			 LList_corec_subset2] 1));
val LList_corec = result();

(*definitional version of same*)
val [rew] = goal LList.thy
    "[| !!x. h(x) == LList_corec(x,f) |] ==>	\
\    h(a) = case(f(a), %u.NIL, %v. split(v, %z w. CONS(z, h(w))))";
by (rewtac rew);
by (rtac LList_corec 1);
val def_LList_corec = result();

(*A typical use of co-induction to show membership in the gfp. 
  Bisimulation is  range(%x. LList_corec(x,f)) *)
goal LList.thy "LList_corec(a,f) : LList({u.True})";
by (res_inst_tac [("X", "range(%x.LList_corec(x,?g))")] LList_coinduct 1);
by (rtac rangeI 1);
by (safe_tac set_cs);
by (stac LList_corec 1);
by (simp_tac (llist_ss addsimps [List_Fun_NIL_I,List_Fun_CONS_I,
                                 CollectI, range_eqI]) 1);
(* 6.7 vs 3.4 !!!
by (ASM_SIMP_TAC (llist_ss addsimps [List_Fun_NIL_I,List_Fun_CONS_I,
				    CollectI, rangeI]) 1);
*)
val LList_corec_type = result();

(*Lemma for the proof of llist_corec*)
goal LList.thy
    "LList_corec(a, %z. case(f(z),Inl,%x. split(x,%v w. Inr(<Leaf(v),w>)))) : \
\    LList(range(Leaf))";
by (res_inst_tac [("X", "range(%x.LList_corec(x,?g))")] LList_coinduct 1);
by (rtac rangeI 1);
by (safe_tac set_cs);
by (stac LList_corec 1);
(*nested "case"; requires an explicit split*)
by (res_inst_tac [("s", "f(xa)")] sumE 1);
by (asm_simp_tac (univ_ss addsimps (llist_simps@[List_Fun_NIL_I])) 1);
by (asm_simp_tac (univ_ss addsimps (llist_simps@[List_Fun_CONS_I, range_eqI])
                     setloop (split_tac [expand_split])) 1);
(* FIXME: can the selection of the case split be automated?
by (ASM_SIMP_TAC (llist_ss addsimps [List_Fun_CONS_I, rangeI]) 1);*)
val LList_corec_type2 = result();

(**** LList equality as a gfp; the bisimulation principle ****)

goalw LList.thy [LListD_Fun_def] "mono(LListD_Fun(r))";
by (REPEAT (ares_tac [monoI, subset_refl, dsum_mono, dprod_mono] 1));
val LListD_Fun_mono = result();

val LListD_unfold = rewrite_rule [LListD_Fun_def]
	 (LListD_Fun_mono RS (LListD_def RS def_gfp_Tarski));

goal LList.thy "!M N. <M,N> : LListD(diag(A)) --> ntrunc(k,M) = ntrunc(k,N)";
by (res_inst_tac [("n", "k")] less_induct 1);
by (safe_tac set_cs);
by (etac (LListD_unfold RS equalityD1 RS subsetD RS dsumE) 1);
by (safe_tac (set_cs addSEs [Pair_inject, dprodE, diagE]));
by (res_inst_tac [("n", "n")] natE 1);
by (asm_simp_tac (univ_ss addsimps [ntrunc_0]) 1);
by (res_inst_tac [("n", "xb")] natE 1);
by (asm_simp_tac (univ_ss addsimps [ntrunc_one_In1]) 1);
by (asm_simp_tac (univ_ss addsimps [ntrunc_In1, ntrunc_Scons]) 1);
val LListD_implies_ntrunc_equality = result();

goalw LList.thy [LList_def,List_Fun_def] "fst``LListD(diag(A)) <= LList(A)";
by (rtac gfp_upperbound 1);
by (res_inst_tac [("P", "%x. fst``x <= ?B")] (LListD_unfold RS ssubst) 1);
by (simp_tac fst_image_ss 1);
val fst_image_LListD = result();

(*This inclusion justifies the use of coinduction to show M=N*)
goal LList.thy "LListD(diag(A)) <= diag(LList(A))";
by (rtac subsetI 1);
by (res_inst_tac [("p","x")] PairE 1);
by (safe_tac HOL_cs);
by (res_inst_tac [("s","xa")] subst 1);
by (rtac (LListD_implies_ntrunc_equality RS spec RS spec RS mp RS 
	  ntrunc_equality) 1);
by (assume_tac 1);
by (rtac diagI 1);
by (etac (fst_imageI RS (fst_image_LListD RS subsetD)) 1);
val LListD_subset_diag = result();

(*This converse inclusion helps to strengthen LList_equalityI*)
goalw LList.thy [LListD_def] "diag(LList(A)) <= LListD(diag(A))";
by (rtac gfp_upperbound 1);
by (rtac subsetI 1);
by (etac diagE 1);
by (etac ssubst 1);
by (etac (LList_unfold RS equalityD1 RS subsetD RS usumE) 1);
by (rewtac LListD_Fun_def);
by (ALLGOALS (fast_tac (set_cs addIs [diagI,dsum_In0I,dsum_In1I,dprodI]
                               addSEs [uprodE])));
val diag_subset_LListD = result();

goal LList.thy "LListD(diag(A)) = diag(LList(A))";
by (REPEAT (resolve_tac [equalityI, LListD_subset_diag, 
			 diag_subset_LListD] 1));
val LListD_eq_diag = result();

(** To show two LLists are equal, exhibit a bisimulation! 
      [also admits true equality]
   Replace "A" by some particular set, like {x.True}??? *)
goal LList.thy 
    "!!r. [| <M,N> : r;  r <= LListD_Fun(diag(A), r Un diag(LList(A))) \
\         |] ==>  M=N";
by (rtac (rewrite_rule [LListD_def]
           (LListD_subset_diag RS subsetD RS diagE)) 1);
by (etac (LListD_Fun_mono RS coinduct) 1);
by (etac (rewrite_rule [LListD_def] LListD_eq_diag RS ssubst) 1);
by (safe_tac (set_cs addSEs [Pair_inject]));
val LList_equalityI = result();

(** Rules to prove the 2nd premise of LList_equalityI **)

goalw LList.thy [LListD_Fun_def,NIL_def] "<NIL,NIL> : LListD_Fun(r,s)";
by (rtac (singletonI RS diagI RS dsum_In0I) 1);
val LListD_Fun_NIL_I = result();

val prems = goalw LList.thy [LListD_Fun_def,CONS_def]
    "[| x:A;  <M,N>:s |] ==> <CONS(x,M), CONS(x,N)> : LListD_Fun(diag(A),s)";
by (rtac (dprodI RS dsum_In1I) 1);
by (REPEAT (resolve_tac (diagI::prems) 1));
val LListD_Fun_CONS_I = result();

(*Utilise the "strong" part, i.e. gfp(f)*)
goal LList.thy 
    "!!M N. M: LList(A) ==> <M,M> : LListD_Fun(diag(A), X Un diag(LList(A)))";
br (rewrite_rule [LListD_def] LListD_eq_diag RS subst) 1;
br (LListD_Fun_mono RS gfp_fun_UnI2) 1;
br (rewrite_rule [LListD_def] LListD_eq_diag RS ssubst) 1;
be diagI 1;
val LListD_Fun_diag_I = result();


(*** Finality of LList(A): Uniqueness of functions defined by corecursion ***)

(*abstract proof using a bisimulation*)
val [prem1,prem2] = goal LList.thy
 "[| !!x. h1(x) = case(f(x), %u.NIL, %v. split(v, %z w. CONS(z,h1(w))));   \
\    !!x. h2(x) = case(f(x), %u.NIL, %v. split(v, %z w. CONS(z,h2(w)))) |] \
\ ==> h1=h2";
by (rtac ext 1);
(*next step avoids an unknown (and flexflex pair) in simplification*)
by (res_inst_tac [("A", "{u.True}"),
		  ("r", "range(%u. <h1(u),h2(u)>)")] LList_equalityI 1);
by (rtac rangeI 1);
by (safe_tac set_cs);
by (stac prem1 1);
by (stac prem2 1);
by (simp_tac (llist_ss addsimps [LListD_Fun_NIL_I, range_eqI,
				 CollectI RS LListD_Fun_CONS_I]) 1);
(* 9.5 vs 9.2/4.1/4.3
by (ASM_SIMP_TAC (llist_ss addsimps [LListD_Fun_NIL_I, rangeI,
				    CollectI RS LListD_Fun_CONS_I]) 1);*)
val LList_corec_unique = result();

val [prem] = goal LList.thy
 "[| !!x. h(x) = case(f(x), %u.NIL, %v. split(v, %z w. CONS(z,h(w)))) |] \
\ ==> h = (%x.LList_corec(x,f))";
by (rtac (LList_corec RS (prem RS LList_corec_unique)) 1);
val equals_LList_corec = result();


(** Obsolete LList_corec_unique proof: complete induction, not coinduction **)

goalw LList.thy [CONS_def] "ntrunc(Suc(0), CONS(M,N)) = {}";
by (rtac ntrunc_one_In1 1);
val ntrunc_one_CONS = result();

goalw LList.thy [CONS_def]
    "ntrunc(Suc(Suc(k)), CONS(M,N)) = CONS (ntrunc(k,M), ntrunc(k,N))";
by (simp_tac (HOL_ss addsimps [ntrunc_Scons,ntrunc_In1]) 1);
val ntrunc_CONS = result();

val [prem1,prem2] = goal LList.thy
 "[| !!x. h1(x) = case(f(x), %u.NIL, %v. split(v, %z w. CONS(z,h1(w))));  \
\    !!x. h2(x) = case(f(x), %u.NIL, %v. split(v, %z w. CONS(z,h2(w)))) |] \
\ ==> h1=h2";
by (rtac (ntrunc_equality RS ext) 1);
by (res_inst_tac [("x", "x")] spec 1);
by (res_inst_tac [("n", "k")] less_induct 1);
by (rtac allI 1);
by (stac prem1 1);
by (stac prem2 1);
by (simp_tac (sum_ss setloop (split_tac [expand_split,expand_case])) 1);
by (strip_tac 1);
by (res_inst_tac [("n", "n")] natE 1);
by (res_inst_tac [("n", "xc")] natE 2);
by (ALLGOALS(asm_simp_tac(nat_ss addsimps
            [ntrunc_0,ntrunc_one_CONS,ntrunc_CONS])));
val LList_corec_unique = result();


(*** Lconst -- defined directly using lfp, but equivalent to a LList_corec ***)

goal LList.thy "mono(CONS(M))";
by (REPEAT (ares_tac [monoI, subset_refl, CONS_mono] 1));
val Lconst_fun_mono = result();

(* Lconst(M) = CONS(M,Lconst(M)) *)
val Lconst = standard (Lconst_fun_mono RS (Lconst_def RS def_lfp_Tarski));

(*A typical use of co-induction to show membership in the gfp.
  The containing set is simply the singleton {Lconst(M)}. *)
goal LList.thy "!!M A. M:A ==> Lconst(M): LList(A)";
by (rtac (singletonI RS LList_coinduct) 1);
by (safe_tac set_cs);
by (res_inst_tac [("P", "%u. u: ?A")] (Lconst RS ssubst) 1);
by (REPEAT (ares_tac [List_Fun_CONS_I, singletonI, UnI1] 1));
val Lconst_type = result();

goal LList.thy "Lconst(M) = LList_corec(M, %x.Inr(<x,x>))";
by (rtac (equals_LList_corec RS fun_cong) 1);
by (simp_tac sum_ss 1);
by (rtac Lconst 1);
val Lconst_eq_LList_corec = result();

(*Thus we could have used gfp in the definition of Lconst*)
goal LList.thy "gfp(%N. CONS(M, N)) = LList_corec(M, %x.Inr(<x,x>))";
by (rtac (equals_LList_corec RS fun_cong) 1);
by (simp_tac sum_ss 1);
by (rtac (Lconst_fun_mono RS gfp_Tarski) 1);
val gfp_Lconst_eq_LList_corec = result();


(** Introduction rules for LList constructors **)

(* c : {Numb(0)} <+> A <*> LList(A) ==> c : LList(A) *)
val LListI = LList_unfold RS equalityD2 RS subsetD;

(*This justifies the type definition: LList(A) is nonempty.*)
goalw LList.thy [NIL_def] "NIL: LList(A)";
by (rtac (singletonI RS usum_In0I RS LListI) 1);
val NIL_LListI = result();

val prems = goalw LList.thy [CONS_def]
    "[| M: A;  N: LList(A) |] ==> CONS(M,N) : LList(A)";
by (rtac (uprodI RS usum_In1I RS LListI) 1);
by (REPEAT (resolve_tac prems 1));
val CONS_LListI = result();

(*** Isomorphisms ***)

goal LList.thy "inj(Rep_LList)";
by (rtac inj_inverseI 1);
by (rtac Rep_LList_inverse 1);
val inj_Rep_LList = result();

goal LList.thy "inj_onto(Abs_LList,LList(range(Leaf)))";
by (rtac inj_onto_inverseI 1);
by (etac Abs_LList_inverse 1);
val inj_onto_Abs_LList = result();

(** Distinctness of constructors **)

goalw LList.thy [LNil_def,LCons_def] "~ LCons(x,xs) = LNil";
by (rtac (CONS_not_NIL RS (inj_onto_Abs_LList RS inj_onto_contraD)) 1);
by (REPEAT (resolve_tac [rangeI, NIL_LListI, CONS_LListI, Rep_LList] 1));
val LCons_not_LNil = result();

val LNil_not_LCons = standard (LCons_not_LNil RS not_sym);

val LCons_neq_LNil = standard (LCons_not_LNil RS notE);
val LNil_neq_LCons = sym RS LCons_neq_LNil;

(** llist constructors **)

goalw LList.thy [LNil_def]
    "Rep_LList(LNil) = NIL";
by (rtac (NIL_LListI RS Abs_LList_inverse) 1);
val Rep_LList_LNil = result();

goalw LList.thy [LCons_def]
    "Rep_LList(LCons(x,l)) = CONS(Leaf(x),Rep_LList(l))";
by (REPEAT (resolve_tac [CONS_LListI RS Abs_LList_inverse,
			 rangeI, Rep_LList] 1));
val Rep_LList_LCons = result();

(** Injectiveness of CONS and LCons **)

goalw LList.thy [CONS_def] "(CONS(M,N)=CONS(M',N')) = (M=M' & N=N')";
by (fast_tac (HOL_cs addSEs [Scons_inject, make_elim In1_inject]) 1);
val CONS_CONS_eq = result();

val CONS_inject = standard (CONS_CONS_eq RS iffD1 RS conjE);


(*For reasoning about abstract llist constructors*)
val LList_cs = set_cs addIs [Rep_LList, NIL_LListI, CONS_LListI]
	              addSEs [CONS_neq_NIL,NIL_neq_CONS,CONS_inject]
		      addSDs [inj_onto_Abs_LList RS inj_ontoD,
			      inj_Rep_LList RS injD, Leaf_inject];

goalw LList.thy [LCons_def] "(LCons(x,xs)=LCons(y,ys)) = (x=y & xs=ys)";
by (fast_tac LList_cs 1);
val LCons_LCons_eq = result();
val LCons_inject = standard (LCons_LCons_eq RS iffD1 RS conjE);

val [major] = goal LList.thy "CONS(M,N): LList(A) ==> M: A & N: LList(A)";
by (rtac (major RS LListE) 1);
by (etac CONS_neq_NIL 1);
by (fast_tac LList_cs 1);
val CONS_D = result();


(****** Reasoning about LList(A) ******)

val List_case_simps = [List_case_NIL, List_case_CONS];
val List_case_ss = llist_ss addsimps List_case_simps;

(*A special case of list_equality for functions over lazy lists*)
val [MList,gMList,NILcase,CONScase] = goal LList.thy
 "[| M: LList(A); g(NIL): LList(A); 				\
\    f(NIL)=g(NIL);						\
\    !!x l. [| x:A;  l: LList(A) |] ==>				\
\	    <f(CONS(x,l)),g(CONS(x,l))> :			\
\               LListD_Fun(diag(A), (%u.<f(u),g(u)>)``LList(A) Un  \
\                                   diag(LList(A)))		\
\ |] ==> f(M) = g(M)";
by (rtac LList_equalityI 1);
br (MList RS imageI) 1;
by (rtac subsetI 1);
by (etac imageE 1);
by (etac ssubst 1);
by (etac LListE 1);
by (etac ssubst 1);
by (stac NILcase 1);
br (gMList RS LListD_Fun_diag_I) 1;
by (etac ssubst 1);
by (REPEAT (ares_tac [CONScase] 1));
val LList_fun_equalityI = result();


(*** The functional "Lmap" ***)

goal LList.thy "Lmap(f,NIL) = NIL";
by (rtac (Lmap_def RS def_LList_corec RS trans) 1);
by (simp_tac List_case_ss 1);
val Lmap_NIL = result();

goal LList.thy "Lmap(f, CONS(M,N)) = CONS(f(M), Lmap(f,N))";
by (rtac (Lmap_def RS def_LList_corec RS trans) 1);
by (simp_tac List_case_ss 1);
val Lmap_CONS = result();

(*Another type-checking proof by coinduction*)
val [major,minor] = goal LList.thy
    "[| M: LList(A);  !!x. x:A ==> f(x):B |] ==> Lmap(f,M): LList(B)";
by (rtac (major RS imageI RS LList_coinduct) 1);
by (safe_tac set_cs);
by (etac LListE 1);
by (ALLGOALS (asm_simp_tac (HOL_ss addsimps [Lmap_NIL,Lmap_CONS])));
by (REPEAT (ares_tac [List_Fun_NIL_I, List_Fun_CONS_I, 
		      minor, imageI, UnI1] 1));
val Lmap_type = result();

(*This type checking rule synthesises a sufficiently large set for f*)
val [major] = goal LList.thy  "M: LList(A) ==> Lmap(f,M): LList(f``A)";
by (rtac (major RS Lmap_type) 1);
by (etac imageI 1);
val Lmap_type2 = result();

(** Two easy results about Lmap **)

val [prem] = goal LList.thy
    "M: LList(A) ==> Lmap(f o g, M) = Lmap(f, Lmap(g, M))";
by (rtac (prem RS imageI RS LList_equalityI) 1);
by (stac o_def 1);
by (safe_tac set_cs);
by (etac LListE 1);
by (ALLGOALS (asm_simp_tac (HOL_ss addsimps [Lmap_NIL,Lmap_CONS])));
by (REPEAT (ares_tac [LListD_Fun_NIL_I, imageI, UnI1,
		      rangeI RS LListD_Fun_CONS_I] 1));
val Lmap_compose = result();

val [prem] = goal LList.thy "M: LList(A) ==> Lmap(%x.x, M) = M";
by (rtac (prem RS imageI RS LList_equalityI) 1);
by (safe_tac set_cs);
by (etac LListE 1);
by (ALLGOALS (asm_simp_tac (HOL_ss addsimps [Lmap_NIL,Lmap_CONS])));
by (REPEAT (ares_tac [LListD_Fun_NIL_I, imageI RS UnI1,
		      rangeI RS LListD_Fun_CONS_I] 1));
val Lmap_ident = result();


(*** Lappend -- its two arguments cause some complications! ***)

goalw LList.thy [Lappend_def] "Lappend(NIL,NIL) = NIL";
by (rtac (LList_corec RS trans) 1);
(* takes 2.4(3.4 w NORM) vs 0.9 w/o NORM terms *)
by (simp_tac List_case_ss 1);
(*by (SIMP_TAC List_case_ss 1);*)
val Lappend_NIL_NIL = result();

goalw LList.thy [Lappend_def]
    "Lappend(NIL,CONS(N,N')) = CONS(N, Lappend(NIL,N'))";
by (rtac (LList_corec RS trans) 1);
(* takes 5(7 w NORM) vs 2.1 w/o NORM terms *)
by (simp_tac List_case_ss 1);
(*by (SIMP_TAC List_case_ss 1);*)
val Lappend_NIL_CONS = result();

goalw LList.thy [Lappend_def]
    "Lappend(CONS(M,M'), N) = CONS(M, Lappend(M',N))";
by (rtac (LList_corec RS trans) 1);
(* takes 4.9(6.7) vs 2.2 w/o NORM terms *)
by (simp_tac List_case_ss 1);
(*by (SIMP_TAC List_case_ss 1);*)
val Lappend_CONS = result();

val Lappend_ss = List_case_ss addsimps
                 [NIL_LListI, Lappend_NIL_NIL, Lappend_NIL_CONS,
	          Lappend_CONS, image_eqI, LListD_Fun_CONS_I];

goal LList.thy "!!M. M: LList(A) ==> Lappend(NIL,M) = M";
by (etac LList_fun_equalityI 1);
by (ALLGOALS (asm_simp_tac Lappend_ss));
val Lappend_NIL = result();

goal LList.thy "!!M. M: LList(A) ==> Lappend(M,NIL) = M";
by (etac LList_fun_equalityI 1);
by (ALLGOALS (asm_simp_tac Lappend_ss));
val Lappend_NIL2 = result();

(** Alternative type-checking proofs for Lappend **)

(*weak co-induction: bisimulation and case analysis on both variables*)
goal LList.thy
    "!!M N. [| M: LList(A); N: LList(A) |] ==> Lappend(M,N): LList(A)";
by (res_inst_tac
    [("X", "UN u:LList(A). UN v: LList(A). {Lappend(u,v)}")] LList_coinduct 1);
by (fast_tac set_cs 1);
by (safe_tac set_cs);
by (eres_inst_tac [("L", "u")] LListE 1);
by (eres_inst_tac [("L", "v")] LListE 1);
(* 7/12 vs 7.8/13.3/8.2/13.4 *)
by (ALLGOALS
    (asm_simp_tac Lappend_ss THEN'
     fast_tac (set_cs addSIs [NIL_LListI,List_Fun_NIL_I,List_Fun_CONS_I]) ));
(*
by (REPEAT 
    (ASM_SIMP_TAC Lappend_ss 1 THEN
     fast_tac (set_cs addSIs [NIL_LListI,List_Fun_NIL_I,List_Fun_CONS_I])1));
*)
val Lappend_type = result();

(*strong co-induction: bisimulation and case analysis on one variable*)
goal LList.thy
    "!!M N. [| M: LList(A); N: LList(A) |] ==> Lappend(M,N): LList(A)";
by (res_inst_tac [("X", "(%u.Lappend(u,N))``LList(A)")] LList_coinduct 1);
be imageI 1;
br subsetI 1;
be imageE 1;
by (eres_inst_tac [("L", "u")] LListE 1);
by (asm_simp_tac (Lappend_ss addsimps [Lappend_NIL, List_Fun_LList_I]) 1);
by (asm_simp_tac Lappend_ss 1);
by (fast_tac (set_cs addSIs [List_Fun_CONS_I]) 1);
val Lappend_type = result();

(**** Lazy lists as the type 'a llist -- strongly typed versions of above ****)

(** llist_case: case analysis for 'a llist **)

val Rep_LList_simps =
                [List_case_NIL, List_case_CONS, 
		 Abs_LList_inverse, Rep_LList_inverse, NIL_LListI, CONS_LListI,
		 Rep_LList, rangeI, inj_Leaf, Inv_f_f];
val Rep_LList_ss = llist_ss addsimps Rep_LList_simps;

goalw LList.thy [llist_case_def,LNil_def]  "llist_case(LNil, c, d) = c";
by (simp_tac Rep_LList_ss 1);
val llist_case_LNil = result();

goalw LList.thy [llist_case_def,LCons_def]
    "llist_case(LCons(M,N), c, d) = d(M,N)";
by (simp_tac Rep_LList_ss 1);
val llist_case_LCons = result();

(*Elimination is case analysis, not induction.*)
val [prem1,prem2] = goalw LList.thy [NIL_def,CONS_def]
    "[| l=LNil ==> P;  !!x l'. l=LCons(x,l') ==> P \
\    |] ==> P";
by (rtac (Rep_LList RS LListE) 1);
by (rtac (inj_Rep_LList RS injD RS prem1) 1);
by (stac Rep_LList_LNil 1);
by (assume_tac 1);
by (etac rangeE 1);
by (rtac (inj_Rep_LList RS injD RS prem2) 1);
by (asm_simp_tac (HOL_ss addsimps [Rep_LList_LCons]) 1);
by (etac (Abs_LList_inverse RS ssubst) 1);
by (rtac refl 1);
val llistE = result();

(** llist_corec: corecursion for 'a llist **)

goalw LList.thy [llist_corec_def,LNil_def,LCons_def]
    "llist_corec(a,f) = case(f(a), %u. LNil, \
\			     %v. split(v, %z w. LCons(z, llist_corec(w,f))))";
by (stac LList_corec 1);
by (res_inst_tac [("s","f(a)")] sumE 1);
by (asm_simp_tac (llist_ss addsimps [LList_corec_type2,Abs_LList_inverse]) 1);
by (res_inst_tac [("p","y")] PairE 1);
by (asm_simp_tac (llist_ss addsimps [LList_corec_type2,Abs_LList_inverse]) 1);
(*FIXME: correct case splits usd to be found automatically:
by (ASM_SIMP_TAC(llist_ss addsimps [LList_corec_type2,Abs_LList_inverse]) 1);*)
val llist_corec = result();

(*definitional version of same*)
val [rew] = goal LList.thy
    "[| !!x. h(x) == llist_corec(x,f) |] ==>	\
\    h(a) = case(f(a), %u.LNil, %v. split(v, %z w. LCons(z, h(w))))";
by (rewtac rew);
by (rtac llist_corec 1);
val def_llist_corec = result();

(**** Proofs about type 'a llist functions ****)

(*** Deriving llist_equalityI -- llist equality is a bisimulation ***)

val prems = goalw LList.thy [LListD_Fun_def]
    "r <= Sigma(LList(A), %x.LList(A)) ==> \
\    LListD_Fun(diag(A),r) <= Sigma(LList(A), %x.LList(A))";
by (stac LList_unfold 1);
by (cut_facts_tac prems 1);
by (fast_tac univ_cs 1);
val LListD_Fun_subset_Sigma_LList = result();

goal LList.thy
    "prod_fun(Rep_LList,Rep_LList) `` r <= \
\    Sigma(LList(range(Leaf)), %x.LList(range(Leaf)))";
by (fast_tac (set_cs addSEs [prod_fun_imageE] addIs [SigmaI, Rep_LList]) 1);
val subset_Sigma_LList = result();

val [prem] = goal LList.thy
    "r <= Sigma(LList(range(Leaf)), %x.LList(range(Leaf))) ==> \
\    prod_fun(Rep_LList o Abs_LList, Rep_LList o Abs_LList) `` r <= r";
by (safe_tac (set_cs addSEs [prod_fun_imageE]));
by (rtac (prem RS subsetD RS SigmaE2) 1);
by (assume_tac 1);
by (asm_simp_tac (HOL_ss addsimps [o_def,prod_fun,Abs_LList_inverse]) 1);
val prod_fun_lemma = result();

goal LList.thy
    "prod_fun(Rep_LList, Rep_LList) `` range(%x. <x, x>) = \
\    diag(LList(range(Leaf)))";
br equalityI 1;
by (fast_tac (set_cs addIs  [diagI, Rep_LList]
		     addSEs [prod_fun_imageE, Pair_inject]) 1);
by (fast_tac (set_cs addIs  [prod_fun_imageI, rangeI]
		     addSEs [diagE, Abs_LList_inverse RS subst]) 1);
val prod_fun_range_eq_diag = result();

(** To show two llists are equal, exhibit a bisimulation! 
      [also admits true equality] **)
val [prem1,prem2] = goalw LList.thy [llistD_Fun_def]
    "[| <l1,l2> : r;  r <= llistD_Fun(r Un range(%x.<x,x>)) |] ==> l1=l2";
by (rtac (inj_Rep_LList RS injD) 1);
by (res_inst_tac [("r", "prod_fun(Rep_LList,Rep_LList)``r"),
		  ("A", "range(Leaf)")] 
	LList_equalityI 1);
by (rtac (prem1 RS prod_fun_imageI) 1);
by (rtac (prem2 RS image_mono RS subset_trans) 1);
by (rtac (image_compose RS subst) 1);
by (rtac (prod_fun_compose RS subst) 1);
by (rtac (image_Un RS ssubst) 1);
by (stac prod_fun_range_eq_diag 1);
by (rtac (LListD_Fun_subset_Sigma_LList RS prod_fun_lemma) 1);
by (rtac (subset_Sigma_LList RS Un_least) 1);
by (rtac diag_subset_Sigma 1);
val llist_equalityI = result();

(** Rules to prove the 2nd premise of llist_equalityI **)
goalw LList.thy [llistD_Fun_def,LNil_def] "<LNil,LNil> : llistD_Fun(r)";
by (rtac (LListD_Fun_NIL_I RS prod_fun_imageI) 1);
val llistD_Fun_LNil_I = result();

val [prem] = goalw LList.thy [llistD_Fun_def,LCons_def]
    "<l1,l2>:r ==> <LCons(x,l1), LCons(x,l2)> : llistD_Fun(r)";
by (rtac (rangeI RS LListD_Fun_CONS_I RS prod_fun_imageI) 1);
by (rtac (prem RS prod_fun_imageI) 1);
val llistD_Fun_LCons_I = result();

(*Utilise the "strong" part, i.e. gfp(f)*)
goalw LList.thy [llistD_Fun_def]
     "!!l. <l,l> : llistD_Fun(r Un range(%x.<x,x>))";
br (Rep_LList_inverse RS subst) 1;
br prod_fun_imageI 1;
by (rtac (image_Un RS ssubst) 1);
by (stac prod_fun_range_eq_diag 1);
br (Rep_LList RS LListD_Fun_diag_I) 1;
val llistD_Fun_range_I = result();

(*A special case of list_equality for functions over lazy lists*)
val [prem1,prem2] = goal LList.thy
    "[| f(LNil)=g(LNil);						\
\       !!x l. <f(LCons(x,l)),g(LCons(x,l))> :				\
\              llistD_Fun(range(%u. <f(u),g(u)>) Un range(%v. <v,v>))	\
\    |]	==> f(l) = g(l :: 'a llist) :: 'b llist";
by (res_inst_tac [("r", "range(%u. <f(u),g(u)>)")] llist_equalityI 1);
by (rtac rangeI 1);
by (rtac subsetI 1);
by (etac rangeE 1);
by (etac ssubst 1);
by (res_inst_tac [("l", "u")] llistE 1);
by (etac ssubst 1);
by (stac prem1 1);
by (rtac llistD_Fun_range_I 1);
by (etac ssubst 1);
by (rtac prem2 1);
val llist_fun_equalityI = result();

(*simpset for llist bisimulations*)
val llistD_simps = [llist_case_LNil, llist_case_LCons, range_eqI,
		    llistD_Fun_LNil_I, llistD_Fun_LCons_I];
val llistD_ss = llist_ss addsimps llistD_simps;


(*** The functional "lmap" ***)

goal LList.thy "lmap(f,LNil) = LNil";
by (rtac (lmap_def RS def_llist_corec RS trans) 1);
by (simp_tac llistD_ss 1);
val lmap_LNil = result();

goal LList.thy "lmap(f, LCons(M,N)) = LCons(f(M), lmap(f,N))";
by (rtac (lmap_def RS def_llist_corec RS trans) 1);
by (simp_tac llistD_ss 1);
val lmap_LCons = result();


(** Two easy results about lmap **)

goal LList.thy "lmap(f o g, l) = lmap(f, lmap(g, l))";
by (res_inst_tac [("l","l")] llist_fun_equalityI 1);
by (ALLGOALS (simp_tac (llistD_ss addsimps [lmap_LNil, lmap_LCons])));
val lmap_compose = result();

goal LList.thy "lmap(%x.x, l) = l";
by (res_inst_tac [("l","l")] llist_fun_equalityI 1);
by (ALLGOALS (simp_tac (llistD_ss addsimps [lmap_LNil, lmap_LCons])));
val lmap_ident = result();


(*** iterates -- llist_fun_equalityI cannot be used! ***)

goal LList.thy "iterates(f,x) = LCons(x, iterates(f,f(x)))";
by (rtac (iterates_def RS def_llist_corec RS trans) 1);
by (simp_tac sum_ss 1);
val iterates = result();

goal LList.thy "lmap(f, iterates(f,x)) = iterates(f,f(x))";
by (res_inst_tac [("r", "range(%u.<lmap(f,iterates(f,u)),iterates(f,f(u))>)")] 
    llist_equalityI 1);
by (rtac rangeI 1);
by (safe_tac set_cs);
by (res_inst_tac [("x1", "f(u)")] (iterates RS ssubst) 1);
by (res_inst_tac [("x1", "u")] (iterates RS ssubst) 1);
by (simp_tac (llistD_ss addsimps [lmap_LCons]) 1);
val lmap_iterates = result();

goal LList.thy "iterates(f,x) = LCons(x, lmap(f, iterates(f,x)))";
br (lmap_iterates RS ssubst) 1;
br iterates 1;
val iterates_lmap = result();

(*** A rather complex proof about iterates -- cf Andy Pitts ***)

(** Two lemmas about natrec(n,x,%m.g), which is essentially (g^n)(x) **)

goal LList.thy
    "nat_rec(n, LCons(b, l), %m. lmap(f)) =	\
\    LCons(nat_rec(n, b, %m. f), nat_rec(n, l, %m. lmap(f)))";
by (nat_ind_tac "n" 1);
by (ALLGOALS (asm_simp_tac (nat_ss addsimps [lmap_LCons])));
val fun_power_lmap = result();

goal Nat.thy "nat_rec(n, g(x), %m. g) = nat_rec(Suc(n), x, %m. g)";
by (nat_ind_tac "n" 1);
by (ALLGOALS (asm_simp_tac nat_ss));
val fun_power_Suc = result();

val Pair_cong = read_instantiate_sg (sign_of Prod.thy)
 [("f","Pair")] (standard(refl RS cong RS cong));

(*The bisimulation consists of {<lmap(f)^n (h(u)), lmap(f)^n (iterates(f,u))>}
  for all u and all n::nat.*)
val [prem] = goal LList.thy
    "(!!x. h(x) = LCons(x, lmap(f,h(x)))) ==> h = iterates(f)";
br ext 1;
by (res_inst_tac [("r", 
   "UN u. range(%n. <nat_rec(n, h(u), %m y.lmap(f,y)), \
\                  nat_rec(n, iterates(f,u), %m y.lmap(f,y))>)")] 
    llist_equalityI 1);
by (REPEAT (resolve_tac [UN1_I, range_eqI, Pair_cong, nat_rec_0 RS sym] 1));
by (safe_tac set_cs);
by (stac iterates 1);
by (stac prem 1);
by (stac fun_power_lmap 1);
by (stac fun_power_lmap 1);
br llistD_Fun_LCons_I 1;
by (rtac (lmap_iterates RS subst) 1);
by (stac fun_power_Suc 1);
by (stac fun_power_Suc 1);
br (UN1_I RS UnI1) 1;
br rangeI 1;
val iterates_equality = result();


(*** lappend -- its two arguments cause some complications! ***)

goalw LList.thy [lappend_def] "lappend(LNil,LNil) = LNil";
by (rtac (llist_corec RS trans) 1);
by (simp_tac llistD_ss 1);
val lappend_LNil_LNil = result();

goalw LList.thy [lappend_def]
    "lappend(LNil,LCons(l,l')) = LCons(l, lappend(LNil,l'))";
by (rtac (llist_corec RS trans) 1);
by (simp_tac llistD_ss 1);
(* 3.3(5.7) vs 1.3 !by (SIMP_TAC llistD_ss 1);*)
val lappend_LNil_LCons = result();

goalw LList.thy [lappend_def]
    "lappend(LCons(l,l'), N) = LCons(l, lappend(l',N))";
by (rtac (llist_corec RS trans) 1);
by (simp_tac llistD_ss 1);
(* 5(5.5) vs 1.3 !by (SIMP_TAC llistD_ss 1);*)
val lappend_LCons = result();

goal LList.thy "lappend(LNil,l) = l";
by (res_inst_tac [("l","l")] llist_fun_equalityI 1);
by (ALLGOALS (simp_tac (llistD_ss addsimps [lappend_LNil_LNil,
                                            lappend_LNil_LCons])));
val lappend_LNil = result();

goal LList.thy "lappend(l,LNil) = l";
by (res_inst_tac [("l","l")] llist_fun_equalityI 1);
by (ALLGOALS (simp_tac(llistD_ss addsimps [lappend_LNil_LNil,lappend_LCons])));
val lappend_LNil2 = result();

(*The infinite first argument blocks the second*)
goal LList.thy "lappend(iterates(f,x), N) = iterates(f,x)";
by (res_inst_tac [("r", "range(%u.<lappend(iterates(f,u),N),iterates(f,u)>)")] 
    llist_equalityI 1);
by (rtac rangeI 1);
by (safe_tac set_cs);
by (stac iterates 1);
by (simp_tac (llistD_ss addsimps [lappend_LCons]) 1);
val lappend_iterates = result();

(** Two proofs that lmap distributes over lappend **)

(*Long proof requiring case analysis on both both arguments*)
goal LList.thy "lmap(f, lappend(l,n)) = lappend(lmap(f,l), lmap(f,n))";
by (res_inst_tac 
    [("r",  
      "UN n. range(%l.<lmap(f,lappend(l,n)), lappend(lmap(f,l),lmap(f,n))>)")] 
    llist_equalityI 1);
by (rtac UN1_I 1);
by (rtac rangeI 1);
by (safe_tac set_cs);
by (res_inst_tac [("l", "l")] llistE 1);
by (res_inst_tac [("l", "n")] llistE 1);
by (ALLGOALS (asm_simp_tac (llistD_ss addsimps
      [lappend_LNil_LNil,lappend_LCons,lappend_LNil_LCons,
       lmap_LNil,lmap_LCons])));
by (REPEAT_SOME (ares_tac [llistD_Fun_LCons_I, UN1_I RS UnI1, rangeI]));
by (rtac range_eqI 1);
by (rtac (refl RS Pair_cong) 1);
by (stac lmap_LNil 1);
by (rtac refl 1);
val lmap_lappend_distrib = result();

(*Shorter proof of theorem above using llist_equalityI as strong coinduction*)
goal LList.thy "lmap(f, lappend(l,n)) = lappend(lmap(f,l), lmap(f,n))";
by (res_inst_tac [("l","l")] llist_fun_equalityI 1);
by (simp_tac (llistD_ss addsimps [lappend_LNil, lmap_LNil])1);
by (simp_tac (llistD_ss addsimps [lappend_LCons, lmap_LCons]) 1);
val lmap_lappend_distrib = result();

(*Without strong coinduction, three case analyses might be needed*)
goal LList.thy "lappend(lappend(l1,l2) ,l3) = lappend(l1, lappend(l2,l3))";
by (res_inst_tac [("l","l1")] llist_fun_equalityI 1);
by (simp_tac (llistD_ss addsimps [lappend_LNil])1);
by (simp_tac (llistD_ss addsimps [lappend_LCons]) 1);
val lappend_assoc = result();
