;;; isa-load.el - Load definitions for Isabelle mode.
;;;
;;; Author:  David Aspinall <da@dcs.ed.ac.uk>
;;;
;;; $Id: isa-load.el,v 1.8 1994/02/23 19:03:23 da Exp $
;;;

(require 'isa-site)


;;; Developers' note:
;;; This file is the initial startup that all other files should
;;; require.  Load definitions for the whole package should appear here.
;;; The separation between this file and isa-site keeps isa-site 
;;; as small as possible - desirable since isa-site is loaded
;;; for every Emacs session.


;;; Compatibility 

(defvar isa-is-19 nil
  "non-nil if Emacs 19 or later.")

(defvar isa-emacs-version nil
  "Name of Emacs-version configuration file to use.")

(cond ((< (string-to-int emacs-version) 19)
       (setq isa-emacs-version 'isa-18))
      ((string-match "Lucid" emacs-version)
       (setq isa-emacs-version 'isa-lcd)
       (setq isa-is-19 t))
      (t
       (setq isa-emacs-version 'isa-19)
       (setq isa-is-19 t)))

(require isa-emacs-version)


;;; Autoloads

(autoload 'isa-thy-insert-template "isa-thy-mode"
	  "Insert template in theory file." t)
(autoload 'isa-batchify "isa-proofscript"
	  "Convert an interactive proofscript to a batch one." t)
(autoload 'isa-unbatchify "isa-proofscript"
	  "Convert a batch proofscript into an interactive one." t)

(autoload 'proofstate "isa-proofstate"
	  "Activate a proof state buffer." t nil)
(autoload 'listener   "isa-listener"
	  "Activate a listener buffer." t nil)
(autoload 'ruletable  "isa-ruletable"
	  "Activate a ruletable buffer." t nil)


;;; Global variables

(defvar isa-possible-associated-buffer-names
  '(proofstate listener ruletable))

(defvar isa-startup-defaults
  nil   			; be quiet by default.
  "List of symbol names of associated buffers to initialise by default
when starting an Isabelle session. 
Pick from isa-possible-associated-buffer-names.")



;;; Version

(load "isa-dist-stamp")					

(defconst isa-mode-version 
  ;; Let's make a pretty string from isa-dist-stamp.
  (concat
   "Isabelle Mode      Version "
   (progn
     (string-match ": \\(.*\\) \\$" isa-dist-stamp)
     (substring isa-dist-stamp (match-beginning 1) (match-end 1)))
   "        "
   (substring isa-dist-stamp 
	      (1+ (string-match ": " isa-dist-stamp (match-end 1))))))
   



(provide 'isa-load)

;;; isa-load.el ends here


;;; Local Variables:
;;; mode: emacs-lisp
;;; case-fold-search: nil
;;; comment-column: 56
;;; eval: (local-set-key "\C-c\C-c" 'eval-current-buffer)
;;; eval: (visit-tags-table "/home/da/lib/emacs/isa-mode/TAGS")
;;; End:
