;;; isa-lcd.el - Isabelle mode support for Lucid Emacs.
;;;
;;; Author:  David Aspinall <da@dcs.ed.ac.uk>
;;;
;;; $Id: isa-lcd.el,v 1.8 1994/02/19 20:48:16 da Exp $
;;;

;;; Version Specific functions...


(defun isa-ignore (&rest args)
  "Do nothing - interactively!"
  (interactive))
  
(defun isa-clear-mouse-bindings (keymap)
  ;; nil gives beep 
  (define-key keymap 'button1 'isa-ignore)
  (define-key keymap 'button2 'isa-ignore)
  (define-key keymap 'button3 'isa-ignore))

(fset 'isa-define-popup-key 'define-key)



;;;
;;; Backwards/FSF compatibility
;;;

(if (fboundp 'defalias)
    nil
  (fset 'defalias 'fset))

(if (fboundp 'define-function)
    nil					
  (fset 'define-function 'fset))

(if (boundp 'process-environment)
    nil
  (setq process-environment nil)
  (mapcar 
   (function 
    (lambda (nv)
      (setq process-environment
	    (cons (concat (car nv) "=" (cdr nv))
		  process-environment))))
   (getenv t))
  ;; this turns out not really to be good enough:
  ;; for comint 2.03 we'd need to provide advice
  ;; for setenv, getenv, ...
  )
  

;; Fix bug in 19.6

(defun shrink-window-if-larger-than-buffer (&optional window)
  "Shrink the WINDOW to be as small as possible to display its contents.
Do nothing if the buffer contains more lines than the present window height,
or if some of the window's contents are scrolled out of view,
or if the window is the only window of its frame."
  (interactive)
  (save-excursion
    (set-buffer (window-buffer window))
    (let ((w (selected-window)) ;save-window-excursion can't win
	  (buffer-file-name buffer-file-name)
	  (p (point))
	  (n 0)
	  (ignore-final-newline
	   ;; If buffer ends with a newline, ignore it when counting height
	   ;; unless point is after it.
	   (and (not (eobp))
		(eq ?\n (char-after (1- (point-max))))))
	  (window-min-height 0)
	  (buffer-read-only nil)
	  (modified (buffer-modified-p))
	  (buffer (current-buffer)))
      (if (and (< 1 (count-windows))
	       (pos-visible-in-window-p (point-min) window))
	  (unwind-protect
	      (progn
		(select-window (or window w))
		(goto-char (point-min))
		(while (pos-visible-in-window-p
			(- (point-max)
			   (if ignore-final-newline 1 0)))
		  ;; defeat file locking... don't try this at home, kids!
		  (setq buffer-file-name nil)
		  (insert ?\n) (setq n (1+ n)))
		(if (> n 0) (shrink-window (1- n))))
	    (delete-region (point-min) (point))
	    (set-buffer-modified-p modified)
	    (goto-char p)
	    (select-window w)
	    ;; Make sure we unbind buffer-read-only
	    ;; with the proper current buffer.
	    (set-buffer buffer))))))

(defun count-windows (&optional minibuf)
   "Returns the number of visible windows.
Optional arg NO-MINI non-nil means don't count the minibuffer
even if it is active."
   (let ((count 0))
     (walk-windows (function (lambda (w)
			       (setq count (+ count 1))))
		   minibuf)
     count))

;; Update v19.6 version of next-command-event.

(if (fboundp 'old-next-command-event)
    nil
  (fset 'old-next-command-event (symbol-function 'next-command-event))
  (defun next-command-event (&optional event)
"Returns the next available \"user\" event from the window system or terminal
driver.  Pass this object to dispatch-event to handle it.  If an event object
is supplied, it is filled in and returned, otherwise a new event object will
be created.

The event returned will be a keyboard, mouse press, or mouse release event.
If there are non-command events available (mouse motion, sub-process output,
etc) then these will be executed (with `dispatch-event') and discarded.  This
function is provided as a convenience; it is equivalent to the lisp code

	(while (progn
		 (next-event event)
	         (not (or (key-press-event-p event)
	                  (button-press-event-p event)
	                  (button-release-event-p event)
	                  (menu-event-p event))))
	   (dispatch-event event))"
    (if event
	(old-next-command-event event)
      (old-next-command-event (allocate-event)))))


(provide 'isa-lcd)

;;; End of isa-lcd.el
