;;; isa-compdefs.el - Dummy compatibility file to allow compile/run
;;;		      across different versions of Emacs.
;;;
;;; Author:  David Aspinall <da@dcs.ed.ac.uk>
;;;
;;; $Id: isa-compdefs.el,v 1.2 1994/02/23 21:15:57 da Exp $
;;;


;;; Notes:
;;; =====
;;;  1. This file is for use during compilation only
;;;  2. To compile isa-mode for use only under the same version 
;;;     of Emacs, change byte-compile-compatibility to nil.
;;;  3. Developers: turn the warnings back on! - they're useful.
;;;	(see bytecomp.el for details) 



;;; ===== Set byte compiler options =====

(setq byte-compile-compatibility t)	; Make compatible elc files.
(setq byte-compile-warning-types nil)   ; Suppress warnings. Careful!


;;; ===== Configure the compilation environment =====

(setq isa-emacs-version 'isa-compdefs)	; avoid isa-19,isa-18, etc.
(setq load-path (cons "." load-path))	; pick up right files
(setq isa-install-dir "<unset>")	; dummy installation directory

(defvar frame-initial-frame-alist nil)  ; prevents "definition is void"


;;; ===== For backwards compatibility =====

(eval-when-compile
  (if (fboundp 'defalias)
      nil
    (fset 'defalias 'fset))
  
  (if (fboundp 'define-function)
      nil
    (fset 'define-function 'fset)))





(provide 'isa-compdefs)

;;; End of isa-compdefs.el


