;;; isa-19.el - Isabelle mode support for FSF Emacs 19.
;;;
;;; Author:  David Aspinall <da@dcs.ed.ac.uk>
;;;
;;; $Id: isa-19.el,v 1.8 1994/02/21 20:27:12 da Exp $
;;;

(require 'isa-lucid)			; Version of lucid.el 
(require 'isa-easymenu)			; Version of easymenu.el
;(require 'powerkey)			; (Nice, but slow).


;;; Version-specific functions....

;; Clearout default mouse bindings from a keymap.

(defun isa-ignore (&rest args)
  "Ignore all args"
  (interactive))
  
(defun isa-clear-mouse-bindings (keymap)
  ;; 'undefined gives beep, nil doesn't seem to change
  ;; binding.
  (define-key keymap [mouse-1] 'isa-ignore)	 
  (define-key keymap [mouse-2] 'isa-ignore)	 
  (define-key keymap [mouse-3] 'isa-ignore)     
  (define-key keymap [down-mouse-1] 'isa-ignore)
  (define-key keymap [down-mouse-2] 'isa-ignore)
  (define-key keymap [down-mouse-3] 'isa-ignore)
  (define-key keymap [drag-mouse-1] 'isa-ignore)
  (define-key keymap [drag-mouse-2] 'isa-ignore)
  (define-key keymap [drag-mouse-3] 'isa-ignore)
  (define-key keymap [double-mouse-1] 'isa-ignore)
  (define-key keymap [triple-mouse-1] 'isa-ignore)
  (define-key keymap [down-mouse-3] 'isa-ignore))






;;; For Lucid compatibility.  (taken from lmenu.el)

(defun popup-menu (menu-desc)
  (let ((menu (easy-menu-create-keymaps (car menu-desc) (cdr menu-desc)))
	(pos (mouse-position))
	cmd answer)
    (while menu
      (setq answer (x-popup-menu (list (list (nth 1 pos) (nthcdr 2 pos))
				       (car pos))
				 menu))
      (setq cmd (lookup-key menu (vector answer)))
      (setq menu nil)
      (and cmd
	   (if (keymapp cmd)
	       (setq menu cmd)
	     (call-interactively cmd))))))


(defun set-buffer-menubar (menu)	
  ;; not quite the right thing, but...
  (if menu
      (define-key (current-local-map)
	[menu-bar]
	(easy-menu-create-keymaps (car menu) (cdr menu)))
    (define-key (current-local-map) [menu-bar buffer] 'undefined)
    (define-key (current-local-map) [menu-bar file] 'undefined)
    (define-key (current-local-map) [menu-bar edit] 'undefined)
    (define-key (current-local-map) [menu-bar help] 'undefined)))


;;; Change default key defs for cursor keys to
;;; correspond with keyboard control characters.
;;; (the way they're done in Lucid).

(define-key global-map [left]		"\C-b")
(define-key global-map [up]		"\C-p")
(define-key global-map [right]		"\C-f")
(define-key global-map [down]		"\C-n")




(provide 'isa-19)

;;; End of isa-19.el
