;;; isa-18.el - Isabelle Mode Support for Emacs 18.
;;;
;;; Author:  David Aspinall <da@dcs.ed.ac.uk>
;;;
;;; $Id: isa-18.el,v 1.6 1994/02/19 20:44:37 da Exp $
;;;

;;; Version-specific functions

(defun isa-clear-mouse-bindings (keymap))

(fset 'isa-define-popup-key 'define-key)


(defvar window-system nil)


;;;
;;; Now isa-mode specific addition of bits of Emacs 19...
;;;

;; Dummy functions 

(defvar default-menubar nil)
(defvar current-menubar nil)
(defun set-keymap-name (m n))
(defun make-obsolete (s s))
(defun make-face (s))
(defun face-differs-from-default-p (f &optional s))
(defun copy-face (s r &optional f n))
(defun set-buffer-menubar (b))
(defun popup-menu (menu-desc))
(defun abbreviate-file-name (f &optional h) f)
  


;; New functions


(defun member (elt list)
(cond ((null list) nil)
      ((equal elt (car list)) t)
      (t (member elt (cdr list)))))

(defun force-mode-line-update (&optional all)
  (set-buffer-modified-p (buffer-modified-p)))

(defun remprop (symbol prop)
  (let ((plist (symbol-plist symbol)))
    (while (eq (car plist) prop)
      (setplist symbol (setq plist (cdr (cdr plist)))))
    (while plist
      (if (eq (nth 2 plist) prop)
	  (setcdr (cdr plist) (nthcdr 4 plist)))
      (setq plist (cdr (cdr plist))))))

(defun add-hook (hook-var function &optional at-end)
"Add a function to a hook.
First argument HOOK-VAR (a symbol) is the name of a hook, second
 argument FUNCTION is the function to add.
Third (optional) argument AT-END means to add the function at the end
 of the hook list instead of the beginning.  If the function is already
 present, this has no effect.
Returns nil if FUNCTION was already present in HOOK-VAR, else new
 value of HOOK-VAR."
					;(interactive "SAdd to hook-var (symbol): \naAdd which function to %s? ")
(if (not (boundp hook-var)) (set hook-var nil))
(let ((old (symbol-value hook-var)))
  (if (or (not (listp old)) (eq (car old) 'lambda))
      (setq old (list old)))
  (if (member function old)
      nil
    (set hook-var
	 (if at-end
	     (append old (list function)) ; don't nconc
	   (cons function old))))))

(defun walk-windows (proc &optional minibuf all-frames)
  "Cycle through all visible windows, calling PROC for each one.
PROC is called with a window as argument.
Optional second arg MINIBUF t means count the minibuffer window
even if not active.  If MINIBUF is neither t nor nil it means
not to count the minibuffer even if it is active.

Optional third arg ALL-FRAMES, if t, means include all frames.
ALL-FRAMES nil or omitted means cycle within the selected frame,
but include the minibuffer window (if MINIBUF says so) that that
frame uses, even if it is on another frame.
If ALL-FRAMES is neither nil nor t, stick strictly to the selected frame."
  ;; If we start from the minibuffer window, don't fail to come back to it.
  (if (window-minibuffer-p (selected-window))
      (setq minibuf t))
  (let* ((walk-windows-start (selected-window))
	 (walk-windows-current walk-windows-start))
    (while (progn
	     (setq walk-windows-current
		   (next-window walk-windows-current minibuf all-frames))
	     (funcall proc walk-windows-current)
	     (not (eq walk-windows-current walk-windows-start))))))


(defun window-minibuffer-p (win) 
  nil)  ; often tell the truth, but occasionally lie


(defun shrink-window-if-larger-than-buffer (&optional window)
  "Shrink the WINDOW to be as small as possible to display its contents.
Do nothing if the buffer contains more lines than the present window height,
or if some of the window's contents are scrolled out of view,
or if the window is the only window of its frame."
  (interactive)
  (save-excursion
    (set-buffer (window-buffer window))
    (let ((w (selected-window)) ;save-window-excursion can't win
	  (buffer-file-name buffer-file-name)
	  (p (point))
	  (n 0)
	  (ignore-final-newline
	   ;; If buffer ends with a newline, ignore it when counting height
	   ;; unless point is after it.
	   (and (not (eobp))
		(eq ?\n (char-after (1- (point-max))))))
	  (window-min-height 0)
	  (buffer-read-only nil)
	  (modified (buffer-modified-p))
	  (buffer (current-buffer)))
      (if (and (< 1 (count-windows))
	       (pos-visible-in-window-p (point-min) window))
	  (unwind-protect
	      (progn
		(select-window (or window w))
		(goto-char (point-min))
		(while (pos-visible-in-window-p
			(- (point-max)
			   (if ignore-final-newline 1 0)))
		  ;; defeat file locking... don't try this at home, kids!
		  (setq buffer-file-name nil)
		  (insert ?\n) (setq n (1+ n)))
		(if (> n 0) (shrink-window (1- n))))
	    (delete-region (point-min) (point))
	    (set-buffer-modified-p modified)
	    (goto-char p)
	    (select-window w)
	    ;; Make sure we unbind buffer-read-only
	    ;; with the proper current buffer.
	    (set-buffer buffer))))))

(defun count-windows (&optional minibuf)
   "Returns the number of visible windows.
Optional arg NO-MINI non-nil means don't count the minibuffer
even if it is active."
   (let ((count 0))
     (walk-windows (function (lambda (w)
			       (setq count (+ count 1))))
		   minibuf)
     count))




;; New versions of old functions

(if (fboundp 'old-kill-buffer)
    nil
  (fset 'old-kill-buffer (symbol-function 'kill-buffer))
  (defun kill-buffer (bufname)
"Kill the buffer BUFFER.
The argument may be a buffer or may be the name of a buffer.
An argument of nil means kill the current buffer.

Value is t if the buffer is actually killed, nil if user says no.

The value of `kill-buffer-hook' (which may be local to that buffer),
if not void, is a list of functions to be called, with no arguments,
before the buffer is actually killed.  The buffer to be killed is current
when the hook functions are called.

Any processes that have this buffer as the `process-buffer' are killed
with `delete-process'."
    (interactive "bKill buffer: ")
    (save-excursion
      (set-buffer bufname)
      (run-hooks 'kill-buffer-hook))
    (old-kill-buffer bufname)))

(if (fboundp 'old-next-window)
    nil
  (fset 'old-next-window (symbol-function 'next-window))
  (defun next-window (&optional win mini allfs)
    (old-next-window win mini)))

(if (fboundp 'old-screen-width)
    nil
  (fset 'old-screen-width (symbol-function 'screen-width))
  (defun screen-width (&optional sc)
    (old-screen-width)))

(if (fboundp 'old-define-key)
    nil
  (fset 'old-define-key (symbol-function 'define-key))
  (defun define-key (m k d)
    (if (stringp k) (old-define-key m k d)
      nil)))

(if (fboundp 'old-get-buffer-window)
    nil
  (fset 'old-get-buffer-window (symbol-function 'get-buffer-window))
  (defun get-buffer-window (buf &rest args)
    (old-get-buffer-window buf)))

(if (fboundp 'old-mark)
    nil
  (fset 'old-mark (symbol-function 'mark))
  (defun mark (&optional i)
    (old-mark)))

(if (fboundp 'defalias)
    nil
  (fset 'defalias 'fset))

(if (fboundp 'define-function)
    nil
  (fset 'define-function 'fset))



(provide 'isa-18)

;;; End of isa-18.el
