;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: unify.lsp
;;; System: HIPER
;;; Programmer: Jim Christian
;;; Date: April, 1989
;;; Copyright (c) 1989 by Jim Christian.  All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Ordinary unification of flatterms.

;; Assumes vars of t2 and t1 have been renamed apart.
(proclaim '(function unify-terms (t t) t))
(with-stacks ((*stack* :stack))
(defun unify-terms (t1 t2 &aux (top 0) (sym1 0) (sym2 0) last
		       (stack (get-c-array *stack*)))
  (declare (type fixnum top sym1 sym2))
  (declare-c-array stack)

  (with-trail
   (c-stack-push t2 stack top)
   (c-stack-push t1 stack top)
   (block unify
     (until (zerop top)
       :return t
       (setf t1 (c-stack-pop stack top))
       (setf t2 (c-stack-pop stack top))
       (setf last (ft-next (ft-end t1)))
       (while (not (eq t1 last))
	 (setf sym1 (ft-symbol t1))
	 (setf sym2 (ft-symbol t2))
	 (cond
	  ((var? sym1)
	   (cond ((bound-var? sym1)
		  (c-stack-push t2 stack top)
		  (c-stack-push (var-binding sym1) stack top)
		  (setf t2 (ft-end t2)))
		 ((var? sym2)
		  (cond ((bound-var? sym2)
			 (c-stack-push (var-binding sym2) stack top)
			 (c-stack-push t1 stack top))
			((same-symbol? sym1 sym2) nil)
			(t (trail sym1)
			   (set-binding sym1 t2)
			   (setf t2 (ft-end t2)))))
		 ((occurs? sym1 t2)
		  (return-from unify nil))
		 (t (trail sym1)
		    (set-binding sym1 t2)
		    (setf t2 (ft-end t2)))))
	  ((var? sym2)
	   (cond ((bound-var? sym2)
		  (c-stack-push (var-binding sym2) stack top)
		  (c-stack-push t1 stack top)
		  (setf t1 (ft-end t1)))
		 ((occurs? sym2 t1)
		  (return-from unify nil))
		 (t
		  (trail sym2)
		  (set-binding sym2 t1)
		  (setf t1 (ft-end t1)))))
	  ((not (same-symbol? sym1 sym2))
	   (return-from unify nil)))
	 (setf t1 (ft-next t1))
	 (setf t2 (ft-next t2)))
       )))))


;; Occur check.
(proclaim '(function occurs? (fixnum t) t))
(with-stacks ((*stack* :stack))
(defun occurs? (sym1 t2 &aux (top 0)
		     (stack (get-c-array *stack*)))
  (declare (fixnum top))
  (declare-c-array stack)

  (c-stack-push t2 stack top)
  (until (zerop top)
    (setf t2 (c-stack-pop stack top))
    (do-ft t2
      (when (var? (ft-sym))
	    (when (same-symbol? (ft-sym) sym1)
		  (return-from occurs? t))
	    (when (bound-var? (ft-sym))
		  (c-stack-push (var-binding (ft-sym)) stack top)))))))
	       





