(proclaim '(function rebuild-nets-aux (t) nil))
(with-stacks ((*stack* :stack))
(defun rebuild-nets-aux (net &aux (stack (get-c-array *stack*))
			  (N (net-nodes net)) (B 0) lf
			  newslots oldslots)
  (declare (type (array t) stack))
  (declare (object stack))
  (declare (type (array t) newslots oldslots))
  (declare (type fixnum B))
  (declare (object oldslots))
  
  (block
   REBUILD
   (when (null N) (return-from rebuild-nets-aux))
   
   (macrolet
    ;; Choicepoint structure
    (
     (choice-N () `(c-aref stack B))
     (set-choice-N (x) `(c-aset stack B ,x))
     (next-choice () `(incf B 1))
     (prev-choice () `(decf B 1))
     (choice-stack-empty? () `(zerop B))
     )
    
    (prog
     ()
     TOP
     
     (setf newslots (new-slot-array))
     (setf oldslots (node-slots N))
     (floop :for SL :below (1- (the fixnum *slotarray-size*))
	:do (progn
	      (let ((old-slot (aref oldslots SL))
		    (new-slot (aref newslots SL)))
		(setf (slot-val new-slot) (slot-val old-slot))
		(free-cons old-slot)
		(setf (aref oldslots SL) nil)
		(if (node-p (slot-val new-slot))
		    (progn
		      (setf (node-prev-slot (slot-val new-slot)) new-slot)
		      (set-choice-N (slot-val new-slot))
		      (next-choice))
		  (progn
		    (setf lf (slot-val new-slot))
		    (while lf
		      (setf (leaf-parent-slot lf) new-slot)
		      (setf lf (leaf-next lf))))))))
     ;; Currently, oldslots becomes garbage that must be 
     ;; retrieved by the LISP garbage collector.
     (setf (node-slots N) newslots)

     BACKTRACK
     (when (zerop B) (return-from rebuild-nets-aux))
     (prev-choice)
     (setf N (choice-N))
     (go TOP)
     )))))

