;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: read.lsp
;;; System: HIPER
;;; Programmer: Jim Christian
;;; Date: April, 1989
;;; Copyright (c) 1989 by Jim Christian.  All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Input file loader.

;; Check for existence of the example directory.
(eval-when
 (load eval)
 (until
   #-symbolics (probe-file *example-directory*)
   #+symbolics (probe-file (concatenate 'string *example-directory*
					(substring *example-directory*
						   0
						   (1- (length
							 *example-directory*)))
					".directory"))
     (warn "Nonexistent directory path ~S!" *example-directory*)
     (cerror
      "Continue loading"
      "Please set the variable *example-directory* to a valid path.~%"
      ))
 
 (format  t "~%Using directory ~S for examples~%" *example-directory*)
 (format t "~%Using ~S as the default file extension for examples.~%"
	 *example-extension*)
 (format t "Change the variable *example-extension* if desired.~%~%")
 )

(defun expand-file-name (name)
  (concatenate 'string *example-directory* name *example-extension*))

(defun load-file (filename &aux eqs name)
  (clear-fsyms)
  (setf (eqn-counter) 0)
  (setf *support-set* nil)
  (setf name (expand-file-name filename))
  (with-open-file
   (fp name :direction :input)
   (do ((expr (read fp nil 'eof) (read fp nil 'eof)))
       ((eq expr 'eof))	
       (cond
	((not (consp expr))		;Ignore atoms
	 (warn "Ignoring input: ~S" expr))
	((eq (car expr) '$=)		;Set-of-support equation
	 (let ((e (parse-eqn expr)))
	   (free-conses expr)
	   (setf (eqn-supported e) t)
	   (setf *support-set* t)
	   (push1 e eqs)
	   (format t "~%~%Supported input equation ")
	   (print-eqn e)))
	((eq (car expr) '=)		;Equation
	 (let ((e (parse-eqn expr)))
	   (free-conses expr)
	   (setf (eqn-supported e) nil)
	   (push1 e eqs)
	   (format t "~%~%Input equation ")
	   (print-eqn e)))
	((eq (car expr) 'symbol)	;Symbol declaration
	 (apply #'declare-fsym (cdr expr))
	 (free-conses expr))
	((eq (car expr) 'precedence)	;Precedence relation
	 (parse-precedence (cdr expr))
	 (format t "~%Using precedence ")(print-precedence *precedence*)
	 (free-list expr))
	(t				;Arbitrary lisp expression
	 (format t "~%Evaluating: ~S" expr)
	 (eval expr)))
       ))
  ;; If no support set specified, assume all equations are supported.
  (unless *support-set*
	  (dolist (e eqs) (setf (eqn-supported e) t)))
  eqs)



