;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: parse.lsp
;;; System: HIPER
;;; Programmer: Jim Christian
;;; Date: April, 1989
;;; Copyright (c) 1989 by Jim Christian.  All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Parsing of flatterms, equations, and precedence relations.

(defvar *parse-vars* nil)
(defvar *parse-counter* 0)

(defun parse-eqn (X &aux e)
  (setf e (new-eqn))
  (setf (eqn-lhs e) (parse (second X)))
  (setf (eqn-rhs e) (parse-term (third X)))
  (setf (eqn-id e) (incf-eqn-counter))
  (setf (eqn-type e) '*new-pair*)
  e
  )

;; Parse a term into a flatterm, resetting any existing
;; variable name mapping.
(defun parse (X)
  (until (null *parse-vars*)
	 (let ((c (pop1 *parse-vars*)))
	   (free-cons c)))
  (setf *parse-counter* 0)
  (parse-term X))

;; Parse a term into a flatterm, building on any existing
;; variable mapping indicated by *parse-vars*
(defun parse-term (x)
  (cond ((atom x)
	 (let ((b (assoc x *parse-vars*)))
	   (if b
	       (get-ft (cdr b))
	     (progn
	       (push1 (cons1 x *parse-counter*) *parse-vars*)
	       (prog1 (get-ft *parse-counter*)
		 (incf *parse-counter*))))))
	(t
	 (let (ft)
	   (check-arity (car x) (length (cdr x)))
	   (setf ft (get-ft (get-fsym-id (car x))))
	   (dolist (v (cdr x))
		   (ft-append ft (parse-term v)))
	   ft))))

;; Parse a precedence relation
(defun parse-precedence (prec-list)
  (dolist (p prec-list)
	  (case (car p)
		(status
		 (push1 `(status ,(get-fsym-id (second p)) ,(third p))
			*precedence*))
		(>
		 (push1 `(> ,(get-fsym-id (second p))
			    ,(get-fsym-id (third p)))
			*precedence*))
		)))
	







