;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: orient.lsp
;;; System: HIPER
;;; Programmer: Jim Christian
;;; Date: April, 1989
;;; Copyright (c) 1989 by Jim Christian.  All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Top level hooks into ordering algorithms.

(proclaim '(function e-orient (t) t))
(defun e-orient (e)
  (or
   (case *which-order*
	 (kb (kb-orient e))
	 (kb-rpo (kb-rpo-orient e))
	 (rpo (rpo-orient e)))
   (user-orient e)))

;; Standard Knuth-Bendix ordering
(proclaim '(function kb-orient (t) t))
(defun kb-orient (e)
  (let ((i (kb-compare (eqn-lhs e) (eqn-rhs e))))
    (declare (type fixnum i))
    (cond
     ((< i 0) t)
     ((> i 0) (rotatef (eqn-lhs e) (eqn-rhs e)) t)
     (t nil))))

;; Knuth-Bendix ordering augmented with
;; part of recursive path ordering
(proclaim '(function kb-orient (t) t))
(defun kb-rpo-orient (e)
  (let ((i (kb-rpo-compare (eqn-lhs e) (eqn-rhs e))))
    (declare (type fixnum i))
    (cond
     ((< i 0) t)
     ((> i 0) (rotatef (eqn-lhs e) (eqn-rhs e)) t)
     (t nil))))

;; Useful for unfailing completion stuff.
(proclaim '(function e-greater (t t) t))
(defun e-greater (t1 t2)
  (case *which-order*
	(kb (= (kb-compare t1 t2) *lr*))
	(kb-rpo (= (kb-rpo-compare t1 t2) *lr*))
	;; Non-automatic rpo
	(rpo (rpo-greater t1 t2 *precedence*))))









