;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: init.lsp
;;; System: HIPER
;;; Programmer: Jim Christian
;;; Date: April, 1989
;;; Copyright (c) 1989 by Jim Christian.  All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "SLOOP")
(load "sloop")

(in-package "USER")
(import 'sloop::sloop)

(defvar *files* nil)
(eval-when (load eval)
	   (setf *files* 
		'("arrays" "misc" "globals" "defs" "symbols" "flatterms" 
		  "stacks" "heap" "copy" "parse" "print" "read"
		  "equal" "unify" "match" "eunify"
		  "permuters" "queues" "newf"
		  "nodes" "enodes" "reduce" "pairs" "nofail"
		  "kb" "rpo" "kbrpo" "autorpo" "orient"
		  "main"
		  )))

(defun current (file)
  (< (file-date (source-name file))
     (file-date (obj-name file))))
							       
(defun file-date (file)
  (if (probe-file file) (or (file-write-date file) 0) 0))

(defun source-name (file)
  #+symbolics (concatenate 'string file ".lisp")
  #-symbolics (concatenate 'string file ".lsp")
  )

(defun obj-name (file)
  #-symbolics (concatenate 'string file ".o")
  #+symbolics (concatenate 'string file ".bin")
  )

(defun compile-system ()
  ;; First, load all files to make sure all macros are loaded.
  (dolist (file *files*)
	  (load file))
  ;; Recompile any outdated files
  (dolist (file *files*)
	  (unless (current file)
		  (compile-file (source-name file))
		  (load (obj-name file)))))

(defun banner ()
  (format t "~%~%   ***********************************************************")
  (format t   "~%   *   HIPER: High-Performance Rewriting, by Jim Christian   *")
  (format t   "~%   *                      Version 1.0.1                      *")
  (format t   "~%   *                       April, 1989                       *")
  (format t   "~%   *                      Austin, Texas                      *")
  (format t   "~%   *                  Bug fix: February, 1992                *")
  (format t   "~%   ***********************************************************")
  (format t   "~%~%")
  )




(banner)
(when (y-or-n-p "Load and compile completion system?")
#+kcl (allocate 'cons 1000 t)
#+kcl (allocate 'fixnum 400 t)
#+kcl (allocate 'array 300 t)
#+kcl (allocate 'structure 150 t)
;; #+kcl (allocate-relocatable-pages 150)
      (unless (current "sloop")
	      (compile-file "sloop"))
      ;; Sloop proclaims (safety 2) (space 2)
      (proclaim '(optimize (safety 0) (space 0) (speed 3)))
      (compile-system)
      (format t "~%~% *** HIPER Loaded ***~%~%")
      )


