;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; File: defs.lsp
;;; System: HIPER
;;; Programmer: Jim Christian
;;; Date: April, 1989
;;; Copyright (c) 1989 by Jim Christian.  All rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Structure definitions

;; First-order terms are represented in HIPER using a linear, rather than
;; tree-like, data structure called a flatterm.  See my Ph.D. thesis for
;; a description of flatterms and their advantages.
(defstruct ft  
  symbol  ;Fixnum denoting index of variable or function symbol
  next    ;Immediate right symbol
  prev    ;Immediate left symbol
  end     ;Last symbol in subterm headed by this flatterm
  )
       
;; The basic equation.
(defstruct eqn
  lhs		;Left side
  rhs		;Right side
  id		;Unique integer tag
  priority1	;Primary queueing priority
  priority2	;Secondary queueing priority
  type		;*new-pair*, *pseudo-rule*, *failure*, or *rewrite-rule*
  fsym-def-p	;Definition of new function symbol?
  parents	;Parents from which this pair was derived.
  backpointers	;Pointers into discrimination net indices, for easy deletion
  next		;Next equation in queue
  prev		;Previous equation in queue
  queue		;To which queue do I belong?
  supported	;In support set?
  )

;; Discrimination tree node.
(defstruct node
  slots-used	;Number of slots in use
  prev-node	;Parent node in tree
  prev-slot	;Slot of prev-node which points to me
  slots		;Array of slots
  )

;; The node-slots of a node is an array.  Each element
;; of the array is a slot.
;; A slot is a cons cell, the cdr of which contains the
;; actual value for the slot.  Common Lisp doesn't
;; allow pointers to array elements, so we use
;; this representation to get a pointer to a slot.
(defmacro new-slot () `(cons1 '*slot* nil))
(defmacro slot-val (slot) `(cdr ,slot))

;; A discrimination net is a cons cell, the cdr of 
;; which points to a tree of nodes.
(defmacro new-net () `(cons1 '*net* nil))
(defmacro net-nodes (net) `(cdr ,net))
(defmacro net-p (slot) `(eq (car ,slot) '*net*))
    
;; At the end of a path in a discrimination tree,
;; there is a doubly-linked list of leaves, representing
;; all the subterms in the system with the same
;; structure as that represented by the path.
(defstruct leaf
  subterm	;Subterm associated with this leaf.
  eqn		;Equation containing the subterm
  parent-slot	;Slot of node pointing to me.
  parent-node	;Parent node
  prev		;Previous leaf in list
  next		;Next leaf in list
  )

;; A queue of equations
(defstruct queue
  head		;Dummy equation serves as head of queue
  tail		;Dummy equation serves as tail
  pfunc1	;Primary priority function
  pfunc2	;Secondary priority function
  index		;Optional index array.
  )

  
       



