#define IN_MAIN
#include "header.h"

/* #include <sys/time.h>
#include <sys/resource.h> */

#include <signal.h>

/*************
 *
 *	Based on:	  Otter 2.0
 *
 *                Automated Deduction System
 *             (C) Argonne National Laboratory
 *
 *   Argonne does not guarantee this software in any manner and is not
 *   responsible for any damages that may result from its use.
 *   Furthermore, Argonne does not provide any formal support for this
 *   software.  This is an experimental program.  The only restriction on
 *   copying and redistributing this software or any part of it is that
 *   this paragraph must be included.
 *
 *************/


main(argc,argv)
int argc;
char *argv[];
{
    int errors;

    printf(";; ----- OTTER to FRAPPS Translator 1.0, May 1991 -----");
    /* printf("Job run on %s", get_time()); */
    printf("\n");

    init();

    read_all_input();

    errors = Stats[INPUT_ERRORS];
    if (errors != 0) {
	fprintf(stderr, "\n%d input errors were found.\007\n\n", errors);
	printf("%d input errors were found.\n", errors);

	exit(1);
	}
    else {
	fprintf(stdout, "\n");
	fprintf(stdout, "(reset-frapps)\n");
	fprintf(stdout, "\n");
	if (Axioms->first_cl != NULL) {
		fprintf(stdout,";; Axioms in clausal form: \n");
		print_cl_list_lisp(stdout, Axioms, 0);
		fprintf(stdout, "\n");
		}
	if (Sos->first_cl != NULL) {
		fprintf(stdout,";; Set of Support in clausal form: \n");
		print_cl_list_lisp(stdout, Sos, 1);
		fprintf(stdout, "\n");
		}
	if (Passive->first_cl != NULL) {
		fprintf(stdout,";; Passive in clausal form: \n");
		print_cl_list_lisp(stdout, Passive, 0);
		}
	/* For debugging. */
	/* fprintf(stdout,"\nPrinting symbol list: \n");
	p_syms();
	fprintf(stdout,"\nPrinting term table: \n");
	print_term_tab(stdout); */

	fprintf(stdout, "\n");

	my_cleanup(); /* Clean all memory up, prints specified statistics. */

	}

}  /* main */

/*************
 *
 *    my_cleanup();
 *
 *************/

void my_cleanup()
{

    /* if (Flags[FREE_ALL_MEM].val) */
	free_all_mem();

}  /* my_cleanup */

